/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.KeysAndCert;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.LHMCache;
import net.i2p.util.SystemVersion;

public class Destination
extends KeysAndCert {
    private String _cachedB64;
    private static final int CACHE_SIZE;
    private static final int MIN_CACHE_SIZE = 32;
    private static final int MAX_CACHE_SIZE = 512;
    private static final Map<SigningPublicKey, Destination> _cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination create(InputStream in) throws DataFormatException, IOException {
        Destination rv;
        PublicKey pk = PublicKey.create(in);
        SigningPublicKey sk = SigningPublicKey.create(in);
        Certificate c = Certificate.create(in);
        Map<SigningPublicKey, Destination> map = _cache;
        synchronized (map) {
            rv = _cache.get(sk);
            if (rv != null && rv.getPublicKey().equals(pk) && rv.getCertificate().equals(c)) {
                return rv;
            }
            rv = new Destination(pk, sk, c);
            _cache.put(sk, rv);
        }
        return rv;
    }

    public Destination() {
    }

    public Destination(String s) throws DataFormatException {
        this.fromBase64(s);
    }

    private Destination(PublicKey pk, SigningPublicKey sk, Certificate c) {
        this._publicKey = pk;
        this._signingKey = sk;
        this._certificate = c;
    }

    public int writeBytes(byte[] target, int offset) {
        int cur = offset;
        System.arraycopy(this._publicKey.getData(), 0, target, cur, 256);
        System.arraycopy(this._signingKey.getData(), 0, target, cur += 256, SigningPublicKey.KEYSIZE_BYTES);
        cur += SigningPublicKey.KEYSIZE_BYTES;
        cur += this._certificate.writeBytes(target, cur);
        return cur - offset;
    }

    public int readBytes(byte[] source, int offset) throws DataFormatException {
        if (source == null) {
            throw new DataFormatException("Null source");
        }
        if (source.length <= offset + 256 + SigningPublicKey.KEYSIZE_BYTES) {
            throw new DataFormatException("Not enough data (len=" + source.length + " off=" + offset + ")");
        }
        if (this._publicKey != null || this._signingKey != null || this._certificate != null) {
            throw new IllegalStateException();
        }
        int cur = offset;
        this._publicKey = PublicKey.create(source, cur);
        this._signingKey = SigningPublicKey.create(source, cur += 256);
        this._certificate = Certificate.create(source, cur += SigningPublicKey.KEYSIZE_BYTES);
        return (cur += this._certificate.size()) - offset;
    }

    public int size() {
        return 256 + SigningPublicKey.KEYSIZE_BYTES + this._certificate.size();
    }

    public String toBase64() {
        if (this._cachedB64 == null) {
            this._cachedB64 = super.toBase64();
        }
        return this._cachedB64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<SigningPublicKey, Destination> map = _cache;
        synchronized (map) {
            _cache.clear();
        }
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        CACHE_SIZE = (int)Math.min(512L, Math.max(32L, maxMemory / 512L * 1024L));
        _cache = new LHMCache<SigningPublicKey, Destination>(CACHE_SIZE);
    }
}

