/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.crypto.CryptixRijndael_Algorithm;

public final class CryptixAESKeyCache {
    private final LinkedBlockingQueue<KeyCacheEntry> _availableKeys = new LinkedBlockingQueue(64);
    private static final int KEYSIZE = 32;
    private static final int BLOCKSIZE = 16;
    private static final int ROUNDS = CryptixRijndael_Algorithm.getRounds(32, 16);
    private static final int BC = 4;
    private static final int KC = 8;
    private static final int MAX_KEYS = 64;

    public final KeyCacheEntry acquireKey() {
        KeyCacheEntry rv = this._availableKeys.poll();
        if (rv != null) {
            return rv;
        }
        return CryptixAESKeyCache.createNew();
    }

    public final void releaseKey(KeyCacheEntry key) {
        this._availableKeys.offer(key);
    }

    public static final KeyCacheEntry createNew() {
        KeyCacheEntry e = new KeyCacheEntry();
        e.Ke = new int[ROUNDS + 1][4];
        e.Kd = new int[ROUNDS + 1][4];
        e.tk = new int[8];
        e.key = new Object[]{e.Ke, e.Kd};
        return e;
    }

    public static final class KeyCacheEntry {
        int[][] Ke;
        int[][] Kd;
        int[] tk;
        Object[] key;
    }
}

