/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Signature;
import net.i2p.util.Log;

public final class I2PDatagramDissector {
    private static final int DGRAM_BUFSIZE = 32768;
    private final DSAEngine dsaEng = DSAEngine.getInstance();
    private final SHA256Generator hashGen = SHA256Generator.getInstance();
    private Hash rxHash;
    private Signature rxSign;
    private Destination rxDest;
    private final byte[] rxPayload = new byte[32768];
    private int rxPayloadLen;
    private boolean valid;

    public void loadI2PDatagram(byte[] dgram) throws DataFormatException {
        ByteArrayInputStream dgStream = new ByteArrayInputStream(dgram);
        this.valid = false;
        try {
            this.rxDest = Destination.create(dgStream);
            this.rxSign = new Signature();
            this.rxSign.readBytes(dgStream);
            this.rxPayloadLen = dgStream.read(this.rxPayload);
            this.rxHash = this.hashGen.calculateHash(this.rxPayload, 0, this.rxPayloadLen);
            assert (this.hashGen.calculateHash(this.extractPayload()).equals(this.rxHash));
        }
        catch (IOException e) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(I2PDatagramDissector.class);
            log.error("Caught IOException - INCONSISTENT STATE!", e);
        }
        catch (AssertionError e) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(I2PDatagramDissector.class);
            log.error("Assertion failed!", (Throwable)((Object)e));
        }
    }

    public byte[] getPayload() throws I2PInvalidDatagramException {
        this.verifySignature();
        return this.extractPayload();
    }

    public Destination getSender() throws I2PInvalidDatagramException {
        this.verifySignature();
        return this.extractSender();
    }

    public Hash getHash() throws I2PInvalidDatagramException {
        this.verifySignature();
        return this.extractHash();
    }

    public byte[] extractPayload() {
        byte[] retPayload = new byte[this.rxPayloadLen];
        System.arraycopy(this.rxPayload, 0, retPayload, 0, this.rxPayloadLen);
        return retPayload;
    }

    public Destination extractSender() {
        return this.rxDest;
    }

    public Hash extractHash() {
        return this.rxHash;
    }

    public void verifySignature() throws I2PInvalidDatagramException {
        if (this.valid) {
            return;
        }
        if (this.rxSign == null || this.rxSign.getData() == null || this.rxDest == null || this.rxDest.getSigningPublicKey() == null) {
            throw new I2PInvalidDatagramException("Datagram not yet read");
        }
        if (!this.dsaEng.verifySignature(this.rxSign, this.rxHash.getData(), this.rxDest.getSigningPublicKey())) {
            throw new I2PInvalidDatagramException("Incorrect I2P repliable datagram signature");
        }
        this.valid = true;
    }
}

