/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.util.Log;

public class I2PSessionDemultiplexer
implements I2PSessionMuxedListener {
    private final Log _log;
    private final Map<Integer, I2PSessionMuxedListener> _listeners;

    public I2PSessionDemultiplexer(I2PAppContext ctx) {
        this._log = ctx.logManager().getLog(I2PSessionDemultiplexer.class);
        this._listeners = new ConcurrentHashMap<Integer, I2PSessionMuxedListener>();
    }

    public void messageAvailable(I2PSession session, int msgId, long size) {
    }

    public void messageAvailable(I2PSession session, int msgId, long size, int proto, int fromport, int toport) {
        I2PSessionMuxedListener l = this.findListener(proto, toport);
        if (l != null) {
            l.messageAvailable(session, msgId, size, proto, fromport, toport);
        } else {
            if (this._listeners.isEmpty()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("No listeners for incoming message");
                }
            } else if (this._log.shouldLog(30)) {
                this._log.warn("No listener found for proto: " + proto + " port: " + toport + " msg id: " + msgId + " from pool of " + this._listeners.size() + " listeners");
            }
            try {
                session.receiveMessage(msgId);
            }
            catch (I2PSessionException ise) {
                // empty catch block
            }
        }
    }

    public void reportAbuse(I2PSession session, int severity) {
        for (I2PSessionMuxedListener l : this._listeners.values()) {
            l.reportAbuse(session, severity);
        }
    }

    public void disconnected(I2PSession session) {
        for (I2PSessionMuxedListener l : this._listeners.values()) {
            l.disconnected(session);
        }
    }

    public void errorOccurred(I2PSession session, String message, Throwable error) {
        for (I2PSessionMuxedListener l : this._listeners.values()) {
            l.errorOccurred(session, message, error);
        }
    }

    public void addListener(I2PSessionListener l, int proto, int port) {
        this._listeners.put(I2PSessionDemultiplexer.key(proto, port), new NoPortsListener(l));
    }

    public void addMuxedListener(I2PSessionMuxedListener l, int proto, int port) {
        this._listeners.put(I2PSessionDemultiplexer.key(proto, port), l);
    }

    public void removeListener(int proto, int port) {
        this._listeners.remove(I2PSessionDemultiplexer.key(proto, port));
    }

    private I2PSessionMuxedListener findListener(int proto, int port) {
        I2PSessionMuxedListener rv = this.getListener(proto, port);
        if (rv != null) {
            return rv;
        }
        if (port != 0 && (rv = this.getListener(proto, 0)) != null) {
            return rv;
        }
        if (proto != 0 && (rv = this.getListener(0, port)) != null) {
            return rv;
        }
        if (proto != 0 && port != 0) {
            rv = this.getListener(0, 0);
        }
        return rv;
    }

    private I2PSessionMuxedListener getListener(int proto, int port) {
        return this._listeners.get(I2PSessionDemultiplexer.key(proto, port));
    }

    private static Integer key(int proto, int port) {
        return port << 8 & 0xFFFF00 | proto;
    }

    private static class NoPortsListener
    implements I2PSessionMuxedListener {
        private I2PSessionListener _l;

        public NoPortsListener(I2PSessionListener l) {
            this._l = l;
        }

        public void messageAvailable(I2PSession session, int msgId, long size) {
            throw new IllegalArgumentException("no");
        }

        public void messageAvailable(I2PSession session, int msgId, long size, int proto, int fromport, int toport) {
            this._l.messageAvailable(session, msgId, size);
        }

        public void reportAbuse(I2PSession session, int severity) {
            this._l.reportAbuse(session, severity);
        }

        public void disconnected(I2PSession session) {
            this._l.disconnected(session);
        }

        public void errorOccurred(I2PSession session, String message, Throwable error) {
            this._l.errorOccurred(session, message, error);
        }
    }
}

