/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.CPUInformation;

import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.CPUIDCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;
import freenet.support.CPUInformation.VIACPUInfo;

class VIAInfoImpl
extends CPUIDCPUInfo
implements VIACPUInfo {
    protected static boolean isC3Compatible = false;
    protected static boolean isNanoCompatible = false;
    protected static String modelString = null;

    VIAInfoImpl() {
    }

    public boolean IsC3Compatible() {
        return isC3Compatible;
    }

    public boolean IsNanoCompatible() {
        return isNanoCompatible;
    }

    public String getCPUModelString() {
        if (modelString != null) {
            return modelString;
        }
        throw new UnknownCPUException("Unknown VIA CPU; Family=" + (CPUID.getCPUFamily() + CPUID.getCPUExtendedFamily()) + ", Model=" + (CPUID.getCPUModel() + CPUID.getCPUExtendedModel()));
    }

    public boolean hasX64() {
        return false;
    }

    private static synchronized void identifyCPU() {
        if (CPUID.getCPUFamily() == 6) {
            isC3Compatible = true;
            switch (CPUID.getCPUModel()) {
                case 5: {
                    modelString = "Cyrix M2";
                    break;
                }
                case 6: {
                    modelString = "C5 A/B";
                    break;
                }
                case 7: {
                    modelString = "C5 C";
                    break;
                }
                case 8: {
                    modelString = "C5 N";
                    break;
                }
                case 9: {
                    modelString = "C5 XL/P";
                    break;
                }
                case 10: {
                    modelString = "C5 J";
                    break;
                }
                case 15: {
                    isNanoCompatible = true;
                    modelString = "Nano";
                }
            }
        }
    }

    static {
        VIAInfoImpl.identifyCPU();
    }
}

