/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.DataBaseCoreImplHSQLDB;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.PeerRankDialog;
import org.ourfilesystem.ui.PrivateMessageTableModel;
import org.ourfilesystem.ui.SignDialogs;
import org.ourfilesystem.ui.ViewPeerDialog;
import org.ourfilesystem.utilities.BBytes;

public class PrivatePanel
extends JPanel
implements RowSorterListener {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private JTextField textMax;
    private JTable table;
    private NewPeerMessageDialog Dialog;
    private ViewPeerDialog PeerDialog;
    private PrivateMessageTableModel Model;
    private Main Mn;
    private SignDialogs SignDialogs;
    private JSpinner spinner;
    private PeerRankDialog rankDialog;
    private JCheckBox chckbxHideOpened;
    private String SortKeyWord;
    private boolean SortAsc;

    public PrivatePanel(Main m) {
        this.Mn = m;
        this.Model = new PrivateMessageTableModel();
        this.rankDialog = new PeerRankDialog(this.Mn);
        this.SortKeyWord = null;
        this.SortAsc = false;
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        JPanel panel = new JPanel();
        splitPane.setLeftComponent(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][]"));
        JButton btnUpdateMessages = new JButton("Update Messages");
        panel.add((Component)btnUpdateMessages, "flowx,cell 1 0,alignx right");
        btnUpdateMessages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PrivatePanel.this.Mn.getUpdater().updatePublicPostsNow();
            }
        });
        JLabel lblSearch = new JLabel("Search");
        panel.add((Component)lblSearch, "cell 0 1,alignx trailing");
        this.textField = new JTextField();
        panel.add((Component)this.textField, "flowx,cell 1 1,growx");
        this.textField.setColumns(10);
        JLabel lblMinPeerRank = new JLabel("Min peer rank");
        panel.add((Component)lblMinPeerRank, "cell 1 1");
        SpinnerNumberModel model = new SpinnerNumberModel(5, 0, 999, 1);
        this.spinner = new JSpinner(model);
        panel.add((Component)this.spinner, "cell 1 1");
        JLabel lblmax = new JLabel("Max results");
        panel.add((Component)lblmax, "cell 1 1");
        this.textMax = new JTextField("1000");
        this.textMax.setColumns(6);
        panel.add((Component)this.textMax, "cell 1 1");
        this.chckbxHideOpened = new JCheckBox("Hide opened");
        panel.add((Component)this.chckbxHideOpened, "cell 1 1");
        JButton btnSearch = new JButton("Search");
        panel.add((Component)btnSearch, "cell 1 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int max = 1000;
                try {
                    max = Integer.valueOf(PrivatePanel.this.textMax.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String terms = PrivatePanel.this.textField.getText();
                int r = (Integer)PrivatePanel.this.spinner.getValue();
                QueryResultsInterface qr = PrivatePanel.this.Mn.getCoreDB().getDBQuery().searchPublicPosts(terms, true, PrivatePanel.this.SortKeyWord, max, !PrivatePanel.this.SortAsc, r, PrivatePanel.this.chckbxHideOpened.isSelected());
                PrivatePanel.this.Model.setPrivateMessages(qr);
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setRightComponent(scrollPane);
        this.table = new JTable(this.Model);
        this.Model.insertDateRenderer(this.table);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().addRowSorterListener(this);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setSelectionMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    int row = PrivatePanel.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
                    PrivatePanel.this.openPost(row);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        scrollPane.setViewportView(this.table);
        this.SignDialogs = new SignDialogs(this.Mn, this.table);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem vi = new JMenuItem("View");
        mnu.add(vi);
        vi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PrivatePanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PrivatePanel.this.table.getSelectedRow();
                    PrivatePanel.this.openPost(r);
                }
            }
        });
        JMenuItem rp = new JMenuItem("Reply");
        mnu.add(rp);
        rp.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PrivatePanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PrivatePanel.this.table.getSelectedRow();
                    r = PrivatePanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PrivatePanel.this.Model.getPrivateMessage(r);
                    if (lp != null) {
                        PrivatePanel.this.Dialog.replyToMessage(lp);
                        if (!lp.isOpened()) {
                            lp.setOpened(true);
                            DataBaseCoreImplHSQLDB dataBaseCoreImplHSQLDB = PrivatePanel.this.Mn.getCoreDB();
                            synchronized (dataBaseCoreImplHSQLDB) {
                                PrivatePanel.this.Mn.getCoreDB().saveLocalPublicPost(lp);
                            }
                            PrivatePanel.this.Model.setOpened(r);
                        }
                    }
                }
            }
        });
        JMenuItem grantacs = new JMenuItem("Grant Peer Group Access");
        mnu.add(grantacs);
        grantacs.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PrivatePanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PrivatePanel.this.table.getSelectedRow();
                    r = PrivatePanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PrivatePanel.this.Model.getPrivateMessage(r);
                    if (lp == null || lp.getPublicPost().getNetworkId() == null) {
                        JOptionPane.showMessageDialog(PrivatePanel.this.table, "There's no network assocated with this post", "No Network", 2);
                        return;
                    }
                    DataBaseCoreImplHSQLDB dataBaseCoreImplHSQLDB = PrivatePanel.this.Mn.getCoreDB();
                    synchronized (dataBaseCoreImplHSQLDB) {
                        BBytes me = PrivatePanel.this.Mn.getCoreDB().getMyPeerData().getPeer().getPeer().getIdentity();
                        PrivatePanel.this.SignDialogs.setPeer(PrivatePanel.this.Mn.getCoreDB().getPeer(lp.getPublicPost().getSignature().getPeerIdentifier()));
                        PrivatePanel.this.SignDialogs.setCurAuth(PrivatePanel.this.Mn.getCoreDB().getNetworkAuth(lp.getPublicPost().getNetworkId(), me));
                    }
                    PrivatePanel.this.SignDialogs.sign();
                } else {
                    JOptionPane.showMessageDialog(PrivatePanel.this.table, "Select a message first.", "No message selected", 2);
                }
            }
        });
        JMenuItem viewpeer = new JMenuItem("View peer info");
        mnu.add(viewpeer);
        viewpeer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PrivatePanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    LocalPeer peer;
                    int r = PrivatePanel.this.table.getSelectedRow();
                    r = PrivatePanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PrivatePanel.this.Model.getPrivateMessage(r);
                    if (lp != null && (peer = PrivatePanel.this.Mn.getCoreDB().getPeer(lp.getPublicPost().getSignature().getPeerIdentifier())) != null) {
                        PrivatePanel.this.PeerDialog.showPeer(peer);
                    }
                }
            }
        });
        JMenuItem rnk = new JMenuItem("Set Peer Rank");
        mnu.add(rnk);
        rnk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PrivatePanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int[] selr = PrivatePanel.this.table.getSelectedRows();
                    LinkedList<BBytes> plst = new LinkedList<BBytes>();
                    int i = 0;
                    while (i < selr.length) {
                        LocalPeer peer;
                        int r = selr[i];
                        r = PrivatePanel.this.table.convertRowIndexToModel(r);
                        LocalPublicPost lp = PrivatePanel.this.Model.getPrivateMessage(r);
                        if (lp != null && (peer = PrivatePanel.this.Mn.getCoreDB().getPeer(lp.getPublicPost().getSignature().getPeerIdentifier())) != null) {
                            plst.add(peer.getPeer().getIdentity());
                        }
                        ++i;
                    }
                    PrivatePanel.this.rankDialog.showDialog(plst);
                }
            }
        });
        this.table.setComponentPopupMenu(mnu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openPost(int r) {
        LocalPublicPost lp = this.Model.getPrivateMessage(r = this.table.convertRowIndexToModel(r));
        if (lp != null) {
            this.Dialog.viewMessage(lp);
            if (!lp.isOpened()) {
                lp.setOpened(true);
                DataBaseCoreImplHSQLDB dataBaseCoreImplHSQLDB = this.Mn.getCoreDB();
                synchronized (dataBaseCoreImplHSQLDB) {
                    this.Mn.getCoreDB().saveLocalPublicPost(lp);
                }
                this.Model.setOpened(r);
            }
        }
    }

    public NewPeerMessageDialog getDialog() {
        return this.Dialog;
    }

    public void setDialog(NewPeerMessageDialog dialog) {
        this.Dialog = dialog;
    }

    public ViewPeerDialog getPeerDialog() {
        return this.PeerDialog;
    }

    public void setPeerDialog(ViewPeerDialog peerDialog) {
        this.PeerDialog = peerDialog;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    public JCheckBox getChckbxHideOpened() {
        return this.chckbxHideOpened;
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        List<RowSorter.SortKey> sl = ((RowSorter)e.getSource()).getSortKeys();
        if (sl.size() > 0) {
            RowSorter.SortKey sk = sl.get(0);
            this.SortKeyWord = this.Model.getSortKey(sk.getColumn());
            this.SortAsc = sk.getSortOrder().equals((Object)SortOrder.ASCENDING);
        }
    }
}

