/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.ui.Main;

public class I2POptionsDialog
extends JDialog {
    private Main Mn;
    private static final long serialVersionUID = 1L;
    private JTextField host;
    private JTextField port;
    private JTextField username;
    private JTextField password;
    private JTextField nickname;
    private JCheckBox ssl;
    private JCheckBox gzip;
    private JCheckBox reduceonidle;
    private JCheckBox closeonidle;
    private JCheckBox encryptleaseset;
    private JCheckBox dontpublishleaseset;
    private JCheckBox fastreceive;
    private JSpinner reducequantity;
    private JSpinner messagereliability;
    private JSpinner inboundquantity;
    private JSpinner inboundlength;
    private JSpinner inboundvariance;
    private JSpinner inboundbackupquantity;
    private JSpinner inboundiprestriction;
    private JCheckBox inboundallowzerohop;
    private JSpinner outboundquantity;
    private JSpinner outboundlength;
    private JSpinner outboundvariance;
    private JSpinner outboundbackupquantity;
    private JSpinner outboundiprestriction;
    private JSpinner outboundpriority;
    private JCheckBox outboundallowzerohop;
    private JSpinner cryptotagstosend;
    private JSpinner cryptolowtagthreshold;
    private JCheckBox shouldbundlereplyinfo;

    public I2POptionsDialog(Main m) {
        this.Mn = m;
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("resources/ofs2_wiki.png"));
            this.setIconImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBounds(100, 100, 450, 650);
        JScrollPane scrollPane = new JScrollPane();
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel panel = new JPanel();
        scrollPane.setViewportView(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][][][][][][][][][][][][][][][][][][][][][][][][]"));
        JLabel lblNewLabel = new JLabel("i2cp.tcp.host");
        panel.add((Component)lblNewLabel, "cell 0 0,alignx trailing");
        this.host = new JTextField();
        panel.add((Component)this.host, "cell 1 0,growx");
        this.host.setColumns(10);
        JLabel lblNewLabel_1 = new JLabel("i2cp.tcp.port");
        panel.add((Component)lblNewLabel_1, "cell 0 1,alignx trailing");
        this.port = new JTextField();
        panel.add((Component)this.port, "cell 1 1,growx");
        this.port.setColumns(10);
        JLabel lblIcpusername = new JLabel("i2cp.username");
        panel.add((Component)lblIcpusername, "cell 0 2,alignx trailing");
        this.username = new JTextField();
        panel.add((Component)this.username, "cell 1 2,growx");
        this.username.setColumns(10);
        JLabel lblIcppassword = new JLabel("i2cp.password");
        panel.add((Component)lblIcppassword, "cell 0 3,alignx trailing");
        this.password = new JTextField();
        panel.add((Component)this.password, "cell 1 3,growx");
        this.password.setColumns(10);
        this.ssl = new JCheckBox("i2cp.SSL");
        panel.add((Component)this.ssl, "cell 1 4");
        this.gzip = new JCheckBox("i2cp.gzip");
        panel.add((Component)this.gzip, "cell 1 5");
        this.reduceonidle = new JCheckBox("i2cp.reduceOnIdle");
        panel.add((Component)this.reduceonidle, "cell 1 6");
        this.closeonidle = new JCheckBox("i2cp.closeOnIdle");
        panel.add((Component)this.closeonidle, "cell 1 7");
        this.encryptleaseset = new JCheckBox("i2cp.encryptLeaseSet");
        panel.add((Component)this.encryptleaseset, "cell 1 8");
        this.dontpublishleaseset = new JCheckBox("i2cp.dontPublishLeaseSet");
        panel.add((Component)this.dontpublishleaseset, "cell 1 9");
        this.fastreceive = new JCheckBox("i2cp.fastReceive");
        panel.add((Component)this.fastreceive, "cell 1 10");
        JLabel lblIcpreducequantity = new JLabel("i2cp.reduceQuantity");
        panel.add((Component)lblIcpreducequantity, "cell 0 11,alignx right");
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 5, 1);
        this.reducequantity = new JSpinner(model);
        panel.add((Component)this.reducequantity, "cell 1 11");
        JLabel lblIcpmessagereliability = new JLabel("i2cp.messageReliability");
        panel.add((Component)lblIcpmessagereliability, "cell 0 12,alignx right");
        Object[] msgreliablity = new String[]{"BestEffort", "none"};
        SpinnerListModel realiabilitymodel = new SpinnerListModel(msgreliablity);
        this.messagereliability = new JSpinner(realiabilitymodel);
        panel.add((Component)this.messagereliability, "cell 1 12");
        JLabel lblInboundnickname = new JLabel("inbound.nickname");
        panel.add((Component)lblInboundnickname, "cell 0 13,alignx right");
        this.nickname = new JTextField();
        panel.add((Component)this.nickname, "cell 1 13,growx");
        this.nickname.setColumns(10);
        JLabel lblInboundquantity = new JLabel("inbound.quantity");
        panel.add((Component)lblInboundquantity, "cell 0 14,alignx right");
        model = new SpinnerNumberModel(1, 1, 16, 1);
        this.inboundquantity = new JSpinner(model);
        panel.add((Component)this.inboundquantity, "cell 1 14");
        JLabel lblNewLabel_2 = new JLabel("inbound.length");
        panel.add((Component)lblNewLabel_2, "cell 0 15,alignx right");
        model = new SpinnerNumberModel(1, 0, 7, 1);
        this.inboundlength = new JSpinner(model);
        panel.add((Component)this.inboundlength, "cell 1 15");
        JLabel lblInboundlengthvariance = new JLabel("inbound.lengthVariance");
        panel.add((Component)lblInboundlengthvariance, "cell 0 16,alignx right");
        model = new SpinnerNumberModel(1, -7, 7, 1);
        this.inboundvariance = new JSpinner(model);
        panel.add((Component)this.inboundvariance, "cell 1 16");
        JLabel lblInboundbackupquantity = new JLabel("inbound.backupQuantity");
        panel.add((Component)lblInboundbackupquantity, "cell 0 17,alignx right");
        model = new SpinnerNumberModel(1, 0, 16, 1);
        this.inboundbackupquantity = new JSpinner(model);
        panel.add((Component)this.inboundbackupquantity, "cell 1 17");
        JLabel lblInboundiprestriction = new JLabel("inbound.IPRestriction");
        panel.add((Component)lblInboundiprestriction, "cell 0 18,alignx right");
        model = new SpinnerNumberModel(1, 0, 4, 1);
        this.inboundiprestriction = new JSpinner(model);
        panel.add((Component)this.inboundiprestriction, "cell 1 18");
        this.inboundallowzerohop = new JCheckBox("inbound.allowZeroHop");
        panel.add((Component)this.inboundallowzerohop, "cell 1 19");
        JLabel lblOutboundquantity = new JLabel("outbound.quantity");
        panel.add((Component)lblOutboundquantity, "cell 0 20,alignx right");
        model = new SpinnerNumberModel(1, 0, 16, 1);
        this.outboundquantity = new JSpinner(model);
        panel.add((Component)this.outboundquantity, "cell 1 20");
        JLabel lblOutboundlength = new JLabel("outbound.length");
        panel.add((Component)lblOutboundlength, "cell 0 21,alignx right");
        model = new SpinnerNumberModel(1, 0, 7, 1);
        this.outboundlength = new JSpinner(model);
        panel.add((Component)this.outboundlength, "cell 1 21");
        JLabel lblOutboundlengthvariance = new JLabel("outbound.lengthVariance");
        panel.add((Component)lblOutboundlengthvariance, "cell 0 22");
        model = new SpinnerNumberModel(1, -7, 7, 1);
        this.outboundvariance = new JSpinner(model);
        panel.add((Component)this.outboundvariance, "cell 1 22");
        JLabel lblOutboundbackupquantity = new JLabel("outbound.backupQuantity");
        panel.add((Component)lblOutboundbackupquantity, "cell 0 23,alignx right");
        model = new SpinnerNumberModel(1, 1, 16, 1);
        this.outboundbackupquantity = new JSpinner(model);
        panel.add((Component)this.outboundbackupquantity, "cell 1 23");
        JLabel lblOutboundiprestriction = new JLabel("outbound.IPRestriction");
        panel.add((Component)lblOutboundiprestriction, "cell 0 24,alignx right");
        model = new SpinnerNumberModel(1, 0, 4, 1);
        this.outboundiprestriction = new JSpinner(model);
        panel.add((Component)this.outboundiprestriction, "cell 1 24");
        JLabel lblOutboundpriority = new JLabel("outbound.priority");
        panel.add((Component)lblOutboundpriority, "cell 0 25,alignx right");
        model = new SpinnerNumberModel(0, -25, 25, 1);
        this.outboundpriority = new JSpinner(model);
        panel.add((Component)this.outboundpriority, "cell 1 25");
        this.outboundallowzerohop = new JCheckBox("outbound.allowZeroHop");
        panel.add((Component)this.outboundallowzerohop, "cell 1 26");
        JLabel lblCryptotagstosend = new JLabel("crypto.tagsToSend");
        panel.add((Component)lblCryptotagstosend, "cell 0 27,alignx right");
        model = new SpinnerNumberModel(40, 1, 128, 1);
        this.cryptotagstosend = new JSpinner(model);
        panel.add((Component)this.cryptotagstosend, "cell 1 27");
        JLabel lblCryptolowtagthreshold = new JLabel("crypto.lowTagThreshold");
        panel.add((Component)lblCryptolowtagthreshold, "cell 0 28");
        model = new SpinnerNumberModel(30, 1, 128, 1);
        this.cryptolowtagthreshold = new JSpinner(model);
        panel.add((Component)this.cryptolowtagthreshold, "cell 1 28");
        this.shouldbundlereplyinfo = new JCheckBox("shouldBundleReplyInfo");
        panel.add((Component)this.shouldbundlereplyinfo, "cell 1 29");
        JButton btnSave = new JButton("Save");
        panel.add((Component)btnSave, "flowx,cell 1 30");
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                I2POptionsDialog.this.saveButton();
            }
        });
        JButton btnCancel = new JButton("Cancel");
        panel.add((Component)btnCancel, "cell 1 30");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                I2POptionsDialog.this.setVisible(false);
            }
        });
    }

    public void showDialog() {
        this.showDialog(this.Mn.getI2PProperties());
    }

    private void saveButton() {
        if (this.Mn != null && this.Mn.getI2PProperties() != null) {
            this.setPropertiesFromGui(this.Mn.getI2PProperties());
            this.Mn.saveProperties();
            JOptionPane.showMessageDialog(this, "You must restart for changes to take effect.", "Restart Required", 2);
            this.setVisible(false);
        }
    }

    private void showDialog(Properties props) {
        this.host.setText("127.0.0.1");
        this.port.setText("7654");
        this.username.setText("");
        this.password.setText("");
        this.nickname.setText("OFS");
        this.ssl.setSelected(false);
        this.gzip.setSelected(true);
        this.reduceonidle.setSelected(false);
        this.closeonidle.setSelected(false);
        this.encryptleaseset.setSelected(false);
        this.dontpublishleaseset.setSelected(false);
        this.fastreceive.setSelected(false);
        this.reducequantity.setValue(1);
        this.messagereliability.setValue("none");
        this.inboundquantity.setValue(2);
        this.inboundlength.setValue(2);
        this.inboundvariance.setValue(0);
        this.inboundbackupquantity.setValue(0);
        this.inboundiprestriction.setValue(2);
        this.inboundallowzerohop.setSelected(true);
        this.outboundquantity.setValue(2);
        this.outboundlength.setValue(2);
        this.outboundvariance.setValue(0);
        this.outboundbackupquantity.setValue(0);
        this.outboundiprestriction.setValue(2);
        this.outboundpriority.setValue(0);
        this.outboundallowzerohop.setSelected(true);
        this.cryptotagstosend.setValue(40);
        this.cryptolowtagthreshold.setValue(30);
        this.shouldbundlereplyinfo.setSelected(true);
        this.setFromProperties(props);
        this.setVisible(true);
    }

    private String getString(Properties p, String k, String def) {
        String r = p.getProperty(k);
        if (r != null) {
            return r;
        }
        return def;
    }

    private boolean getBoolean(Properties p, String k, boolean def) {
        String v = p.getProperty(k);
        if (v != null) {
            try {
                boolean b = Boolean.valueOf(v);
                return b;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    private int getInteger(Properties p, String k, int def) {
        String v = p.getProperty(k);
        if (v != null) {
            try {
                int iv = Integer.valueOf(v);
                return iv;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    private void setNullOrString(Properties p, String key, String v) {
        Matcher m;
        if (v != null && (m = Pattern.compile("\\S+").matcher(v)).find()) {
            p.setProperty(key, v);
            return;
        }
        p.remove(key);
    }

    private String getBool(JCheckBox j) {
        if (j.isSelected()) {
            return "true";
        }
        return "false";
    }

    private void setPropertiesFromGui(Properties p) {
        p.setProperty("i2cp.tcp.host", this.host.getText());
        p.setProperty("i2cp.tcp.port", this.port.getText());
        this.setNullOrString(p, "i2cp.username", this.username.getText());
        this.setNullOrString(p, "i2cp.password", this.password.getText());
        this.setNullOrString(p, "inbound.nickname", this.nickname.getText());
        p.setProperty("i2cp.SSL", this.getBool(this.ssl));
        p.setProperty("i2cp.gzip", this.getBool(this.gzip));
        p.setProperty("i2cp.reduceOnIdle", this.getBool(this.reduceonidle));
        p.setProperty("i2cp.closeOnIdle", this.getBool(this.closeonidle));
        p.setProperty("i2cp.encryptLeaseSet", this.getBool(this.encryptleaseset));
        p.setProperty("i2cp.dontPublishLeaseSet", this.getBool(this.dontpublishleaseset));
        p.setProperty("i2cp.fastReceive", this.getBool(this.fastreceive));
        p.setProperty("i2cp.reduceQuantity", this.reducequantity.getValue().toString());
        p.setProperty("i2cp.messageReliability", this.messagereliability.getValue().toString());
        p.setProperty("inbound.quantity", this.inboundquantity.getValue().toString());
        p.setProperty("inbound.length", this.inboundlength.getValue().toString());
        p.setProperty("inbound.lengthVariance", this.inboundvariance.getValue().toString());
        p.setProperty("inbound.backupQuantity", this.inboundbackupquantity.getValue().toString());
        p.setProperty("inbound.IPRestriction", this.inboundiprestriction.getValue().toString());
        p.setProperty("inbound.allowZeroHop", this.getBool(this.inboundallowzerohop));
        p.setProperty("outbound.quantity", this.outboundquantity.getValue().toString());
        p.setProperty("outbound.length", this.outboundlength.getValue().toString());
        p.setProperty("outbound.lengthVariance", this.outboundvariance.getValue().toString());
        p.setProperty("outbound.backupQuantity", this.outboundbackupquantity.getValue().toString());
        p.setProperty("outbound.IPRestriction", this.outboundiprestriction.getValue().toString());
        p.setProperty("outbound.priority", this.outboundpriority.getValue().toString());
        p.setProperty("outbound.allowZeroHop", this.getBool(this.outboundallowzerohop));
        p.setProperty("crypto.tagsToSend", this.cryptotagstosend.getValue().toString());
        p.setProperty("crypto.lowTagThreshold", this.cryptolowtagthreshold.getValue().toString());
        p.setProperty("shouldBundleReplyInfo", this.getBool(this.shouldbundlereplyinfo));
    }

    private void setFromProperties(Properties p) {
        this.host.setText(this.getString(p, "i2cp.tcp.host", "127.0.0.1"));
        this.port.setText(Integer.toString(this.getInteger(p, "i2cp.tcp.port", 7654)));
        this.username.setText(this.getString(p, "i2cp.username", ""));
        this.password.setText(this.getString(p, "i2cp.password", ""));
        this.nickname.setText(this.getString(p, "inbound.nickname", "OFS"));
        this.ssl.setSelected(this.getBoolean(p, "i2cp.SSL", false));
        this.gzip.setSelected(this.getBoolean(p, "i2cp.gzip", true));
        this.reduceonidle.setSelected(this.getBoolean(p, "i2cp.reduceOnIdle", false));
        this.closeonidle.setSelected(this.getBoolean(p, "i2cp.closeOnIdle", false));
        this.encryptleaseset.setSelected(this.getBoolean(p, "i2cp.encryptLeaseSet", false));
        this.dontpublishleaseset.setSelected(this.getBoolean(p, "i2cp.dontPublishLeaseSet", false));
        this.fastreceive.setSelected(this.getBoolean(p, "i2cp.fastReceive", false));
        this.reducequantity.setValue(this.getInteger(p, "i2cp.reduceQuantity", 1));
        this.messagereliability.setValue(this.getString(p, "i2cp.messageReliability", "none"));
        this.inboundquantity.setValue(this.getInteger(p, "inbound.quantity", 2));
        this.inboundlength.setValue(this.getInteger(p, "inbound.length", 2));
        this.inboundvariance.setValue(this.getInteger(p, "inbound.lengthVariance", 0));
        this.inboundbackupquantity.setValue(this.getInteger(p, "inbound.backupQuantity", 0));
        this.inboundiprestriction.setValue(this.getInteger(p, "inbound.IPRestriction", 2));
        this.inboundallowzerohop.setSelected(this.getBoolean(p, "inbound.allowZeroHop", true));
        this.outboundquantity.setValue(this.getInteger(p, "outbound.quantity", 2));
        this.outboundlength.setValue(this.getInteger(p, "outbound.length", 2));
        this.outboundvariance.setValue(this.getInteger(p, "outbound.lengthVariance", 0));
        this.outboundbackupquantity.setValue(this.getInteger(p, "outbound.backupQuantity", 0));
        this.outboundiprestriction.setValue(this.getInteger(p, "outbound.IPRestriction", 2));
        this.outboundpriority.setValue(this.getInteger(p, "outbound.priority", 0));
        this.outboundallowzerohop.setSelected(this.getBoolean(p, "outbound.allowZeroHop", true));
        this.cryptotagstosend.setValue(this.getInteger(p, "crypto.tagsToSend", 40));
        this.cryptolowtagthreshold.setValue(this.getInteger(p, "crypto.lowTagThreshold", 30));
        this.shouldbundlereplyinfo.setSelected(this.getBoolean(p, "shouldBundleReplyInfo", true));
    }

    public JTextField getHost() {
        return this.host;
    }

    public JTextField getPort() {
        return this.port;
    }

    public JTextField getUsername() {
        return this.username;
    }

    public JTextField getPassword() {
        return this.password;
    }

    public JCheckBox getSsl() {
        return this.ssl;
    }

    public JCheckBox getGzip() {
        return this.gzip;
    }

    public JCheckBox getReduceonidle() {
        return this.reduceonidle;
    }

    public JCheckBox getCloseonidle() {
        return this.closeonidle;
    }

    public JCheckBox getEncryptleaseset() {
        return this.encryptleaseset;
    }

    public JCheckBox getDontpublishleaseset() {
        return this.dontpublishleaseset;
    }

    public JCheckBox getFastreceive() {
        return this.fastreceive;
    }

    public JSpinner getReducequantity() {
        return this.reducequantity;
    }

    public JSpinner getMessagereliability() {
        return this.messagereliability;
    }

    public JTextField getNickname() {
        return this.nickname;
    }

    public JSpinner getInboundquantity() {
        return this.inboundquantity;
    }

    public JSpinner getInboundlength() {
        return this.inboundlength;
    }

    public JSpinner getInboundvariance() {
        return this.inboundvariance;
    }

    public JSpinner getBackupquantity() {
        return this.inboundbackupquantity;
    }

    public JSpinner getInboundiprestriction() {
        return this.inboundiprestriction;
    }

    public JCheckBox getInboundallowzerohop() {
        return this.inboundallowzerohop;
    }

    public JSpinner getOutboundquantity() {
        return this.outboundquantity;
    }

    public JSpinner getOutboundlength() {
        return this.outboundlength;
    }

    public JSpinner getOutboundvariance() {
        return this.outboundvariance;
    }

    public JSpinner getOutboundbackupquantity() {
        return this.outboundbackupquantity;
    }

    public JSpinner getOutboundiprestriction() {
        return this.outboundiprestriction;
    }

    public JSpinner getOutboundpriority() {
        return this.outboundpriority;
    }

    public JCheckBox getOutboundallowzerohop() {
        return this.outboundallowzerohop;
    }

    public JSpinner getCryptotagstosend() {
        return this.cryptotagstosend;
    }

    public JSpinner getCryptolowtagthreshold() {
        return this.cryptolowtagthreshold;
    }

    public JCheckBox getShouldbundlereplyinfo() {
        return this.shouldbundlereplyinfo;
    }
}

