/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.ui.ProgramManager;

public class ExtensionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField textProgName;
    private JTextField textExtension;
    private JLabel lblProgexectutable;
    private JButton btnSetProgramExecutable;
    private ProgramManager Manager;
    private JDialog ThisDialog = this;
    private File LastDir;

    public ExtensionDialog(ProgramManager man) {
        this.Manager = man;
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("resources/ofs2_wiki.png"));
            this.setIconImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBounds(100, 100, 450, 200);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][]"));
        JLabel lblProgramName = new JLabel("Program Name");
        this.getContentPane().add((Component)lblProgramName, "cell 0 0,alignx trailing");
        this.textProgName = new JTextField();
        this.getContentPane().add((Component)this.textProgName, "cell 1 0,growx");
        this.textProgName.setColumns(10);
        JLabel lblProgramExecutable = new JLabel("Program Executable");
        this.getContentPane().add((Component)lblProgramExecutable, "cell 0 1");
        this.lblProgexectutable = new JLabel("progexectutable");
        this.getContentPane().add((Component)this.lblProgexectutable, "cell 1 1");
        this.btnSetProgramExecutable = new JButton("Set Program Executable");
        this.getContentPane().add((Component)this.btnSetProgramExecutable, "cell 1 2");
        this.btnSetProgramExecutable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = null;
                chooser = ExtensionDialog.this.LastDir != null ? new JFileChooser(ExtensionDialog.this.LastDir) : new JFileChooser();
                int returnVal = chooser.showOpenDialog(ExtensionDialog.this.ThisDialog);
                if (returnVal == 0) {
                    File peerfile = chooser.getSelectedFile();
                    ExtensionDialog.this.lblProgexectutable.setText(peerfile.getPath());
                }
                ExtensionDialog.this.LastDir = chooser.getCurrentDirectory();
            }
        });
        JLabel lblExtension = new JLabel("File Extension");
        this.getContentPane().add((Component)lblExtension, "cell 0 3,alignx trailing");
        this.textExtension = new JTextField();
        this.getContentPane().add((Component)this.textExtension, "cell 1 3,growx");
        this.textExtension.setColumns(10);
        JButton btnSet = new JButton("Set");
        this.getContentPane().add((Component)btnSet, "flowx,cell 1 4");
        btnSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String exec = ExtensionDialog.this.lblProgexectutable.getText();
                String name = ExtensionDialog.this.textProgName.getText();
                Matcher m0 = Pattern.compile("\\S+").matcher(exec);
                Matcher m2 = Pattern.compile("\\S+").matcher(name);
                String[] extl = ExtensionDialog.this.textExtension.getText().split("\\W+");
                File f = new File(exec);
                if (m0.find() && m2.find() && f.exists() && extl.length > 0) {
                    int c = 0;
                    while (c < extl.length) {
                        String elc = extl[c].toLowerCase();
                        ExtensionDialog.this.Manager.addExtension(elc, name, exec);
                        ExtensionDialog.this.setVisible(false);
                        ++c;
                    }
                }
            }
        });
        JButton btnCancel = new JButton("Cancel");
        this.getContentPane().add((Component)btnCancel, "cell 1 4");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExtensionDialog.this.setVisible(false);
            }
        });
    }

    public void showExt(String ext, String progname, String executable) {
        this.textProgName.setText(progname);
        this.textExtension.setText(ext);
        this.lblProgexectutable.setText(executable);
        this.setVisible(true);
    }
}

