/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.DataBaseCoreImplHSQLDB;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.TopDocsCacheQueryResultsAbstract;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.utilities.BBytes;

public class NetworkQueryResultsHSQLDB
extends TopDocsCacheQueryResultsAbstract {
    private DataBaseCoreImplHSQLDB DB;

    public NetworkQueryResultsHSQLDB(TopDocs t, IndexSearcher s, DirectoryReader reader, DataBaseCoreImplHSQLDB db) {
        super(t, s, reader);
        this.DB = db;
    }

    @Override
    public Object getHits(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                StoredField lf = (StoredField)d.getField(DataBaseLuceneIndexer.NETWORK_ID_STR);
                if (lf != null) {
                    BBytes lfb = new BBytes(lf.binaryValue().bytes);
                    LocalNetwork lp = this.DB.getLocalNetwork(lfb);
                    return lp;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Object> getMapStatic(Document d) {
        try {
            Number n;
            HashMap<String, Object> data = new HashMap<String, Object>();
            IndexableField lf = d.getField(DataBaseLuceneIndexer.NETWORK_TITLE_STR);
            if (lf != null) {
                data.put(DataBaseLuceneIndexer.NETWORK_TITLE_STR, lf.stringValue());
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.NETWORK_DESCRIPTION_STR)) != null) {
                data.put(DataBaseLuceneIndexer.NETWORK_DESCRIPTION_STR, lf.stringValue());
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.NETWORK_CREATOR_STR)) != null) {
                data.put(DataBaseLuceneIndexer.NETWORK_CREATOR_STR, lf.stringValue());
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.NETWORK_AUTH)) != null) {
                data.put(DataBaseLuceneIndexer.NETWORK_AUTH, lf.stringValue());
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.NETWORK_AUTH_NUM)) != null) {
                n = lf.numericValue();
                data.put(DataBaseLuceneIndexer.NETWORK_AUTH_NUM, n.longValue());
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.NETWORK_DATE)) != null) {
                n = lf.numericValue();
                data.put(DataBaseLuceneIndexer.NETWORK_DATE, new Date(n.longValue()));
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.NETWORK_CDATE)) != null) {
                n = lf.numericValue();
                data.put(DataBaseLuceneIndexer.NETWORK_CDATE, new Date(n.longValue()));
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.NETWORK_PEERRANK)) != null) {
                data.put(DataBaseLuceneIndexer.NETWORK_PEERRANK, lf.numericValue().longValue());
            }
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, Object> getMap(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                return NetworkQueryResultsHSQLDB.getMapStatic(d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Object> obj2FieldsStatic(Object obj) {
        if (obj != null && obj instanceof LocalNetwork) {
            LocalNetwork ln = (LocalNetwork)obj;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(DataBaseLuceneIndexer.NETWORK_TITLE_STR, ln.getNetwork().getTitleSig());
            data.put(DataBaseLuceneIndexer.NETWORK_DESCRIPTION_STR, ln.getNetwork().getDescription());
            data.put(DataBaseLuceneIndexer.NETWORK_CREATOR_STR, ln.getCreator());
            data.put(DataBaseLuceneIndexer.NETWORK_AUTH_NUM, ln.getAuthorization());
            data.put(DataBaseLuceneIndexer.NETWORK_DATE, ln.getLocalDate());
            data.put(DataBaseLuceneIndexer.NETWORK_CDATE, ln.getNetwork().getRDate());
            data.put(DataBaseLuceneIndexer.NETWORK_PEERRANK, ln.getPeerRank());
            return data;
        }
        return null;
    }

    @Override
    public Map<String, Object> obj2Fields(Object obj) {
        return NetworkQueryResultsHSQLDB.obj2FieldsStatic(obj);
    }
}

