/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.ourfilesystem.db.DataBaseQueryHSQLDB;
import org.ourfilesystem.db.DataBaseQueryInterface;
import org.ourfilesystem.db.OFSAnalyzer;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.filehandler.FileHandler;
import org.ourfilesystem.ui.NewPublicPostDialog;
import org.ourfilesystem.ui.Replier;

public class DataBaseLuceneIndexer
implements Runnable {
    public static final Logger Log = Logger.getLogger(DataBaseLuceneIndexer.class.getName());
    public static String INDEX_DIR = "standard-indexer";
    public static String DOC_TYPE = "doctype";
    public static String PUBLIC_POST_TYPE = "publicposttype";
    public static String NETWORK_TYPE = "networktype";
    public static String POST_TYPE = "posttype";
    public static String TEMPLATE_TYPE = "templatetype";
    public static String PEER_TYPE = "peertype";
    public static String PUBLIC_POST_SUBJECT = "ppsubject";
    public static String PUBLIC_POST_CREATOR = "ppcreator";
    public static String PUBLIC_POST_GROUP = "ppgroup";
    public static String PUBLIC_POST_TOPEER = "pptopeer";
    public static String PUBLIC_POST_SUBJECT_STR = "ppsubjectstr";
    public static String PUBLIC_POST_CREATOR_STR = "ppcreatorstr";
    public static String PUBLIC_POST_GROUP_STR = "ppgroupstr";
    public static String PUBLIC_POST_TOPEER_STR = "pptopeerstr";
    public static String PUBLIC_POST_DECODED_MESSAGE = "ppdecodedmessage";
    public static String PUBLIC_POST_MESSAGE = "ppmessage";
    public static String PUBLIC_POST_DATE = "ppdate";
    public static String PUBLIC_POST_ID = "ppostid";
    public static String PUBLIC_POST_ID_STR = "ppostidstr";
    public static String PUBLIC_POST_PEERID = "ppostpeer";
    public static String PUBLIC_POST_PEERID_STR = "ppostpeerstr";
    public static String PUBLIC_POST_PRIVATE = "ppprivate";
    public static String PUBLIC_POST_ENCRYPTED = "ppencrypt";
    public static String PUBLIC_POST_CDATE = "ppcdate";
    public static String PUBLIC_POST_PEERRANK = "pppeerrank";
    public static String PUBLIC_POST_OPENED = "ppopened";
    public static String NETWORK_TITLE = "nettitle";
    public static String NETWORK_DESCRIPTION = "netdesc";
    public static String NETWORK_CREATOR = "netcreator";
    public static String NETWORK_TITLE_STR = "nettitlestr";
    public static String NETWORK_DESCRIPTION_STR = "netdescstr";
    public static String NETWORK_CREATOR_STR = "netcreatorstr";
    public static String NETWORK_DATE = "netdate";
    public static String NETWORK_PEERID = "netpeerid";
    public static String NETWORK_CDATE = "netcdate";
    public static String NETWORK_ID = "netid";
    public static String NETWORK_PEERID_STR = "netpeeridstr";
    public static String NETWORK_ID_STR = "netidstr";
    public static String NETWORK_AUTH = "netauth";
    public static String NETWORK_AUTH_NUM = "netauthnum";
    public static String NETWORK_PEERRANK = "netpeerrank";
    public static String POST_PEERNICK = "postpeernick";
    public static String POST_LOCAL_FILENAME = "postlocalfilename";
    public static String POST_FILENAME = "filename";
    public static String POST_SUBJECT = "subject";
    public static String POST_PEERNICK_STR = "postpeernickstr";
    public static String POST_LOCAL_FILENAME_STR = "postlocalfilenamestr";
    public static String POST_FILENAME_STR = "filenamestr";
    public static String POST_SUBJECT_STR = "subjectstr";
    public static String POST_LOCALFILE = "postlocalfile";
    public static String POST_POSTNUM = "postnum";
    public static String POST_NETID = "pnetid";
    public static String POST_DATE = "pdate";
    public static String POST_ID = "postid";
    public static String POST_PEERID = "postpeer";
    public static String POST_ID_STR = "postidstr";
    public static String POST_PEERID_STR = "postpeerstr";
    public static String POST_COMMENT = "comment";
    public static String POST_STRING0 = "string0";
    public static String POST_STRING1 = "string1";
    public static String POST_STRING2 = "string2";
    public static String POST_STRING3 = "string3";
    public static String POST_STRING4 = "string4";
    public static String POST_STRING5 = "string5";
    public static String POST_STRING6 = "string6";
    public static String POST_STRING7 = "string7";
    public static String POST_FILEREF = "fileref";
    public static String POST_FILEREF_STR = "filerefstr";
    public static String POST_REF0 = "ref0";
    public static String POST_REF1 = "ref1";
    public static String POST_REF2 = "ref2";
    public static String POST_REF0_STR = "ref0str";
    public static String POST_REF1_STR = "ref1str";
    public static String POST_REF2_STR = "ref2str";
    public static String POST_USETEMPLATE = "usetemp";
    public static String POST_NUM0 = "num0";
    public static String POST_NUM1 = "num1";
    public static String POST_NUM2 = "num2";
    public static String POST_NUM3 = "num3";
    public static String POST_NUM4 = "num4";
    public static String POST_NUM5 = "num5";
    public static String POST_NUM6 = "num6";
    public static String POST_NUM7 = "num7";
    public static String POST_NUM8 = "num8";
    public static String POST_NUM9 = "num9";
    public static String POST_DOUBLE0 = "double0";
    public static String POST_DOUBLE1 = "double1";
    public static String POST_DOUBLE2 = "double2";
    public static String POST_DOUBLE3 = "double3";
    public static String POST_DOUBLE4 = "double4";
    public static String POST_DOUBLE5 = "double5";
    public static String POST_DOUBLE6 = "double6";
    public static String POST_DOUBLE7 = "double7";
    public static String POST_DOUBLE8 = "double8";
    public static String POST_DOUBLE9 = "double9";
    public static String POST_BOOL0 = "bool0";
    public static String POST_BOOL1 = "bool1";
    public static String POST_BOOL2 = "bool2";
    public static String POST_BOOL3 = "bool3";
    public static String POST_BOOL4 = "bool4";
    public static String POST_BOOL5 = "bool5";
    public static String POST_BOOL6 = "bool6";
    public static String POST_BOOL7 = "bool7";
    public static String POST_BOOL8 = "bool8";
    public static String POST_BOOL9 = "bool9";
    public static String POST_TEMP = "temp";
    public static String POST_PEERRANK = "postrank";
    public static String POST_CDATE = "postcdate";
    public static String POST_FILE_SIZE = "postfilesize";
    public static String POST_TEMPLATE_NAME = "posttemplatename";
    public static String POST_TEMPLATE_DESC = "posttemplatedesc";
    public static String POST_TEMPLATE_FIELDS = "posttemplatefields";
    public static String POST_OPENED = "popened";
    public static String PEER_INTRO = "intro";
    public static String PEER_NICKNAME = "nick";
    public static String PEER_INTRO_STR = "introstr";
    public static String PEER_NICKNAME_STR = "nickstr";
    public static String PEER_DATE = "prdate";
    public static String PEER_CDATE = "prcdate";
    public static String PEER_RANK = "peerrank";
    public static String PEER_ID = "peerid";
    public static String PEER_ID_STR = "peeridstr";
    private File BaseDir;
    private IndexWriter Indexer;
    private boolean Closed;
    private boolean PendingIndex;
    private DataBaseQueryHSQLDB DBQuery;

    public DataBaseLuceneIndexer(String basedir) throws IOException, SQLException {
        this.BaseDir = new File(basedir);
        if (!this.BaseDir.exists()) {
            this.BaseDir.mkdirs();
        } else if (!this.BaseDir.isDirectory()) {
            throw new RuntimeException("Expecting a directory: " + basedir);
        }
        FieldType ft = LongField.TYPE_STORED;
        Log.info("LongField: indexed? " + ft.indexed());
        File idxdir = new File(String.valueOf(this.BaseDir.getPath()) + File.separator + INDEX_DIR);
        if (!idxdir.exists()) {
            idxdir.mkdirs();
        } else if (!idxdir.isDirectory()) {
            throw new RuntimeException("standard-indexer is not a dir!");
        }
        this.PendingIndex = false;
        IndexWriterConfig idxconf = new IndexWriterConfig(Version.LUCENE_44, (Analyzer)new OFSAnalyzer(Version.LUCENE_44));
        SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
        this.Indexer = new IndexWriter((Directory)fsdir, idxconf);
        this.Indexer.commit();
        this.DBQuery = new DataBaseQueryHSQLDB(this.BaseDir.getPath());
        this.Closed = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DataBaseLuceneIndexer.this.Close();
            }
        });
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.Closed) {
            try {
                Thread.sleep(4000L);
                if (!this.PendingIndex) continue;
                IndexWriter indexWriter = this.Indexer;
                synchronized (indexWriter) {
                    this.Indexer.commit();
                    this.PendingIndex = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Close() {
        this.Closed = true;
        this.DBQuery.Close();
        try {
            IndexWriter indexWriter = this.Indexer;
            synchronized (indexWriter) {
                this.Indexer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DataBaseQueryInterface getDBQuery() {
        return this.DBQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexPublicPost(LocalPublicPost lp, boolean update) {
        String str;
        Object m;
        boolean allnull = true;
        Document d = new Document();
        d.add((IndexableField)new StringField(DOC_TYPE, PUBLIC_POST_TYPE, Field.Store.YES));
        if (lp.getDecodedMessage() != null) {
            allnull = false;
            String str2 = (String)lp.getDecodedMessage();
            d.add((IndexableField)new TextField(PUBLIC_POST_DECODED_MESSAGE, str2, Field.Store.NO));
            String[] prg = str2.split(NewPublicPostDialog.SUBJECTBODY);
            String subj = prg[0];
            subj = Replier.removeSubjectRe(subj);
            d.add((IndexableField)new TextField(PUBLIC_POST_SUBJECT, subj, Field.Store.NO));
            d.add((IndexableField)new StringField(PUBLIC_POST_SUBJECT_STR, subj, Field.Store.YES));
        }
        if ((m = lp.getPublicPost().getMessage()) != null && m instanceof String) {
            str = (String)m;
            allnull = false;
            d.add((IndexableField)new TextField(PUBLIC_POST_MESSAGE, str, Field.Store.NO));
            String[] prg = str.split(NewPublicPostDialog.SUBJECTBODY);
            String subj = prg[0];
            subj = Replier.removeSubjectRe(subj);
            d.add((IndexableField)new TextField(PUBLIC_POST_SUBJECT, subj, Field.Store.NO));
            d.add((IndexableField)new StringField(PUBLIC_POST_SUBJECT_STR, subj, Field.Store.YES));
        }
        if (!allnull) {
            if (lp.getToPeer() != null) {
                d.add((IndexableField)new TextField(PUBLIC_POST_TOPEER, lp.getToPeer(), Field.Store.NO));
            }
            if (lp.getNetworkTitle() != null) {
                d.add((IndexableField)new TextField(PUBLIC_POST_GROUP, lp.getNetworkTitle(), Field.Store.NO));
            }
            if (lp.getCreator() != null) {
                d.add((IndexableField)new TextField(PUBLIC_POST_CREATOR, lp.getCreator(), Field.Store.NO));
            }
            if (lp.getToPeer() != null) {
                d.add((IndexableField)new StringField(PUBLIC_POST_TOPEER_STR, lp.getToPeer(), Field.Store.YES));
            }
            if (lp.getNetworkTitle() != null) {
                d.add((IndexableField)new StringField(PUBLIC_POST_GROUP_STR, lp.getNetworkTitle(), Field.Store.YES));
            }
            if (lp.getCreator() != null) {
                d.add((IndexableField)new StringField(PUBLIC_POST_CREATOR_STR, lp.getCreator(), Field.Store.YES));
            }
            if (lp.getPublicPost().getRDate() != null) {
                d.add((IndexableField)new LongField(PUBLIC_POST_CDATE, lp.getPublicPost().getRDate().getTime(), Field.Store.YES));
            }
            d.add((IndexableField)new StringField(PUBLIC_POST_PRIVATE, lp.isPrivateMessage() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(PUBLIC_POST_ENCRYPTED, lp.getPublicPost().isEncrypted() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new LongField(PUBLIC_POST_DATE, lp.getLocalDate().getTime(), Field.Store.YES));
            d.add((IndexableField)new StringField(PUBLIC_POST_PEERID, lp.getPublicPost().getSignature().getPeerIdentifier().toHexString(), Field.Store.NO));
            d.add((IndexableField)new StoredField(PUBLIC_POST_PEERID_STR, lp.getPublicPost().getSignature().getPeerIdentifier().getBytes()));
            d.add((IndexableField)new StringField(PUBLIC_POST_ID, lp.getPublicPost().getSignature().getDigest().toHexString(), Field.Store.NO));
            d.add((IndexableField)new StoredField(PUBLIC_POST_ID_STR, lp.getPublicPost().getSignature().getDigest().getBytes()));
            d.add((IndexableField)new LongField(PUBLIC_POST_PEERRANK, (long)lp.getPeerRank(), Field.Store.YES));
            d.add((IndexableField)new StringField(PUBLIC_POST_OPENED, lp.isOpened() ? "1" : "0", Field.Store.YES));
            try {
                str = this.Indexer;
                synchronized (str) {
                    if (update) {
                        this.deletePublicPostFromIndex(lp);
                    }
                    this.Indexer.addDocument((Iterable)d);
                    this.PendingIndex = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexNetwork(LocalNetwork ln, boolean update) {
        boolean allnull = true;
        Document d = new Document();
        d.add((IndexableField)new StringField(DOC_TYPE, NETWORK_TYPE, Field.Store.YES));
        String titl = ln.getNetwork().getTitleSig();
        String desc = ln.getNetwork().getDescription();
        if (titl != null) {
            allnull = false;
            d.add((IndexableField)new TextField(NETWORK_TITLE, titl, Field.Store.NO));
            d.add((IndexableField)new StringField(NETWORK_TITLE_STR, titl, Field.Store.YES));
        }
        if (desc != null) {
            allnull = false;
            d.add((IndexableField)new TextField(NETWORK_DESCRIPTION, desc, Field.Store.NO));
            d.add((IndexableField)new StringField(NETWORK_DESCRIPTION_STR, desc, Field.Store.YES));
        }
        if (!allnull) {
            if (ln.getCreator() != null) {
                d.add((IndexableField)new TextField(NETWORK_CREATOR, ln.getCreator(), Field.Store.NO));
                d.add((IndexableField)new StringField(NETWORK_CREATOR_STR, ln.getCreator(), Field.Store.YES));
            }
            if (ln.getNetwork().getRDate() != null) {
                d.add((IndexableField)new LongField(NETWORK_CDATE, ln.getNetwork().getRDate().getTime(), Field.Store.YES));
            }
            d.add((IndexableField)new LongField(NETWORK_DATE, ln.getLocalDate().getTime(), Field.Store.YES));
            d.add((IndexableField)new StringField(NETWORK_PEERID, ln.getNetwork().getSignature().getPeerIdentifier().toHexString(), Field.Store.NO));
            d.add((IndexableField)new StoredField(NETWORK_PEERID_STR, ln.getNetwork().getSignature().getPeerIdentifier().getBytes()));
            d.add((IndexableField)new StringField(NETWORK_ID, ln.getNetwork().getSignature().getDigest().toHexString(), Field.Store.NO));
            d.add((IndexableField)new StoredField(NETWORK_ID_STR, ln.getNetwork().getSignature().getDigest().getBytes()));
            d.add((IndexableField)new StringField(NETWORK_AUTH, ln.isAuthorized() ? "1" : "0", Field.Store.YES));
            d.add((IndexableField)new LongField(NETWORK_AUTH_NUM, (long)ln.getAuthorization(), Field.Store.YES));
            d.add((IndexableField)new LongField(NETWORK_PEERRANK, (long)ln.getPeerRank(), Field.Store.YES));
            try {
                IndexWriter indexWriter = this.Indexer;
                synchronized (indexWriter) {
                    if (update) {
                        this.deleteNetworkFromIndex(ln);
                    }
                    this.Indexer.addDocument((Iterable)d);
                    this.PendingIndex = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexPeer(LocalPeer lp, boolean update) {
        boolean allnull = true;
        Peer p = lp.getPeer();
        Document d = new Document();
        d.add((IndexableField)new StringField(DOC_TYPE, PEER_TYPE, Field.Store.YES));
        if (p.getIntroduction() != null) {
            allnull = false;
            d.add((IndexableField)new TextField(PEER_INTRO, p.getIntroduction(), Field.Store.NO));
            d.add((IndexableField)new StringField(PEER_INTRO_STR, p.getIntroduction(), Field.Store.YES));
        }
        if (p.getNickname() != null) {
            allnull = false;
            d.add((IndexableField)new TextField(PEER_NICKNAME, p.getNickSig(), Field.Store.NO));
            d.add((IndexableField)new StringField(PEER_NICKNAME_STR, p.getNickSig(), Field.Store.YES));
        }
        if (!allnull) {
            if (lp.getPeer().getRDate() != null) {
                d.add((IndexableField)new LongField(PEER_CDATE, lp.getPeer().getRDate().getTime(), Field.Store.YES));
            }
            d.add((IndexableField)new LongField(PEER_RANK, (long)lp.getRank(), Field.Store.YES));
            d.add((IndexableField)new LongField(PEER_DATE, lp.getLocalDate().getTime(), Field.Store.YES));
            d.add((IndexableField)new StringField(PEER_ID, p.getIdentity().toHexString(), Field.Store.NO));
            d.add((IndexableField)new StoredField(PEER_ID_STR, p.getIdentity().getBytes()));
            try {
                IndexWriter indexWriter = this.Indexer;
                synchronized (indexWriter) {
                    if (update) {
                        this.deletePeerFromIndex(lp);
                    }
                    Log.info("INDEX PERE!");
                    this.Indexer.addDocument((Iterable)d);
                    this.PendingIndex = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void deletePublicPostFromIndex(LocalPublicPost pp) throws IOException {
        TermQuery id0 = new TermQuery(new Term(PUBLIC_POST_ID, pp.getPublicPost().getSignature().getDigest().toHexString()));
        this.Indexer.deleteDocuments((Query)id0);
        this.PendingIndex = true;
    }

    public void deletePeerFromIndex(LocalPeer lp) throws IOException {
        TermQuery id0 = new TermQuery(new Term(PEER_ID, lp.getPeer().getIdentity().toHexString()));
        this.Indexer.deleteDocuments((Query)id0);
        this.PendingIndex = true;
    }

    public void deletePostFromIndex(LocalPost lp) throws IOException {
        TermQuery id0 = new TermQuery(new Term(POST_ID, lp.getPost().getSignedDigest().getDigest().toHexString()));
        this.Indexer.deleteDocuments((Query)id0);
        this.PendingIndex = true;
    }

    public void deleteNetworkFromIndex(LocalNetwork ln) throws IOException {
        TermQuery id0 = new TermQuery(new Term(NETWORK_ID, ln.getNetwork().getSignature().getDigest().toHexString()));
        this.Indexer.deleteDocuments((Query)id0);
        this.PendingIndex = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexPost(LocalPost lp, boolean update) {
        PostTemplate pt;
        Post p = lp.getPost();
        Object m = p.getMessage();
        boolean useful = false;
        Document d = new Document();
        if (m != null && m instanceof PostMessage) {
            useful = true;
            d.add((IndexableField)new StringField(DOC_TYPE, POST_TYPE, Field.Store.YES));
            PostMessage pm = (PostMessage)m;
            if (pm.getFileName() != null) {
                d.add((IndexableField)new TextField(POST_FILENAME, pm.getFileName(), Field.Store.NO));
                d.add((IndexableField)new StringField(POST_FILENAME_STR, pm.getFileName(), Field.Store.YES));
                useful = true;
            }
            if (pm.getSubject() != null) {
                String subj = Replier.removeSubjectRe(pm.getSubject());
                d.add((IndexableField)new TextField(POST_SUBJECT, subj, Field.Store.NO));
                d.add((IndexableField)new StringField(POST_SUBJECT_STR, subj, Field.Store.YES));
                useful = true;
            }
            if (FileHandler.MASTER_VALUE.equals(pm.getString0())) {
                d.add((IndexableField)new LongField(POST_FILE_SIZE, pm.getNum1(), Field.Store.YES));
            }
            if (pm.getComment() != null) {
                d.add((IndexableField)new TextField(POST_COMMENT, pm.getComment(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString0() != null) {
                d.add((IndexableField)new TextField(POST_STRING0, pm.getString0(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString1() != null) {
                d.add((IndexableField)new TextField(POST_STRING1, pm.getString1(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString2() != null) {
                d.add((IndexableField)new TextField(POST_STRING2, pm.getString2(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString3() != null) {
                d.add((IndexableField)new TextField(POST_STRING3, pm.getString3(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString4() != null) {
                d.add((IndexableField)new TextField(POST_STRING4, pm.getString4(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString5() != null) {
                d.add((IndexableField)new TextField(POST_STRING5, pm.getString5(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString6() != null) {
                d.add((IndexableField)new TextField(POST_STRING6, pm.getString6(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString7() != null) {
                d.add((IndexableField)new TextField(POST_STRING7, pm.getString7(), Field.Store.NO));
                useful = true;
            }
            if (pm.getRef0() != null) {
                useful = true;
                d.add((IndexableField)new StringField(POST_REF0, pm.getRef0().toHexString(), Field.Store.NO));
                d.add((IndexableField)new StoredField(POST_REF0_STR, pm.getRef0().getBytes()));
            }
            if (pm.getRef1() != null) {
                useful = true;
                d.add((IndexableField)new StringField(POST_REF1, pm.getRef1().toHexString(), Field.Store.NO));
                d.add((IndexableField)new StoredField(POST_REF1_STR, pm.getRef1().getBytes()));
            }
            if (pm.getRef2() != null) {
                useful = true;
                d.add((IndexableField)new StringField(POST_REF2, pm.getRef2().toHexString(), Field.Store.NO));
                d.add((IndexableField)new StoredField(POST_REF2_STR, pm.getRef2().getBytes()));
            }
            if (pm.getUseTemplate() != null) {
                useful = true;
                d.add((IndexableField)new StringField(POST_USETEMPLATE, pm.getUseTemplate().toHexString(), Field.Store.NO));
            }
            d.add((IndexableField)new LongField(POST_NUM0, pm.getNum0(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM1, pm.getNum1(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM2, pm.getNum2(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM3, pm.getNum3(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM4, pm.getNum4(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM5, pm.getNum5(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM6, pm.getNum6(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM7, pm.getNum7(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM8, pm.getNum8(), Field.Store.NO));
            d.add((IndexableField)new LongField(POST_NUM9, pm.getNum9(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE0, pm.getDouble0(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE1, pm.getDouble1(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE2, pm.getDouble2(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE3, pm.getDouble3(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE4, pm.getDouble4(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE5, pm.getDouble5(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE6, pm.getDouble6(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE7, pm.getDouble7(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE8, pm.getDouble8(), Field.Store.NO));
            d.add((IndexableField)new DoubleField(POST_DOUBLE9, pm.getDouble9(), Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL0, pm.isBool0() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL1, pm.isBool1() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL2, pm.isBool2() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL3, pm.isBool3() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL4, pm.isBool4() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL5, pm.isBool5() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL6, pm.isBool6() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL7, pm.isBool7() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL8, pm.isBool8() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(POST_BOOL9, pm.isBool9() ? "1" : "0", Field.Store.NO));
        }
        if (m != null && m instanceof PostTemplate) {
            String v;
            useful = true;
            d.add((IndexableField)new StringField(DOC_TYPE, TEMPLATE_TYPE, Field.Store.YES));
            pt = (PostTemplate)m;
            d.add((IndexableField)new TextField(POST_TEMPLATE_NAME, pt.getTemplateName(), Field.Store.YES));
            if (pt.getTemplateDescription() != null) {
                d.add((IndexableField)new TextField(POST_TEMPLATE_DESC, pt.getTemplateDescription(), Field.Store.YES));
            }
            StringBuilder sb = new StringBuilder();
            int c = 0;
            while (c < 10) {
                v = pt.getBool(c);
                if (v != null) {
                    sb.append(v);
                    sb.append(" ");
                }
                ++c;
            }
            c = 0;
            while (c < 10) {
                v = pt.getDouble(c);
                if (v != null) {
                    sb.append(v);
                    sb.append(" ");
                }
                ++c;
            }
            c = 0;
            while (c < 10) {
                v = pt.getNum(c);
                if (v != null) {
                    sb.append(v);
                    sb.append(" ");
                }
                ++c;
            }
            c = 0;
            while (c < 3) {
                v = pt.getRef(c);
                if (v != null) {
                    sb.append(v);
                    sb.append(" ");
                }
                ++c;
            }
            c = 0;
            while (c < 8) {
                v = pt.getString(c);
                if (v != null) {
                    sb.append(v);
                    sb.append(" ");
                }
                ++c;
            }
            d.add((IndexableField)new TextField(POST_TEMPLATE_FIELDS, sb.toString(), Field.Store.NO));
        }
        if (useful) {
            if (p.getFileReferenceDigest() != null) {
                d.add((IndexableField)new StringField(POST_FILEREF, p.getFileReferenceDigest().toHexString(), Field.Store.NO));
                d.add((IndexableField)new StoredField(POST_FILEREF_STR, p.getFileReferenceDigest().getBytes()));
            }
            d.add((IndexableField)new StringField(POST_ID, p.getSignedDigest().getDigest().toHexString(), Field.Store.NO));
            d.add((IndexableField)new StoredField(POST_ID_STR, p.getSignedDigest().getDigest().getBytes()));
            d.add((IndexableField)new TextField(POST_PEERNICK, lp.getCreator(), Field.Store.NO));
            d.add((IndexableField)new StringField(POST_PEERNICK_STR, lp.getCreator(), Field.Store.YES));
            d.add((IndexableField)new LongField(POST_PEERRANK, lp.getPeerRank(), Field.Store.YES));
            d.add((IndexableField)new LongField(POST_DATE, lp.getLocalDate().getTime(), Field.Store.YES));
            d.add((IndexableField)new LongField(POST_CDATE, lp.getPost().getRDate().getTime(), Field.Store.YES));
            d.add((IndexableField)new LongField(POST_POSTNUM, lp.getPost().getPostNumber(), Field.Store.NO));
            d.add((IndexableField)new StringField(POST_PEERID, lp.getPost().getSignedDigest().getPeerIdentifier().toHexString(), Field.Store.NO));
            d.add((IndexableField)new StringField(POST_NETID, lp.getPost().getNetworkId().toHexString(), Field.Store.NO));
            d.add((IndexableField)new StringField(POST_OPENED, lp.isOpened() ? "1" : "0", Field.Store.YES));
            if (lp.getLocalFile() == null || !lp.getLocalFile().exists()) {
                d.add((IndexableField)new StringField(POST_LOCALFILE, "0", Field.Store.NO));
            } else {
                d.add((IndexableField)new StringField(POST_LOCALFILE, "1", Field.Store.NO));
                d.add((IndexableField)new TextField(POST_LOCAL_FILENAME, lp.getLocalFile().getPath(), Field.Store.NO));
                d.add((IndexableField)new StringField(POST_LOCAL_FILENAME_STR, lp.getLocalFile().getPath(), Field.Store.YES));
            }
            try {
                pt = this.Indexer;
                synchronized (pt) {
                    if (update) {
                        this.deletePostFromIndex(lp);
                    }
                    this.Indexer.addDocument((Iterable)d);
                    this.PendingIndex = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

