/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCounter<K> {
    private final ConcurrentHashMap<K, AtomicInteger> map = new ConcurrentHashMap();

    public int increment(K h) {
        AtomicInteger i = this.map.putIfAbsent(h, new AtomicInteger(1));
        if (i != null) {
            return i.incrementAndGet();
        }
        return 1;
    }

    public int count(K h) {
        AtomicInteger i = this.map.get(h);
        if (i != null) {
            return i.get();
        }
        return 0;
    }

    public Set<K> objects() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }
}

