/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.NamingServiceListener;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.FileUtil;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleFileNamingService
extends NamingService {
    private final File _file;
    private final ReentrantReadWriteLock _fileLock;
    private int _size;
    private long _lastWrite;
    private volatile boolean _isClosed;

    public SingleFileNamingService(I2PAppContext context, String filename) {
        super(context);
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(context.getRouterDir(), filename);
        }
        this._file = file;
        this._fileLock = new ReentrantReadWriteLock(true);
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        block4: {
            try {
                String key = this.getKey(hostname);
                if (key != null) {
                    return this.lookupBase64(key);
                }
            }
            catch (Exception ioe) {
                if (this._file.exists()) {
                    this._log.error("Error loading hosts file " + this._file, ioe);
                }
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error loading hosts file " + this._file, ioe);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String reverseLookup(Destination dest, Properties options) {
        block23: {
            block20: {
                block18: {
                    block19: {
                        destkey = dest.toBase64();
                        in = null;
                        this.getReadLock();
                        try {
                            try {
                                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
                                line = null;
                                while ((line = in.readLine()) != null) {
                                    if (line.startsWith("#")) continue;
                                    if (line.indexOf(35) > 0) {
                                        line = line.substring(0, line.indexOf(35)).trim();
                                    }
                                    if ((split = line.indexOf(61)) <= 0 || !destkey.equals(line.substring(split + 1))) continue;
                                    var7_10 = line.substring(0, split);
                                    var9_11 = null;
                                    if (in == null) break block18;
                                    break block19;
                                }
                                var6_8 = null;
                                break block20;
                            }
                            catch (Exception ioe) {
                                if (this._file.exists()) {
                                    this._log.error("Error loading hosts file " + this._file, ioe);
                                } else if (this._log.shouldLog(30)) {
                                    this._log.warn("Error loading hosts file " + this._file, ioe);
                                }
                                var6_9 = null;
                                var9_13 = null;
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException ioe) {
                                        // empty catch block
                                    }
                                }
                                this.releaseReadLock();
                                return var6_9;
                            }
                        }
                        catch (Throwable var8_19) {
                            block22: {
                                var9_14 = null;
                                if (in != null) {
                                    ** try [egrp 2[TRYBLOCK] [6 : 273->281)] { 
lbl44:
                                    // 1 sources

                                    in.close();
                                    break block22;
lbl46:
                                    // 1 sources

                                    catch (IOException ioe) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.releaseReadLock();
                            throw var8_19;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 273->281)] { 
lbl53:
                    // 1 sources

                    in.close();
                    break block18;
lbl55:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.releaseReadLock();
                return var7_10;
            }
            var9_12 = null;
            if (in != null) {
                ** try [egrp 2[TRYBLOCK] [6 : 273->281)] { 
lbl64:
                // 1 sources

                in.close();
                break block23;
lbl66:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        this.releaseReadLock();
        return var6_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKey(String host) throws IOException {
        block11: {
            String string;
            BufferedReader in = null;
            this.getReadLock();
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
                String line = null;
                String search = host + '=';
                while ((line = in.readLine()) != null) {
                    if (!line.startsWith(search)) continue;
                    if (line.indexOf(35) > 0) {
                        line = line.substring(0, line.indexOf(35)).trim();
                    }
                    int split = line.indexOf(61);
                    string = line.substring(split + 1);
                    Object var8_7 = null;
                    if (in == null) break block10;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.releaseReadLock();
                throw throwable;
            }
            {
                block10: {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.releaseReadLock();
                return string;
            }
            Object var8_8 = null;
            if (in == null) break block11;
            try {
                in.close();
                break block11;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            {
            }
        }
        this.releaseReadLock();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String hostname, Destination d, Properties options) {
        BufferedWriter out;
        BufferedReader in;
        block17: {
            if (this.putIfAbsent(hostname, d, options)) {
                return true;
            }
            if (!this.getWriteLock()) {
                return false;
            }
            in = null;
            out = null;
            if (!this._isClosed) break block17;
            boolean bl = false;
            Object var11_9 = null;
            this.releaseWriteLock();
            return bl;
        }
        try {
            File tmp = SecureFile.createTempFile("temp-", ".tmp", this._file.getAbsoluteFile().getParentFile());
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(tmp), "UTF-8"));
            if (this._file.exists()) {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
                String line = null;
                String search = hostname + '=';
                while ((line = in.readLine()) != null) {
                    if (line.startsWith(search)) continue;
                    out.write(line);
                    out.newLine();
                }
                in.close();
            }
            out.write(hostname);
            out.write(61);
            out.write(d.toBase64());
            out.newLine();
            out.close();
            boolean success = FileUtil.rename(tmp, this._file);
            if (success) {
                for (NamingServiceListener nsl : this._listeners) {
                    nsl.entryChanged(this, hostname, d, options);
                }
            }
            boolean bl = success;
            Object var11_10 = null;
            this.releaseWriteLock();
            return bl;
        }
        catch (IOException ioe) {
            try {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this._log.error("Error adding " + hostname, ioe);
                boolean bl = false;
                Object var11_11 = null;
                this.releaseWriteLock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.releaseWriteLock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean putIfAbsent(String hostname, Destination d, Properties options) {
        boolean i$;
        block16: {
            boolean bl;
            block15: {
                OutputStream out = null;
                if (!this.getWriteLock()) {
                    return false;
                }
                try {
                    try {
                        block14: {
                            if (this._isClosed) {
                                boolean bl2 = false;
                                Object var8_11 = null;
                                this.releaseWriteLock();
                                return bl2;
                            }
                            try {
                                if (this.getKey(hostname) == null) break block14;
                                bl = false;
                                break block15;
                            }
                            catch (IOException ioe) {
                                if (!this._file.exists()) break block14;
                                this._log.error("Error adding " + hostname, ioe);
                                boolean bl3 = false;
                                Object var8_13 = null;
                                this.releaseWriteLock();
                                return bl3;
                            }
                        }
                        out = new SecureFileOutputStream(this._file, true);
                        out.write(hostname.getBytes("UTF-8"));
                        out.write(61);
                        out.write(d.toBase64().getBytes());
                        out.write(10);
                        out.close();
                        for (NamingServiceListener nsl : this._listeners) {
                            nsl.entryAdded(this, hostname, d, options);
                        }
                        i$ = true;
                        break block16;
                    }
                    catch (IOException ioe) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        this._log.error("Error adding " + hostname, ioe);
                        boolean bl4 = false;
                        Object var8_15 = null;
                        this.releaseWriteLock();
                        return bl4;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_16 = null;
                    this.releaseWriteLock();
                    throw throwable;
                }
            }
            Object var8_12 = null;
            this.releaseWriteLock();
            return bl;
        }
        Object var8_14 = null;
        this.releaseWriteLock();
        return i$;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String hostname, Properties options) {
        boolean success;
        File tmp;
        BufferedWriter out;
        BufferedReader in;
        block20: {
            block19: {
                block18: {
                    in = null;
                    out = null;
                    if (!this.getWriteLock()) {
                        return false;
                    }
                    if (this._file.exists()) break block18;
                    boolean bl = false;
                    Object var12_9 = null;
                    this.releaseWriteLock();
                    return bl;
                }
                if (!this._isClosed) break block19;
                boolean bl = false;
                Object var12_10 = null;
                this.releaseWriteLock();
                return bl;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            tmp = SecureFile.createTempFile("temp-", ".tmp", this._file.getAbsoluteFile().getParentFile());
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(tmp), "UTF-8"));
            String line = null;
            String search = hostname + '=';
            success = false;
            while ((line = in.readLine()) != null) {
                if (line.startsWith(search)) {
                    success = true;
                    continue;
                }
                out.write(line);
                out.newLine();
            }
            in.close();
            out.close();
            if (success) break block20;
            tmp.delete();
            boolean bl = false;
            Object var12_11 = null;
            this.releaseWriteLock();
            return bl;
        }
        try {
            success = FileUtil.rename(tmp, this._file);
            if (success) {
                for (NamingServiceListener nsl : this._listeners) {
                    nsl.entryRemoved(this, hostname);
                }
            }
            boolean bl = success;
            Object var12_12 = null;
            this.releaseWriteLock();
            return bl;
        }
        catch (IOException ioe) {
            try {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this._log.error("Error removing " + hostname, ioe);
                boolean bl = false;
                Object var12_13 = null;
                this.releaseWriteLock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                this.releaseWriteLock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Map<String, Destination> getEntries(Properties options) {
        HashMap<String, Destination> hashMap;
        BufferedReader in;
        block17: {
            if (!this._file.exists()) {
                return Collections.EMPTY_MAP;
            }
            String searchOpt = null;
            String startsWith = null;
            if (options != null) {
                searchOpt = options.getProperty("search");
                startsWith = options.getProperty("startsWith");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Searching  starting with " + startsWith + " search string " + searchOpt);
            }
            in = null;
            this.getReadLock();
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            HashMap<String, Destination> rv = new HashMap<String, Destination>();
            while ((line = in.readLine()) != null) {
                int split;
                if (line.length() <= 0 || startsWith != null && (!startsWith.equals("[0-9]") ? !line.startsWith(startsWith) : line.charAt(0) < '0' || line.charAt(0) > '9')) continue;
                if (line.startsWith("#")) continue;
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if ((split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                if (searchOpt != null && key.indexOf(searchOpt) < 0) continue;
                String b64 = line.substring(split + 1);
                try {
                    Destination dest = new Destination(b64);
                    rv.put(key, dest);
                }
                catch (DataFormatException dfe) {}
            }
            if (searchOpt == null && startsWith == null) {
                this._lastWrite = this._file.lastModified();
                this._size = rv.size();
            }
            hashMap = rv;
            Object var12_15 = null;
            if (in == null) break block17;
            try {
                in.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
        }
        this.releaseReadLock();
        return hashMap;
        catch (IOException ioe) {
            Map map;
            block18: {
                try {
                    this._log.error("getEntries error", ioe);
                    map = Collections.EMPTY_MAP;
                    Object var12_16 = null;
                    if (in == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    this.releaseReadLock();
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            this.releaseReadLock();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Set<String> getNames(Properties options) {
        HashSet<String> hashSet;
        BufferedReader in;
        block11: {
            if (!this._file.exists()) {
                return Collections.EMPTY_SET;
            }
            in = null;
            this.getReadLock();
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            HashSet<String> rv = new HashSet<String>();
            while ((line = in.readLine()) != null) {
                int split;
                if (line.length() <= 0 || line.startsWith("#") || (split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                rv.add(key);
            }
            hashSet = rv;
            Object var8_10 = null;
            if (in == null) break block11;
            try {
                in.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
        }
        this.releaseReadLock();
        return hashSet;
        catch (IOException ioe) {
            Set set;
            block12: {
                try {
                    this._log.error("getNames error", ioe);
                    set = Collections.EMPTY_SET;
                    Object var8_11 = null;
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    this.releaseReadLock();
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            this.releaseReadLock();
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int size(Properties options) {
        int n;
        BufferedReader in;
        block15: {
            block13: {
                int n2;
                block14: {
                    if (!this._file.exists()) {
                        return 0;
                    }
                    in = null;
                    this.getReadLock();
                    if (this._file.lastModified() > this._lastWrite) break block13;
                    n2 = this._size;
                    Object var7_6 = null;
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                this.releaseReadLock();
                return n2;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            int rv = 0;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#") || line.length() <= 0) continue;
                ++rv;
            }
            this._lastWrite = this._file.lastModified();
            this._size = rv;
            n = rv;
            Object var7_7 = null;
            if (in == null) break block15;
            try {
                in.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
        }
        this.releaseReadLock();
        return n;
        catch (IOException ioe) {
            int n3;
            block16: {
                try {
                    this._log.error("size() error", ioe);
                    n3 = -1;
                    Object var7_8 = null;
                    if (in == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    this.releaseReadLock();
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            this.releaseReadLock();
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!this.getWriteLock()) {
            return;
        }
        try {
            this._isClosed = true;
            Object var2_1 = null;
            this.releaseWriteLock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseWriteLock();
            throw throwable;
        }
    }

    private void getReadLock() {
        this._fileLock.readLock().lock();
    }

    private void releaseReadLock() {
        this._fileLock.readLock().unlock();
    }

    private boolean getWriteLock() {
        try {
            boolean rv = this._fileLock.writeLock().tryLock(10000L, TimeUnit.MILLISECONDS);
            if (!rv && this._log.shouldLog(30)) {
                this._log.warn("no lock, size is: " + this._fileLock.getQueueLength(), new Exception("rats"));
            }
            return rv;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void releaseWriteLock() {
        this._fileLock.writeLock().unlock();
    }
}

