/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import net.i2p.I2PAppContext;
import net.i2p.client.HandlerImpl;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.DataFormatException;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.ReceiveMessageEndMessage;

class MessagePayloadMessageHandler
extends HandlerImpl {
    public MessagePayloadMessageHandler(I2PAppContext context) {
        super(context, 31);
    }

    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        try {
            MessagePayloadMessage msg = (MessagePayloadMessage)message;
            long id = msg.getMessageId();
            this.decryptPayload(msg, session);
            session.addNewMessage(msg);
            if (!session.getFastReceive()) {
                ReceiveMessageEndMessage m = new ReceiveMessageEndMessage();
                m.setMessageId(id);
                m.setSessionId(msg.getSessionId());
                session.sendMessage(m);
            }
        }
        catch (DataFormatException dfe) {
            session.propogateError("Error handling a new payload message", dfe);
        }
        catch (I2PSessionException ise) {
            session.propogateError("Error handling a new payload message", ise);
        }
    }

    private Payload decryptPayload(MessagePayloadMessage msg, I2PSessionImpl session) throws DataFormatException {
        Payload payload = msg.getPayload();
        payload.setUnencryptedData(payload.getEncryptedData());
        return payload;
    }
}

