/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.prng.FortunaStandalone;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class AsyncFortunaStandalone
extends FortunaStandalone
implements Runnable {
    private static final int DEFAULT_BUFFERS = 2;
    private static final int DEFAULT_BUFSIZE = 262144;
    private final int _bufferCount;
    private final int _bufferSize;
    private final Object asyncBuffers = new Object();
    private final I2PAppContext _context;
    private final Log _log;
    private volatile boolean _isRunning;
    private Thread _refillThread;
    private final LinkedBlockingQueue<AsyncBuffer> _fullBuffers;
    private final LinkedBlockingQueue<AsyncBuffer> _emptyBuffers;
    private AsyncBuffer _currentBuffer;

    public AsyncFortunaStandalone(I2PAppContext context) {
        this._bufferCount = Math.max(context.getProperty("prng.buffers", 2), 2);
        this._bufferSize = Math.max(context.getProperty("prng.bufferSize", 262144), 16384);
        this._emptyBuffers = new LinkedBlockingQueue(this._bufferCount);
        this._fullBuffers = new LinkedBlockingQueue(this._bufferCount);
        this._context = context;
        context.statManager().createRequiredRateStat("prng.bufferWaitTime", "Delay for random number buffer (ms)", "Encryption", new long[]{60000L, 600000L, 3600000L});
        context.statManager().createRequiredRateStat("prng.bufferFillTime", "Time to fill random number buffer (ms)", "Encryption", new long[]{60000L, 600000L, 3600000L});
        this._log = context.logManager().getLog(AsyncFortunaStandalone.class);
    }

    public void startup() {
        for (int i = 0; i < this._bufferCount; ++i) {
            this._emptyBuffers.offer(new AsyncBuffer(this._bufferSize));
        }
        this._isRunning = true;
        this._refillThread = new I2PThread(this, "PRNG");
        this._refillThread.setDaemon(true);
        this._refillThread.setPriority(2);
        this._refillThread.start();
    }

    public void shutdown() {
        this._isRunning = false;
        this._emptyBuffers.clear();
        this._fullBuffers.clear();
        this._refillThread.interrupt();
        this._currentBuffer = null;
        this.buffer = null;
    }

    public void seed(byte[] val) {
        Map<String, byte[]> props = Collections.singletonMap("gnu.crypto.prng.fortuna.seed", val);
        this.init(props);
    }

    protected void allocBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rotateBuffer() {
        Object object = this.asyncBuffers;
        synchronized (object) {
            AsyncBuffer old = this._currentBuffer;
            if (old != null) {
                this._emptyBuffers.offer(old);
            }
            long before = System.currentTimeMillis();
            AsyncBuffer nextBuffer = null;
            while (nextBuffer == null) {
                if (!this._isRunning) {
                    throw new IllegalStateException("shutdown");
                }
                try {
                    nextBuffer = this._fullBuffers.take();
                }
                catch (InterruptedException ie) {}
            }
            long waited = System.currentTimeMillis() - before;
            this._context.statManager().addRateData("prng.bufferWaitTime", waited, 0L);
            if (waited > 10000L && this._log.shouldLog(30)) {
                this._log.warn(Thread.currentThread().getName() + ": Took " + waited + "ms for a full PRNG buffer to be found");
            }
            this._currentBuffer = nextBuffer;
            this.buffer = nextBuffer.buffer;
        }
    }

    public void run() {
        while (this._isRunning) {
            AsyncBuffer aBuff = null;
            try {
                aBuff = this._emptyBuffers.take();
            }
            catch (InterruptedException ie) {
                continue;
            }
            long before = System.currentTimeMillis();
            this.doFill(aBuff.buffer);
            long after = System.currentTimeMillis();
            this._fullBuffers.offer(aBuff);
            this._context.statManager().addRateData("prng.bufferFillTime", after - before, 0L);
            Thread.yield();
            long waitTime = (after - before) * 5L;
            if (waitTime <= 0L) {
                waitTime = 50L;
            }
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException ie) {}
        }
    }

    public void fillBlock() {
        this.rotateBuffer();
    }

    private void doFill(byte[] buf) {
        if (this.pool0Count >= 64 && System.currentTimeMillis() - this.lastReseed > 100L) {
            ++this.reseedCount;
            for (int i = 0; i < 32; ++i) {
                if (this.reseedCount % (1 << i) != 0) continue;
                this.generator.addRandomBytes(this.pools[i].digest());
            }
            this.lastReseed = System.currentTimeMillis();
        }
        this.generator.nextBytes(buf);
    }

    private static class AsyncBuffer {
        public final byte[] buffer;

        public AsyncBuffer(int size) {
            this.buffer = new byte[size];
        }
    }
}

