/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.utilities;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import net.i2p.data.Base64;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.utilities.ByteCounter;
import org.ourfilesystem.utilities.FileUtils;
import org.ourfilesystem.utilities.MyData;

public class DumbMIME {
    public static String START = "START--------234~~>>OFS<<!---~~~~------";
    public static String END = "END--------234~~>>OFS<<!---~~~~------";
    public static int LineWidth = 60;

    public static String bytes2MIME(byte[] i) {
        StringBuilder sb = new StringBuilder();
        sb.append(START);
        sb.append("\n");
        String raw = Base64.encode((byte[])i);
        int idx = 0;
        while (idx < raw.length()) {
            int end = Math.min(idx + LineWidth, raw.length());
            sb.append(raw.substring(idx, end));
            sb.append("\n");
            idx += LineWidth;
        }
        sb.append(END);
        return sb.toString();
    }

    public static void writeBytes2MIME(byte[] i, PrintWriter pw) {
        pw.println();
        pw.println(DumbMIME.bytes2MIME(i));
    }

    public static Peer getMIME2Peer(String str) throws IOException {
        byte[] b;
        ByteCounter bc = new ByteCounter();
        String[] lines = str.split("\\s+");
        StringBuilder sb = new StringBuilder();
        boolean end = false;
        boolean start = false;
        int cnt = 0;
        while (cnt < lines.length && !end) {
            if (lines[cnt].equals(END)) {
                end = true;
            }
            if (start && !end) {
                sb.append(lines[cnt]);
            }
            if (lines[cnt].equals(START)) {
                start = true;
            }
            ++cnt;
        }
        String s = sb.toString();
        if (s.length() > 0 && (b = Base64.decode((String)sb.toString())) != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            return FileUtils.readPeer(bis, bc);
        }
        return null;
    }

    public static String getPeer2MIME(Peer p) throws IOException {
        ByteCounter c = new ByteCounter();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileUtils.writePeer(bos, p, c);
        byte[] b = bos.toByteArray();
        return DumbMIME.bytes2MIME(b);
    }

    public static void writePeer2MIME(Peer p, PrintWriter pw) throws IOException {
        ByteCounter c = new ByteCounter();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileUtils.writePeer(bos, p, c);
        byte[] b = bos.toByteArray();
        DumbMIME.writeBytes2MIME(b, pw);
    }

    public static byte[] readMIME2Bytes(BufferedReader br) throws IOException {
        boolean start = false;
        StringBuilder sb = new StringBuilder();
        String str;
        while ((str = br.readLine()) != null) {
            if (str.equals(END)) {
                return Base64.decode((String)sb.toString());
            }
            if (start) {
                sb.append(str);
            }
            if (!str.equals(START)) continue;
            start = true;
        }
        return null;
    }

    public static Peer readMIME2Peer(BufferedReader br) throws IOException {
        ByteCounter c = new ByteCounter();
        byte[] b = DumbMIME.readMIME2Bytes(br);
        if (b == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        return FileUtils.readPeer(bis, c);
    }

    public static byte[] readFile(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        byte[] r = DumbMIME.readMIME2Bytes(br);
        br.close();
        return r;
    }

    public static void writeFile(File f, byte[] b) throws IOException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(f));
        DumbMIME.writeBytes2MIME(b, pw);
        pw.close();
    }

    public static void writePeerFile(File f, Peer p) throws IOException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(f));
        DumbMIME.writePeer2MIME(p, pw);
        pw.close();
    }

    public static Peer readPeerFile(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        Peer p = DumbMIME.readMIME2Peer(br);
        br.close();
        return p;
    }

    public static void savePeers(File f, List<Peer> pl) throws IOException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(f));
        for (Peer p : pl) {
            DumbMIME.writePeer2MIME(p, pw);
        }
        pw.close();
    }

    public static List<Peer> readPeers(File f) throws IOException {
        LinkedList<Peer> pl = new LinkedList<Peer>();
        BufferedReader br = new BufferedReader(new FileReader(f));
        boolean ok = true;
        while (ok) {
            Peer p = DumbMIME.readMIME2Peer(br);
            if (p == null) {
                ok = false;
                continue;
            }
            pl.add(p);
        }
        br.close();
        return pl;
    }

    public static void writeMyDataFile(File f, KeySet k, Peer p) throws IOException {
        ByteCounter c = new ByteCounter();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SecurityTools.writeKeySet(k, bos, c);
        FileUtils.writePeer(bos, p, c);
        byte[] b = bos.toByteArray();
        DumbMIME.writeFile(f, b);
    }

    public static MyData readKeySetFile(File f) throws IOException {
        ByteCounter c = new ByteCounter();
        byte[] b = DumbMIME.readFile(f);
        if (b == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        MyData md = new MyData();
        md.KeySet = SecurityTools.readKeySet(bis, c);
        md.Peer = FileUtils.readPeer(bis, c);
        return md;
    }

    public static void main(String[] arg) {
        if (arg.length < 1) {
            System.out.println("You must specify the peer data file.");
            System.exit(1);
        }
        try {
            File f = new File(arg[0]);
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            Peer p = DumbMIME.readMIME2Peer(br);
            int cnt = 0;
            while (p != null) {
                System.out.println("=================================== " + cnt);
                System.out.println("Nickname: " + p.getNickname());
                System.out.println("Intro:    " + p.getIntroduction());
                System.out.println("Hostname: " + p.getLocation());
                System.out.println("Update num: " + p.getUpdateCount());
                ++cnt;
                p = DumbMIME.readMIME2Peer(br);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

