/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkSelectInterface;

public class TemplateTableModel
extends AbstractTableModel
implements NetworkSelectInterface {
    private static final long serialVersionUID = 1L;
    private Main Mn;
    private List<PostTemplate> Templates;
    private LocalNetwork CurNetwork;
    private LocalNetworkAuthorization CurAuth;

    public TemplateTableModel(Main m) {
        this.Mn = m;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int c) {
        return "Templates";
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Templates != null) {
            return this.Templates.size();
        }
        return 0;
    }

    public synchronized PostTemplate getTemplate(int r) {
        if (this.Templates != null && r < this.Templates.size()) {
            return this.Templates.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        PostTemplate p = this.getTemplate(r);
        if (p != null) {
            return p.getTemplateName();
        }
        return null;
    }

    public synchronized void saveNewTemplate(PostTemplate t) {
        if (t.getNetworkId() != null) {
            this.Mn.getCoreUser().addPostTemplate(t);
            this.Templates = this.Mn.getCoreDB().getPostTemplates(t.getNetworkId());
            this.fireTableDataChanged();
        }
    }

    @Override
    public synchronized void setSelectedNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        this.CurNetwork = network;
        this.CurAuth = auth;
        this.Templates = this.Mn.getCoreDB().getPostTemplates(network.getNetwork().getSignature().getDigest());
        this.fireTableDataChanged();
    }

    public synchronized void refresh() {
        if (this.CurNetwork != null) {
            this.setSelectedNetwork(this.CurNetwork, this.CurAuth);
        }
    }
}

