/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.ui.Main;

public class SignDialogs {
    private Main Mn;
    private Component Parent;
    private LocalNetworkAuthorization CurAuth;
    private LocalPeer Peer;

    public SignDialogs(Main m, Component parent) {
        this.Mn = m;
        this.Parent = parent;
    }

    public void sign() {
        if (this.CurAuth != null) {
            if (this.Peer != null) {
                if (this.CurAuth.getNetworkAuthorization().getSignAuthority() == NetworkAuthorization.CANSIGN) {
                    int v = JOptionPane.showConfirmDialog(this.Parent, "Are you sure you want to grant this person authorization?\nIt cannot be revoked, and they will not be able to grant\nothers authorization.", "Grant access", 0, 2);
                    if (v == 0) {
                        this.Mn.getCoreUser().signPeer(this.CurAuth.getNetworkAuthorization().getNetworkId(), this.Peer, NetworkAuthorization.NOSIGN);
                    }
                } else if (this.CurAuth.getNetworkAuthorization().getSignAuthority() == NetworkAuthorization.CANGIVESIGNAUTH) {
                    Object[] options = new Object[]{"Allow Access (No signing authority)", "Grant signing authority", "Grant super authority (Can grant signing authority)"};
                    Object v = JOptionPane.showInputDialog(this.Parent, "Are you sure you want to grant this person authorization?\nIt cannot be revoked or changed later!", "Grant access", 2, null, options, options[0]);
                    if (options[0].equals(v)) {
                        this.Mn.getCoreUser().signPeer(this.CurAuth.getNetworkAuthorization().getNetworkId(), this.Peer, NetworkAuthorization.NOSIGN);
                    }
                    if (options[1].equals(v)) {
                        this.Mn.getCoreUser().signPeer(this.CurAuth.getNetworkAuthorization().getNetworkId(), this.Peer, NetworkAuthorization.CANSIGN);
                    }
                    if (options[2].equals(v)) {
                        this.Mn.getCoreUser().signPeer(this.CurAuth.getNetworkAuthorization().getNetworkId(), this.Peer, NetworkAuthorization.CANGIVESIGNAUTH);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.Parent, "You cannot grant authorization", "Not authorized", 2);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.Parent, "A group must be selected first.\nUse the Group tab.", "Not authorized", 2);
        }
    }

    public Main getMn() {
        return this.Mn;
    }

    public void setMn(Main mn) {
        this.Mn = mn;
    }

    public Component getParent() {
        return this.Parent;
    }

    public void setParent(Component parent) {
        this.Parent = parent;
    }

    public LocalNetworkAuthorization getCurAuth() {
        return this.CurAuth;
    }

    public void setCurAuth(LocalNetworkAuthorization curAuth) {
        this.CurAuth = curAuth;
    }

    public LocalPeer getPeer() {
        return this.Peer;
    }

    public void setPeer(LocalPeer peer) {
        this.Peer = peer;
    }
}

