/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkSelectInterface;

public class QueryTableModel
extends AbstractTableModel
implements NetworkSelectInterface {
    private static final long serialVersionUID = 1L;
    private Main Mn;
    private List<SearchQuery> Queries;
    private LocalNetwork CurNetwork;
    private LocalNetworkAuthorization CurAuth;

    public QueryTableModel(Main m) {
        this.Mn = m;
    }

    public synchronized void saveSearchQuery(SearchQuery s) {
        if (s.Network != null) {
            this.Mn.getCoreDB().saveSearchQuery(s);
            this.Queries = this.Mn.getCoreDB().getSearchQuerys(s.Network);
            this.fireTableDataChanged();
        }
    }

    public synchronized void deleteSearchQuery(int r) {
        SearchQuery sq;
        if (this.Queries != null && (sq = this.Queries.get(r)) != null) {
            this.Mn.getCoreDB().deleteSearchQuery(sq);
            if (this.CurNetwork != null) {
                this.setSelectedNetwork(this.CurNetwork, this.CurAuth);
            }
        }
    }

    @Override
    public String getColumnName(int c) {
        return "Queries";
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Queries != null) {
            return this.Queries.size();
        }
        return 0;
    }

    public synchronized SearchQuery getSearchQuery(int r) {
        if (this.Queries != null && r < this.Queries.size()) {
            return this.Queries.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        SearchQuery s = this.getSearchQuery(r);
        if (s != null) {
            return s.QueryName;
        }
        return null;
    }

    @Override
    public synchronized void setSelectedNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        this.CurNetwork = network;
        this.CurAuth = auth;
        this.Queries = this.Mn.getCoreDB().getSearchQuerys(network.getNetwork().getSignature().getDigest());
        this.fireTableDataChanged();
    }
}

