/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.ui.DateRenderer;
import org.ourfilesystem.ui.NewPublicPostDialog;

public class PublicPostTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface PublicPosts;
    private String[] Columnnames = new String[]{"Creator", "Subject", "Network", "Date Created", "Date Received"};

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 3) {
            return Date.class;
        }
        if (col == 4) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenderer(JTable t) {
        DateRenderer.insertDateIntoTable(t, 3);
        DateRenderer.insertDateIntoTable(t, 4);
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.PublicPosts != null) {
            return this.PublicPosts.size();
        }
        return 0;
    }

    public synchronized LocalPublicPost getPublicPost(int r) {
        if (this.PublicPosts != null && r < this.PublicPosts.size()) {
            return (LocalPublicPost)this.PublicPosts.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalPublicPost lp = this.getPublicPost(r);
        if (lp != null) {
            String m;
            String[] parts;
            if (c == 0) {
                return lp.getCreator();
            }
            if (c == 1 && lp.getPublicPost().getMessage() instanceof String && (parts = (m = (String)lp.getPublicPost().getMessage()).split(NewPublicPostDialog.SUBJECTBODY)).length > 0) {
                return parts[0];
            }
            if (c == 2) {
                return lp.getNetworkTitle();
            }
            if (c == 3) {
                return lp.getPublicPost().getRDate();
            }
            if (c == 4) {
                return lp.getLocalDate();
            }
        }
        return null;
    }

    public synchronized void setPublicPosts(QueryResultsInterface l) {
        if (this.PublicPosts != null) {
            this.PublicPosts.Close();
        }
        this.PublicPosts = l;
        this.fireTableDataChanged();
    }
}

