/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.DataBaseCoreImplHSQLDB;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.NewPublicPostDialog;
import org.ourfilesystem.ui.PublicPostTableModel;
import org.ourfilesystem.ui.SignDialogs;
import org.ourfilesystem.ui.ViewPeerDialog;
import org.ourfilesystem.utilities.BBytes;

public class PublicPostPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JTextField textField;
    private JTextField textMax;
    private PublicPostTableModel Model;
    private NewPublicPostDialog Dialog;
    private NewPeerMessageDialog PeerMsgDialog;
    private ViewPeerDialog PeerDialog;
    private Main Mn;
    private SignDialogs SignDialogs;

    public PublicPostPanel(Main m) {
        this.Mn = m;
        this.Model = new PublicPostTableModel();
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        JPanel panel = new JPanel();
        splitPane.setLeftComponent(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        JButton btnUpdatePublicPosts = new JButton("Update Public Posts");
        panel.add((Component)btnUpdatePublicPosts, "flowx,cell 1 0,alignx right");
        btnUpdatePublicPosts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PublicPostPanel.this.Mn.getUpdater().updatePublicPostsNow();
            }
        });
        JButton btnNewButton = new JButton("Post");
        panel.add((Component)btnNewButton, "cell 1 0,alignx right");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PublicPostPanel.this.Dialog.showDialog(null);
            }
        });
        JLabel lblSearch = new JLabel("Search");
        panel.add((Component)lblSearch, "cell 0 1,alignx trailing");
        this.textField = new JTextField();
        panel.add((Component)this.textField, "flowx,cell 1 1,growx");
        this.textField.setColumns(10);
        JLabel lblmax = new JLabel("Max");
        panel.add((Component)lblmax, "cell 1 1");
        this.textMax = new JTextField("1000");
        this.textMax.setColumns(6);
        panel.add((Component)this.textMax, "cell 1 1");
        JButton btnSearch = new JButton("Search");
        panel.add((Component)btnSearch, "cell 1 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int max = 1000;
                try {
                    max = Integer.valueOf(PublicPostPanel.this.textMax.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String terms = PublicPostPanel.this.textField.getText();
                QueryResultsInterface qr = PublicPostPanel.this.Mn.getCoreDB().getDBQuery().searchPublicPosts(terms, false, DataBaseLuceneIndexer.PUBLIC_POST_DATE, max, true);
                PublicPostPanel.this.Model.setPublicPosts(qr);
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setRightComponent(scrollPane);
        this.table = new JTable(this.Model);
        this.Model.insertDateRenderer(this.table);
        this.table.setAutoCreateRowSorter(true);
        this.table.setSelectionMode(0);
        scrollPane.setViewportView(this.table);
        this.SignDialogs = new SignDialogs(this.Mn, this.table);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem view = new JMenuItem("View");
        mnu.add(view);
        view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PublicPostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PublicPostPanel.this.table.getSelectedRow();
                    r = PublicPostPanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PublicPostPanel.this.Model.getPublicPost(r);
                    if (lp != null) {
                        PublicPostPanel.this.Dialog.viewMessage(lp);
                    }
                }
            }
        });
        JMenuItem reply = new JMenuItem("Reply");
        mnu.add(reply);
        reply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PublicPostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PublicPostPanel.this.table.getSelectedRow();
                    r = PublicPostPanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PublicPostPanel.this.Model.getPublicPost(r);
                    if (lp != null) {
                        PublicPostPanel.this.Dialog.replyToMessage(lp);
                    }
                }
            }
        });
        JMenuItem grantacs = new JMenuItem("Grant Peer Group Access");
        mnu.add(grantacs);
        grantacs.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PublicPostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PublicPostPanel.this.table.getSelectedRow();
                    r = PublicPostPanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PublicPostPanel.this.Model.getPublicPost(r);
                    if (lp == null || lp.getPublicPost().getNetworkId() == null) {
                        JOptionPane.showMessageDialog(PublicPostPanel.this.table, "There's no network assocated with this post", "No Network", 2);
                        return;
                    }
                    DataBaseCoreImplHSQLDB dataBaseCoreImplHSQLDB = PublicPostPanel.this.Mn.getCoreDB();
                    synchronized (dataBaseCoreImplHSQLDB) {
                        BBytes me = PublicPostPanel.this.Mn.getCoreDB().getMyPeerData().getPeer().getPeer().getIdentity();
                        PublicPostPanel.this.SignDialogs.setPeer(PublicPostPanel.this.Mn.getCoreDB().getPeer(lp.getPublicPost().getSignature().getPeerIdentifier()));
                        PublicPostPanel.this.SignDialogs.setCurAuth(PublicPostPanel.this.Mn.getCoreDB().getNetworkAuth(lp.getPublicPost().getNetworkId(), me));
                    }
                    PublicPostPanel.this.SignDialogs.sign();
                } else {
                    JOptionPane.showMessageDialog(PublicPostPanel.this.table, "Select a message first.", "No message selected", 2);
                }
            }
        });
        JMenuItem viewpeer = new JMenuItem("View peer info");
        mnu.add(viewpeer);
        viewpeer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PublicPostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    LocalPeer peer;
                    int r = PublicPostPanel.this.table.getSelectedRow();
                    r = PublicPostPanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PublicPostPanel.this.Model.getPublicPost(r);
                    if (lp != null && (peer = PublicPostPanel.this.Mn.getCoreDB().getPeer(lp.getPublicPost().getSignature().getPeerIdentifier())) != null) {
                        PublicPostPanel.this.PeerDialog.showPeer(peer);
                    }
                }
            }
        });
        JMenuItem sendpriv = new JMenuItem("Send private message");
        mnu.add(sendpriv);
        sendpriv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PublicPostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PublicPostPanel.this.table.getSelectedRow();
                    r = PublicPostPanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PublicPostPanel.this.Model.getPublicPost(r);
                    if (lp != null) {
                        PublicPostPanel.this.PeerMsgDialog.replyToMessage(lp);
                    }
                }
            }
        });
        this.table.setComponentPopupMenu(mnu);
    }

    public NewPublicPostDialog getDialog() {
        return this.Dialog;
    }

    public void setDialog(NewPublicPostDialog dialog) {
        this.Dialog = dialog;
    }

    public ViewPeerDialog getPeerDialog() {
        return this.PeerDialog;
    }

    public void setPeerDialog(ViewPeerDialog peerDialog) {
        this.PeerDialog = peerDialog;
    }

    public NewPeerMessageDialog getPeerMsgDialog() {
        return this.PeerMsgDialog;
    }

    public void setPeerMsgDialog(NewPeerMessageDialog peerMsgDialog) {
        this.PeerMsgDialog = peerMsgDialog;
    }
}

