/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ProgramManager
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String BaseDir;
    private HashMap<String, String> ProgNames;
    private List<String> ExtList;
    private HashMap<String, String> Extensions;

    public ProgramManager(String path) throws Exception {
        this.BaseDir = path;
        File f = new File(String.valueOf(this.BaseDir) + File.separator + "program.xml");
        if (f.exists()) {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(f)));
            this.ProgNames = (HashMap)d.readObject();
            this.Extensions = (HashMap)d.readObject();
            this.ExtList = (List)d.readObject();
            d.close();
        } else {
            this.ProgNames = new HashMap();
            this.Extensions = new HashMap();
            this.ExtList = new LinkedList<String>();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ProgramManager.this.close();
            }
        });
    }

    public void close() {
        try {
            File f = new File(String.valueOf(this.BaseDir) + File.separator + "program.xml");
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(f)));
            e.writeObject(this.ProgNames);
            e.writeObject(this.Extensions);
            e.writeObject(this.ExtList);
            e.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public synchronized Program findProgramForFile(String file) {
        String[] splt = file.split("\\.");
        if (splt.length > 1) {
            String name;
            String ext = splt[splt.length - 1];
            String prog = this.Extensions.get(ext = ext.toLowerCase());
            if (prog != null && (name = this.ProgNames.get(prog)) != null) {
                Program p = new Program();
                p.Extension = ext;
                p.Name = name;
                p.Program = prog;
                return p;
            }
        }
        return null;
    }

    public synchronized void addExtension(String ext, String name, String program) {
        if (!this.Extensions.containsKey(ext)) {
            this.ExtList.add(ext);
        }
        this.Extensions.put(ext, program);
        this.ProgNames.put(program, name);
        this.fireTableDataChanged();
    }

    public synchronized void removeProgramExtension(String ext) {
        this.Extensions.remove(ext);
        this.ExtList.remove(ext);
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Extension";
        }
        if (col == 1) {
            return "Program Name";
        }
        if (col == 2) {
            return "Program Executable";
        }
        return null;
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public synchronized int getRowCount() {
        return this.Extensions.size();
    }

    public synchronized Program getRow(int r) {
        String name;
        String prog;
        String ext = this.ExtList.get(r);
        if (ext != null && (prog = this.Extensions.get(ext)) != null && (name = this.ProgNames.get(prog)) != null) {
            Program p = new Program();
            p.Extension = ext;
            p.Name = name;
            p.Program = prog;
            return p;
        }
        return null;
    }

    @Override
    public synchronized Object getValueAt(int r, int c) {
        Program p = this.getRow(r);
        if (p != null) {
            if (c == 0) {
                return p.Extension;
            }
            if (c == 1) {
                return p.Name;
            }
            if (c == 2) {
                return p.Program;
            }
        }
        return null;
    }

    public class Program {
        public String Extension;
        public String Name;
        public String Program;
    }
}

