/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.ui.DateRenderer;

public class NetworkAuthTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface NetworkAuths;
    private boolean Simple;
    private String[] Columnnames = new String[]{"Group", "Peer", "Authority", "Granted by", "Rank", "Status", "Date Created", "Date Received"};

    @Override
    public String getColumnName(int col) {
        if (this.Simple) {
            return "Your Groups";
        }
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 4) {
            return Long.class;
        }
        if (col == 6 || col == 7) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenderer(JTable t) {
        DateRenderer.insertDateIntoTable(t, 6);
        DateRenderer.insertDateIntoTable(t, 7);
    }

    @Override
    public int getColumnCount() {
        if (this.Simple) {
            return 1;
        }
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.NetworkAuths != null) {
            return this.NetworkAuths.size();
        }
        return 0;
    }

    public synchronized LocalNetworkAuthorization getNetworkAuth(int r) {
        if (this.NetworkAuths != null && r < this.NetworkAuths.size()) {
            return (LocalNetworkAuthorization)this.NetworkAuths.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalNetworkAuthorization ln = this.getNetworkAuth(r);
        if (ln != null) {
            if (this.Simple) {
                return ln.getNetworkTitle();
            }
            if (c == 0) {
                return ln.getNetworkTitle();
            }
            if (c == 1) {
                return ln.getPeerNickSig();
            }
            if (c == 2) {
                int auth = ln.getNetworkAuthorization().getSignAuthority();
                if (auth == NetworkAuthorization.NOSIGN) {
                    return "Cannot sign";
                }
                if (auth == NetworkAuthorization.CANSIGN) {
                    return "Can sign";
                }
                if (auth == NetworkAuthorization.CANGIVESIGNAUTH) {
                    return "Can give signing auth";
                }
            }
            if (c == 3) {
                return ln.getSignerNickSig();
            }
            if (c == 4) {
                return ln.getPeerRank();
            }
            if (c == 5) {
                return ln.isMarkedBad() ? "BAD" : "ok";
            }
            if (c == 6) {
                return ln.getNetworkAuthorization().getRDate();
            }
            if (c == 7) {
                return ln.getLocalDate();
            }
        }
        return null;
    }

    public synchronized void setNetworkAuths(QueryResultsInterface l) {
        if (this.NetworkAuths != null) {
            this.NetworkAuths.Close();
        }
        this.NetworkAuths = l;
        this.fireTableDataChanged();
    }

    public boolean isSimple() {
        return this.Simple;
    }

    public void setSimple(boolean simple) {
        this.Simple = simple;
    }
}

