/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkAuthTableModel;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.ViewPeerDialog;

public class AuthorizationPanel
extends JPanel
implements NetworkSelectInterface {
    private static final long serialVersionUID = 1L;
    private NetworkAuthTableModel MyAuths;
    private NetworkAuthTableModel OtherAuths;
    private ViewPeerDialog PeerDialog;
    private Main Mn;
    private JTable table;
    private JTable table_1;
    private LocalNetwork CurNetwork;
    private LocalNetworkAuthorization CurAuth;
    private JLabel lblNetwork;
    private JTextField textField;
    private NewPeerMessageDialog MessageDialog;

    public AuthorizationPanel(Main m) {
        this.Mn = m;
        this.MyAuths = new NetworkAuthTableModel();
        this.OtherAuths = new NetworkAuthTableModel();
        this.MyAuths.setSimple(true);
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        JPanel panel = new JPanel();
        splitPane.setRightComponent(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane_1 = new JSplitPane();
        panel.add((Component)splitPane_1, "Center");
        JScrollPane scrollPane = new JScrollPane();
        splitPane_1.setLeftComponent(scrollPane);
        this.table = new JTable(this.MyAuths);
        this.table.setAutoCreateRowSorter(true);
        this.table.setSelectionMode(0);
        scrollPane.setViewportView(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!AuthorizationPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = AuthorizationPanel.this.table.getSelectedRow();
                    r = AuthorizationPanel.this.table.convertRowIndexToModel(r);
                    AuthorizationPanel.this.CurAuth = AuthorizationPanel.this.MyAuths.getNetworkAuth(r);
                    AuthorizationPanel.this.CurNetwork = AuthorizationPanel.this.Mn.getCoreDB().getLocalNetwork(AuthorizationPanel.this.CurAuth.getNetworkAuthorization().getNetworkId());
                    if (AuthorizationPanel.this.CurAuth != null && AuthorizationPanel.this.CurNetwork != null) {
                        AuthorizationPanel.this.Mn.getGui().setNewNetwork(AuthorizationPanel.this.CurNetwork, AuthorizationPanel.this.CurAuth);
                    }
                }
            }
        });
        JScrollPane scrollPane_1 = new JScrollPane();
        splitPane_1.setRightComponent(scrollPane_1);
        splitPane_1.setDividerLocation(200);
        this.table_1 = new JTable(this.OtherAuths);
        this.OtherAuths.insertDateRenderer(this.table_1);
        this.table_1.setAutoCreateRowSorter(true);
        this.table_1.setSelectionMode(2);
        scrollPane_1.setViewportView(this.table_1);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem sendmessage = new JMenuItem("Send private message");
        mnu.add(sendmessage);
        sendmessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!AuthorizationPanel.this.table_1.getSelectionModel().isSelectionEmpty()) {
                    int r = AuthorizationPanel.this.table_1.getSelectedRow();
                    r = AuthorizationPanel.this.table_1.convertRowIndexToModel(r);
                    LocalNetworkAuthorization a = AuthorizationPanel.this.OtherAuths.getNetworkAuth(r);
                    if (a != null) {
                        AuthorizationPanel.this.MessageDialog.showDialog(a.getNetworkAuthorization().getPeerId(), a.getPeerNickSig(), a.getNetworkAuthorization().getNetworkId(), a.getNetworkTitle());
                    }
                }
            }
        });
        JMenuItem rank = new JMenuItem("Set Rank");
        mnu.add(rank);
        rank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = AuthorizationPanel.this.table_1.getSelectedRows();
                if (selr.length > 0) {
                    Object[] options = new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
                    Object v = JOptionPane.showInputDialog(AuthorizationPanel.this.table_1, "Select new rank.\nHigher number means more trusted.\n", "Set Rank", 2, null, options, options[1]);
                    if (v != null) {
                        int c = 0;
                        while (c < selr.length) {
                            int r = selr[c];
                            r = AuthorizationPanel.this.table_1.convertRowIndexToModel(r);
                            LocalNetworkAuthorization ln = AuthorizationPanel.this.OtherAuths.getNetworkAuth(r);
                            if (ln != null) {
                                long vl = ((Integer)v).longValue();
                                AuthorizationPanel.this.Mn.getCoreUser().updatePeerNetworkRank(ln.getNetworkAuthorization().getNetworkId(), ln.getNetworkAuthorization().getPeerId(), vl);
                            }
                            ++c;
                        }
                    }
                }
            }
        });
        JMenuItem markbad = new JMenuItem("Mark peer as bad");
        mnu.add(markbad);
        markbad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int v;
                int[] selr = AuthorizationPanel.this.table_1.getSelectedRows();
                if (selr.length > 0 && (v = JOptionPane.showConfirmDialog(AuthorizationPanel.this.table_1, "Are you sure you want to set the selected peers as bad?\nAll peers granted access by these peers will\nalso be marked bad FOREVER!", "Mark Bad", 0, 2)) == 0) {
                    int c = 0;
                    while (c < selr.length) {
                        int r = selr[c];
                        LocalNetworkAuthorization a = AuthorizationPanel.this.OtherAuths.getNetworkAuth(r);
                        if (a != null) {
                            AuthorizationPanel.this.Mn.getCoreUser().setBadPeer(a.getNetworkAuthorization().getNetworkId(), a.getNetworkAuthorization().getPeerId());
                        }
                        ++c;
                    }
                    AuthorizationPanel.this.OtherAuths.fireTableDataChanged();
                }
            }
        });
        JMenuItem viewpeer = new JMenuItem("View peer info");
        mnu.add(viewpeer);
        viewpeer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!AuthorizationPanel.this.table_1.getSelectionModel().isSelectionEmpty()) {
                    LocalPeer peer;
                    int r = AuthorizationPanel.this.table_1.getSelectedRow();
                    r = AuthorizationPanel.this.table_1.convertRowIndexToModel(r);
                    LocalNetworkAuthorization a = AuthorizationPanel.this.OtherAuths.getNetworkAuth(r);
                    if (a != null && (peer = AuthorizationPanel.this.Mn.getCoreDB().getPeer(a.getNetworkAuthorization().getSignature().getPeerIdentifier())) != null) {
                        AuthorizationPanel.this.PeerDialog.showPeer(peer);
                    }
                }
            }
        });
        this.table_1.setComponentPopupMenu(mnu);
        JPanel panel_1 = new JPanel();
        splitPane.setLeftComponent(panel_1);
        panel_1.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        JButton btnRefreshLists = new JButton("Update Auths");
        panel_1.add((Component)btnRefreshLists, "flowx,cell 0 0");
        btnRefreshLists.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AuthorizationPanel.this.Mn.getUpdater().updateNetworkAuthsNow();
            }
        });
        JLabel lblCurrentlySelected = new JLabel("Currently selected:");
        panel_1.add((Component)lblCurrentlySelected, "flowx,cell 1 0");
        JLabel lblSearch = new JLabel("Search");
        panel_1.add((Component)lblSearch, "cell 0 1,alignx trailing");
        this.textField = new JTextField();
        panel_1.add((Component)this.textField, "flowx,cell 1 1,growx");
        this.textField.setColumns(10);
        JButton btnSearch = new JButton("Search");
        panel_1.add((Component)btnSearch, "cell 1 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AuthorizationPanel.this.doSearch();
            }
        });
        this.lblNetwork = new JLabel("none");
        panel_1.add((Component)this.lblNetwork, "cell 1 0");
        this.doSearch();
    }

    public void doSearch() {
        QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().queryMyNetworkAuths(this.textField.getText());
        this.MyAuths.setNetworkAuths(qr);
        if (this.CurNetwork != null) {
            qr = this.Mn.getCoreDB().getDBQuery().queryNetworkAuths(this.CurNetwork.getNetwork().getSignature().getDigest());
            this.OtherAuths.setNetworkAuths(qr);
        }
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        this.CurNetwork = network;
        this.CurAuth = auth;
        if (this.CurNetwork != null) {
            this.lblNetwork.setText(this.CurNetwork.getNetwork().getTitleSig());
        }
        this.doSearch();
    }

    public NewPeerMessageDialog getMessageDialog() {
        return this.MessageDialog;
    }

    public void setMessageDialog(NewPeerMessageDialog messageDialog) {
        this.MessageDialog = messageDialog;
    }

    public ViewPeerDialog getPeerDialog() {
        return this.PeerDialog;
    }

    public void setPeerDialog(ViewPeerDialog peerDialog) {
        this.PeerDialog = peerDialog;
    }
}

