/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySet;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.ByteCounter;
import org.ourfilesystem.utilities.FileUtils;

public class SecurityTools {
    public static SecureRandom Random = new SecureRandom();

    public static AsymmetricCipherKeyPair generateKeyPair() {
        RSAKeyGenerationParameters parms = new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), Random, 2048, 40);
        RSAKeyPairGenerator gen = new RSAKeyPairGenerator();
        gen.init((KeyGenerationParameters)parms);
        return gen.generateKeyPair();
    }

    public static KeySet generateKeySet() {
        AsymmetricCipherKeyPair encpair = SecurityTools.generateKeyPair();
        AsymmetricCipherKeyPair signpair = SecurityTools.generateKeyPair();
        KeySet ks = new KeySet();
        ks.setPrivateEncryptionKey(encpair.getPrivate());
        ks.setPrivateSigningKey(signpair.getPrivate());
        PublicKeySet pub = new PublicKeySet();
        pub.setPublicEncryptionKey(encpair.getPublic());
        pub.setPublicSigningKey(signpair.getPublic());
        ks.setPublicKeySet(pub);
        return ks;
    }

    public static void writeRSAPublicKey(RSAKeyParameters p, OutputStream fos, ByteCounter c) throws IOException {
        byte[] exp = p.getExponent().toByteArray();
        byte[] mod = p.getModulus().toByteArray();
        FileUtils.writeBytes(fos, exp, c);
        FileUtils.writeBytes(fos, mod, c);
    }

    public static RSAKeyParameters readRSAPublicKey(InputStream fis, ByteCounter c) throws IOException {
        byte[] exp = FileUtils.readBytes(fis, c);
        byte[] mod = FileUtils.readBytes(fis, c);
        RSAKeyParameters pub = new RSAKeyParameters(false, new BigInteger(mod), new BigInteger(exp));
        return pub;
    }

    public static void writeRSAPrivateKey(RSAPrivateCrtKeyParameters p, OutputStream fos, ByteCounter c) throws IOException {
        FileUtils.writeBytes(fos, p.getDP().toByteArray(), c);
        FileUtils.writeBytes(fos, p.getDQ().toByteArray(), c);
        FileUtils.writeBytes(fos, p.getExponent().toByteArray(), c);
        FileUtils.writeBytes(fos, p.getModulus().toByteArray(), c);
        FileUtils.writeBytes(fos, p.getP().toByteArray(), c);
        FileUtils.writeBytes(fos, p.getPublicExponent().toByteArray(), c);
        FileUtils.writeBytes(fos, p.getQ().toByteArray(), c);
        FileUtils.writeBytes(fos, p.getQInv().toByteArray(), c);
    }

    public static RSAPrivateCrtKeyParameters readRSAPrivateKey(InputStream fis, ByteCounter c) throws IOException {
        byte[] dp = FileUtils.readBytes(fis, c);
        byte[] dq = FileUtils.readBytes(fis, c);
        byte[] exp = FileUtils.readBytes(fis, c);
        byte[] mod = FileUtils.readBytes(fis, c);
        byte[] p = FileUtils.readBytes(fis, c);
        byte[] pe = FileUtils.readBytes(fis, c);
        byte[] q = FileUtils.readBytes(fis, c);
        byte[] qi = FileUtils.readBytes(fis, c);
        RSAPrivateCrtKeyParameters priv = new RSAPrivateCrtKeyParameters(new BigInteger(mod), new BigInteger(pe), new BigInteger(exp), new BigInteger(p), new BigInteger(q), new BigInteger(dp), new BigInteger(dq), new BigInteger(qi));
        return priv;
    }

    public static void writePublicKeySet(PublicKeySet k, OutputStream fos, ByteCounter c) throws IOException {
        SecurityTools.writeRSAPublicKey((RSAKeyParameters)k.getPublicEncryptionKey(), fos, c);
        SecurityTools.writeRSAPublicKey((RSAKeyParameters)k.getPublicSigningKey(), fos, c);
    }

    public static PublicKeySet readPublicKeySet(InputStream fis, ByteCounter c) throws IOException {
        PublicKeySet p = new PublicKeySet();
        p.setPublicEncryptionKey(SecurityTools.readRSAPublicKey(fis, c));
        p.setPublicSigningKey(SecurityTools.readRSAPublicKey(fis, c));
        return p;
    }

    public static void writeSignedDigest(SignedDigest s, OutputStream fos, ByteCounter c) throws IOException {
        FileUtils.writeBytes(fos, s.getDigest().getBytes(), c);
        if (s.getPeerIdentifier() == null) {
            fos.write(2);
            c.add(1L);
        } else {
            fos.write(1);
            c.add(1L);
            FileUtils.writeBytes(fos, s.getPeerIdentifier().getBytes(), c);
        }
        FileUtils.writeBytes(fos, s.getSignature().getBytes(), c);
    }

    public static SignedDigest readSignedDigest(InputStream fis, ByteCounter c) throws IOException {
        SignedDigest s = new SignedDigest();
        s.setDigest(new BBytes(FileUtils.readBytes(fis, c)));
        int v = fis.read();
        c.add(1L);
        if (v == 2) {
            s.setPeerIdentifier(null);
        } else {
            s.setPeerIdentifier(new BBytes(FileUtils.readBytes(fis, c)));
        }
        s.setSignature(new BBytes(FileUtils.readBytes(fis, c)));
        return s;
    }

    public static void writeKeySet(KeySet k, OutputStream fos, ByteCounter c) throws IOException {
        SecurityTools.writeRSAPrivateKey((RSAPrivateCrtKeyParameters)k.getPrivateEncryptionKey(), fos, c);
        SecurityTools.writeRSAPrivateKey((RSAPrivateCrtKeyParameters)k.getPrivateSigningKey(), fos, c);
        SecurityTools.writePublicKeySet(k.getPublicKeySet(), fos, c);
    }

    public static KeySet readKeySet(InputStream fis, ByteCounter c) throws IOException {
        KeySet k = new KeySet();
        k.setPrivateEncryptionKey(SecurityTools.readRSAPrivateKey(fis, c));
        k.setPrivateSigningKey(SecurityTools.readRSAPrivateKey(fis, c));
        k.setPublicKeySet(SecurityTools.readPublicKeySet(fis, c));
        return k;
    }

    public static void DigestRSAPublicKey(Digest dig, RSAKeyParameters pub) {
        byte[] a = null;
        a = pub.getExponent().toByteArray();
        dig.update(a, 0, a.length);
        a = pub.getModulus().toByteArray();
        dig.update(a, 0, a.length);
    }

    public static byte[] digestPublicKey(PublicKeySet k) {
        SHA512Digest dig = new SHA512Digest();
        SecurityTools.DigestRSAPublicKey((Digest)dig, (RSAKeyParameters)k.getPublicEncryptionKey());
        SecurityTools.DigestRSAPublicKey((Digest)dig, (RSAKeyParameters)k.getPublicSigningKey());
        byte[] sig = new byte[dig.getDigestSize()];
        dig.doFinal(sig, 0);
        return sig;
    }

    public static void genIdentity(Peer p) {
        byte[] pdig = SecurityTools.digestPublicKey(p.getPeerKeys());
        BBytes pbb = new BBytes(pdig);
        p.setIdentity(pbb);
    }

    public static boolean verifyIdentity(Peer p) {
        byte[] pdig = SecurityTools.digestPublicKey(p.getPeerKeys());
        BBytes pbb = new BBytes(pdig);
        return pbb.equals(p.getIdentity());
    }

    public static SignedDigest signDigest(byte[] dig, BBytes peerid, RSAPrivateCrtKeyParameters key) {
        SignedDigest s = new SignedDigest();
        RSAEngine eng = new RSAEngine();
        byte[] pai = peerid.getBytes();
        byte[] signblock = new byte[dig.length + pai.length];
        System.arraycopy(dig, 0, signblock, 0, dig.length);
        System.arraycopy(pai, 0, signblock, dig.length, pai.length);
        PKCS1Encoding enc = new PKCS1Encoding((AsymmetricBlockCipher)eng);
        enc.init(true, (CipherParameters)key);
        try {
            byte[] sig = enc.processBlock(signblock, 0, signblock.length);
            s.setDigest(new BBytes(dig));
            s.setPeerIdentifier(peerid);
            s.setSignature(new BBytes(sig));
            return s;
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean verifySignedDigest(SignedDigest s, byte[] checkdig, PublicKeySet pub) {
        if (!Arrays.equals(s.getDigest().getBytes(), checkdig)) {
            return false;
        }
        RSAEngine eng = new RSAEngine();
        PKCS1Encoding enc = new PKCS1Encoding((AsymmetricBlockCipher)eng);
        enc.init(false, (CipherParameters)pub.getPublicSigningKey());
        byte[] sig = s.getSignature().getBytes();
        try {
            byte[] decsig = enc.processBlock(sig, 0, sig.length);
            byte[] encdig = new byte[checkdig.length];
            System.arraycopy(decsig, 0, encdig, 0, encdig.length);
            byte[] encpeer = new byte[decsig.length - checkdig.length];
            System.arraycopy(decsig, checkdig.length, encpeer, 0, encpeer.length);
            byte[] genpeer = SecurityTools.digestPublicKey(pub);
            return Arrays.equals(encdig, checkdig) && Arrays.equals(genpeer, encpeer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BBytes digestFile(File f, long offset, long size) throws IOException {
        SHA512Digest d = new SHA512Digest();
        SecurityTools.digestFile((Digest)d, f, offset, size);
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return new BBytes(sig);
    }

    public static void digestFile(Digest d, File f, long offset, long size) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        fis.skip(offset);
        byte[] buf = new byte[1024];
        int isize = Integer.MAX_VALUE;
        if (size < (long)isize) {
            isize = (int)size;
        }
        int len = fis.read(buf, 0, Math.min(buf.length, isize));
        while (len != -1 && size > 0L) {
            size -= (long)len;
            if (len > 0) {
                d.update(buf, 0, len);
            }
            if (size < (long)(isize = Integer.MAX_VALUE)) {
                isize = (int)size;
            }
            len = fis.read(buf, 0, Math.min(buf.length, isize));
        }
        fis.close();
    }

    public static void digestLong(Digest d, long val) {
        byte[] b = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putLong(val);
        d.update(b, 0, b.length);
    }

    public static void digestDouble(Digest d, double db) {
        byte[] b = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putDouble(db);
        d.update(b, 0, b.length);
    }

    public static void digestString(Digest d, String str) {
        if (str != null) {
            byte[] strb = str.getBytes(Charset.forName("UTF-16BE"));
            d.update(strb, 0, strb.length);
        } else {
            d.update((byte)0);
        }
    }

    public static void digestBBytes(Digest d, BBytes b) {
        if (b != null) {
            byte[] bb = b.getBytes();
            d.update(bb, 0, bb.length);
        } else {
            d.update((byte)0);
        }
    }

    public static void digestBoolean(Digest d, boolean b) {
        if (b) {
            d.update((byte)1);
        } else {
            d.update((byte)0);
        }
    }

    public static void digestDate(Digest d, Date dt) {
        if (dt == null) {
            d.update((byte)2);
        } else {
            d.update((byte)1);
            SecurityTools.digestLong(d, dt.getTime());
        }
    }

    public static BBytes digestPeerLocation(Peer p) {
        SHA512Digest d = new SHA512Digest();
        SecurityTools.digestString((Digest)d, p.getIntroduction());
        SecurityTools.digestString((Digest)d, (String)p.getLocation());
        SecurityTools.digestString((Digest)d, p.getNickname());
        SecurityTools.digestLong((Digest)d, p.getUpdateCount());
        SecurityTools.digestDate((Digest)d, p.getRDate());
        byte[] id = p.getIdentity().getBytes();
        d.update(id, 0, id.length);
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return new BBytes(sig);
    }

    public static void digestPostMessage(Digest d, PostMessage m) {
        if (m == null) {
            d.update((byte)2);
        } else {
            d.update((byte)1);
            SecurityTools.digestString(d, m.getComment());
            SecurityTools.digestString(d, m.getString0());
            SecurityTools.digestString(d, m.getString1());
            SecurityTools.digestString(d, m.getString2());
            SecurityTools.digestString(d, m.getString3());
            SecurityTools.digestString(d, m.getString4());
            SecurityTools.digestString(d, m.getString5());
            SecurityTools.digestString(d, m.getString6());
            SecurityTools.digestString(d, m.getString7());
            SecurityTools.digestString(d, m.getFileName());
            SecurityTools.digestString(d, m.getSubject());
            SecurityTools.digestDouble(d, m.getDouble0());
            SecurityTools.digestDouble(d, m.getDouble1());
            SecurityTools.digestDouble(d, m.getDouble2());
            SecurityTools.digestDouble(d, m.getDouble3());
            SecurityTools.digestDouble(d, m.getDouble4());
            SecurityTools.digestDouble(d, m.getDouble5());
            SecurityTools.digestDouble(d, m.getDouble6());
            SecurityTools.digestDouble(d, m.getDouble7());
            SecurityTools.digestDouble(d, m.getDouble8());
            SecurityTools.digestDouble(d, m.getDouble9());
            SecurityTools.digestLong(d, m.getNum0());
            SecurityTools.digestLong(d, m.getNum1());
            SecurityTools.digestLong(d, m.getNum2());
            SecurityTools.digestLong(d, m.getNum3());
            SecurityTools.digestLong(d, m.getNum4());
            SecurityTools.digestLong(d, m.getNum5());
            SecurityTools.digestLong(d, m.getNum6());
            SecurityTools.digestLong(d, m.getNum7());
            SecurityTools.digestLong(d, m.getNum8());
            SecurityTools.digestLong(d, m.getNum9());
            SecurityTools.digestBBytes(d, m.getRef0());
            SecurityTools.digestBBytes(d, m.getRef1());
            SecurityTools.digestBBytes(d, m.getRef2());
            SecurityTools.digestBBytes(d, m.getUseTemplate());
            SecurityTools.digestBoolean(d, m.isBool0());
            SecurityTools.digestBoolean(d, m.isBool1());
            SecurityTools.digestBoolean(d, m.isBool2());
            SecurityTools.digestBoolean(d, m.isBool3());
            SecurityTools.digestBoolean(d, m.isBool4());
            SecurityTools.digestBoolean(d, m.isBool5());
            SecurityTools.digestBoolean(d, m.isBool6());
            SecurityTools.digestBoolean(d, m.isBool7());
            SecurityTools.digestBoolean(d, m.isBool8());
            SecurityTools.digestBoolean(d, m.isBool9());
        }
    }

    public static BBytes digestPost(Post p, BBytes peerid) {
        SHA512Digest d = new SHA512Digest();
        SecurityTools.digestBBytes((Digest)d, p.getFileReferenceDigest());
        SecurityTools.digestBBytes((Digest)d, p.getNetworkId());
        SecurityTools.digestLong((Digest)d, p.getPostNumber());
        PostMessage pm = (PostMessage)p.getMessage();
        SecurityTools.digestPostMessage((Digest)d, pm);
        SecurityTools.digestBoolean((Digest)d, p.isPosterHasFile());
        SecurityTools.digestBBytes((Digest)d, peerid);
        SecurityTools.digestDate((Digest)d, p.getRDate());
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return new BBytes(sig);
    }

    public static BBytes digestPublicPost(PublicPost p, BBytes peerid) {
        SHA512Digest d = new SHA512Digest();
        SecurityTools.digestBBytes((Digest)d, p.getNetworkId());
        SecurityTools.digestLong((Digest)d, p.getPostNumber());
        SecurityTools.digestBoolean((Digest)d, p.isEncrypted());
        if (p.getMessage() instanceof BBytes) {
            BBytes mb = (BBytes)p.getMessage();
            SecurityTools.digestBBytes((Digest)d, mb);
        } else {
            String str = (String)p.getMessage();
            SecurityTools.digestString((Digest)d, str);
        }
        SecurityTools.digestBBytes((Digest)d, peerid);
        SecurityTools.digestDate((Digest)d, p.getRDate());
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return new BBytes(sig);
    }

    public static BBytes digestNetwork(Network n, BBytes peerid) {
        SHA512Digest d = new SHA512Digest();
        SecurityTools.digestString((Digest)d, n.getDescription());
        SecurityTools.digestLong((Digest)d, n.getNetworkNumber());
        SecurityTools.digestString((Digest)d, n.getTitle());
        SecurityTools.digestBBytes((Digest)d, peerid);
        SecurityTools.digestDate((Digest)d, n.getRDate());
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return new BBytes(sig);
    }

    public static void signNetwork(Network n, BBytes peerid, RSAPrivateCrtKeyParameters key) {
        BBytes dig = SecurityTools.digestNetwork(n, peerid);
        n.setSignature(SecurityTools.signDigest(dig.getBytes(), peerid, key));
    }

    public static boolean verifyNetwork(Network n, PublicKeySet pub) {
        BBytes dig = SecurityTools.digestNetwork(n, n.getSignature().getPeerIdentifier());
        return SecurityTools.verifySignedDigest(n.getSignature(), dig.getBytes(), pub);
    }

    public static void signPublicPost(PublicPost p, BBytes peerid, RSAPrivateCrtKeyParameters key) {
        BBytes dig = SecurityTools.digestPublicPost(p, peerid);
        p.setSignature(SecurityTools.signDigest(dig.getBytes(), peerid, key));
    }

    public static boolean verifyPublicPost(PublicPost p, PublicKeySet pub) {
        BBytes dig = SecurityTools.digestPublicPost(p, p.getSignature().getPeerIdentifier());
        return SecurityTools.verifySignedDigest(p.getSignature(), dig.getBytes(), pub);
    }

    public static void signPost(Post p, BBytes peerid, RSAPrivateCrtKeyParameters key) {
        BBytes dig = SecurityTools.digestPost(p, peerid);
        p.setSignedDigest(SecurityTools.signDigest(dig.getBytes(), peerid, key));
    }

    public static boolean verifyPost(Post p, PublicKeySet pub) {
        BBytes dig = SecurityTools.digestPost(p, p.getSignedDigest().getPeerIdentifier());
        return SecurityTools.verifySignedDigest(p.getSignedDigest(), dig.getBytes(), pub);
    }

    public static boolean verifyPeerIdentity(Peer p) {
        byte[] cdig = SecurityTools.digestPublicKey(p.getPeerKeys());
        return Arrays.equals(cdig, p.getIdentity().getBytes());
    }

    public static void signNetworkAuth(NetworkAuthorization a, BBytes peerid, RSAPrivateCrtKeyParameters key) {
        SHA512Digest d = new SHA512Digest();
        byte[] b = a.getNetworkId().getBytes();
        d.update(b, 0, b.length);
        b = a.getPeerId().getBytes();
        d.update(b, 0, b.length);
        SecurityTools.digestLong((Digest)d, a.getSignatureNumber());
        SecurityTools.digestDate((Digest)d, a.getRDate());
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        a.setSignature(SecurityTools.signDigest(sig, peerid, key));
    }

    public static boolean verifyNetworkAuth(NetworkAuthorization a, PublicKeySet pub) {
        SHA512Digest d = new SHA512Digest();
        byte[] b = a.getNetworkId().getBytes();
        d.update(b, 0, b.length);
        b = a.getPeerId().getBytes();
        d.update(b, 0, b.length);
        SecurityTools.digestLong((Digest)d, a.getSignatureNumber());
        SecurityTools.digestDate((Digest)d, a.getRDate());
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return SecurityTools.verifySignedDigest(a.getSignature(), sig, pub);
    }

    public static void signPeerLocation(Peer p, RSAPrivateCrtKeyParameters key) {
        BBytes dig = SecurityTools.digestPeerLocation(p);
        SignedDigest sg = SecurityTools.signDigest(dig.getBytes(), p.getIdentity(), key);
        p.setLocationSignature(sg);
    }

    public static boolean verifyPeerLocation(Peer p, PublicKeySet key) {
        BBytes dig = SecurityTools.digestPeerLocation(p);
        return SecurityTools.verifySignedDigest(p.getLocationSignature(), dig.getBytes(), key);
    }

    public static String decodePublicPost(BBytes enc, RSAPrivateCrtKeyParameters key) {
        byte[] dechead;
        int headlen;
        byte[] encdata;
        block8: {
            long m1;
            block7: {
                block6: {
                    try {
                        encdata = enc.getBytes();
                        ByteBuffer bbuf = ByteBuffer.wrap(encdata);
                        headlen = bbuf.getInt();
                        if (headlen > 4096) {
                            throw new Exception("Header is too long: " + headlen);
                        }
                        byte[] head = new byte[headlen];
                        System.arraycopy(encdata, 4, head, 0, headlen);
                        RSAEngine eng = new RSAEngine();
                        PKCS1Encoding eng2 = new PKCS1Encoding((AsymmetricBlockCipher)eng);
                        eng2.init(false, (CipherParameters)key);
                        dechead = eng2.processBlock(head, 0, head.length);
                        if (dechead.length >= 16) break block6;
                        return null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                ByteBuffer mbuf = ByteBuffer.wrap(dechead);
                long m0 = mbuf.getLong();
                m1 = mbuf.getLong();
                if (m0 == 19088743L) break block7;
                return null;
            }
            if (m1 == 1985229328L) break block8;
            return null;
        }
        byte[] skey = new byte[dechead.length - 16];
        System.arraycopy(dechead, 16, skey, 0, skey.length);
        KeyParameter kp = new KeyParameter(skey);
        CBCBlockCipher aes = new CBCBlockCipher((BlockCipher)new AESEngine());
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aes, (BlockCipherPadding)new PKCS7Padding());
        cipher.init(false, (CipherParameters)kp);
        int foffset = 4 + headlen;
        int enclen = encdata.length - foffset;
        byte[] output = new byte[cipher.getOutputSize(enclen)];
        int len = cipher.processBytes(encdata, foffset, enclen, output, 0);
        int len2 = cipher.doFinal(output, len);
        byte[] rawdata = new byte[len + len2];
        System.arraycopy(output, 0, rawdata, 0, rawdata.length);
        return new String(rawdata, Charset.forName("UTF-16BE"));
    }

    public static BBytes encodePublicPost(String raw, PublicKeySet pubkey) {
        try {
            byte[] strb = raw.getBytes(Charset.forName("UTF-16BE"));
            byte[] key = new byte[32];
            Random.nextBytes(key);
            KeyParameter kp = new KeyParameter(key);
            CBCBlockCipher aes = new CBCBlockCipher((BlockCipher)new AESEngine());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aes, (BlockCipherPadding)new PKCS7Padding());
            cipher.init(true, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(strb.length)];
            int len = cipher.processBytes(strb, 0, strb.length, output, 0);
            cipher.doFinal(output, len);
            RSAEngine eng = new RSAEngine();
            byte[] headblk = new byte[16 + key.length];
            ByteBuffer bbuf = ByteBuffer.wrap(headblk);
            bbuf.putLong(19088743L);
            bbuf.putLong(1985229328L);
            System.arraycopy(key, 0, headblk, 16, key.length);
            PKCS1Encoding enc = new PKCS1Encoding((AsymmetricBlockCipher)eng);
            enc.init(true, (CipherParameters)pubkey.getPublicEncryptionKey());
            byte[] enchead = enc.processBlock(headblk, 0, headblk.length);
            byte[] rslt = new byte[4 + enchead.length + output.length];
            ByteBuffer rbuf = ByteBuffer.wrap(rslt);
            rbuf.putInt(enchead.length);
            System.arraycopy(enchead, 0, rslt, 4, enchead.length);
            System.arraycopy(output, 0, rslt, 4 + enchead.length, output.length);
            BBytes orslt = new BBytes(rslt);
            return orslt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

