/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.filehandler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.filehandler.FileStatusEventInterface;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.ByteCounter;
import org.ourfilesystem.utilities.FileUtils;

public class FileHandler
implements EventInterface,
Runnable {
    public static final Logger Log = Logger.getLogger(FileHandler.class.getName());
    public static String MASTER_VALUE = "<~~>!<master_file>!<~~>";
    public static String PIECE_VALUE = "<~~>!<file_piece>!<~~>";
    public static long PIECE_SIZE = 0x100000L;
    private File MetaFileDir;
    private DataBaseCoreInterface CoreDB;
    private CoreUserInterface CoreUser;
    private boolean Closed;
    private LinkedList<FileStatusEventInterface> Events = new LinkedList();
    private boolean AutoDownloadFiles;
    private long MinRankForAutoDownload;
    private File DefaultDownloadDir;
    private long DefaultPriority;
    private TimeInterface Time;
    private ConcurrentLinkedQueue<Insert> InsertQueue;
    private ConcurrentLinkedQueue<Download> DownloadQueue;
    private ConcurrentLinkedQueue<FileStatus> ReDownloads;

    public FileHandler(String tempdir, DataBaseCoreInterface db, CoreUserInterface user, CoreComInterface com) {
        this.MetaFileDir = new File(tempdir);
        if (this.MetaFileDir.exists()) {
            if (!this.MetaFileDir.isDirectory()) {
                throw new RuntimeException("Not a directory: " + tempdir);
            }
        } else {
            this.MetaFileDir.mkdirs();
        }
        this.CoreDB = db;
        this.CoreUser = user;
        this.InsertQueue = new ConcurrentLinkedQueue();
        this.DownloadQueue = new ConcurrentLinkedQueue();
        this.ReDownloads = new ConcurrentLinkedQueue();
        this.Closed = false;
        Thread t = new Thread(this);
        t.start();
    }

    public void setDefaultDownloadDir(File dir) {
        this.DefaultDownloadDir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(FileStatusEventInterface i) {
        LinkedList<FileStatusEventInterface> linkedList = this.Events;
        synchronized (linkedList) {
            this.Events.add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileStatusEvent(FileStatus f) {
        LinkedList<FileStatusEventInterface> l = new LinkedList<FileStatusEventInterface>();
        LinkedList<FileStatusEventInterface> linkedList = this.Events;
        synchronized (linkedList) {
            l.addAll(this.Events);
        }
        for (FileStatusEventInterface e : l) {
            e.fireStatusEvent(f);
        }
    }

    public synchronized void insertFile(BBytes networkid, File source, PostMessage pm) {
        Insert i = new Insert();
        i.NetworkId = networkid;
        i.Source = source;
        i.Message = pm;
        this.InsertQueue.add(i);
        this.notifyAll();
    }

    private void doInsertFile(Insert i) {
        BBytes networkid = i.NetworkId;
        File source = i.Source;
        PostMessage pm = i.Message.clone();
        if (source.exists()) {
            FileStatus fs = null;
            fs = this.CoreDB.getFileStatus(source);
            if (fs == null) {
                try {
                    BBytes fulldig = SecurityTools.digestFile(source, 0L, source.length());
                    SHA512Digest d = new SHA512Digest();
                    long numpieces = source.length() / PIECE_SIZE;
                    if (source.length() % PIECE_SIZE > 0L) {
                        ++numpieces;
                    }
                    long c = 0L;
                    while (c < numpieces) {
                        long pat = c * PIECE_SIZE;
                        long size = Math.min(PIECE_SIZE, source.length() - pat);
                        BBytes pdig = SecurityTools.digestFile(source, pat, size);
                        SecurityTools.digestBBytes((Digest)d, pdig);
                        ++c;
                    }
                    byte[] dd = new byte[d.getDigestSize()];
                    d.doFinal(dd, 0);
                    BBytes ddb = new BBytes(dd);
                    ByteCounter tb = new ByteCounter();
                    File metafile = File.createTempFile("metafile", ".dat", this.MetaFileDir);
                    FileOutputStream fos = new FileOutputStream(metafile);
                    FileUtils.writeBBytes(fos, fulldig, tb);
                    FileUtils.writeBBytes(fos, ddb, tb);
                    FileUtils.writeLong(source.length(), fos, tb);
                    fos.close();
                    pm.setRef0(fulldig);
                    pm.setFileName(source.getName());
                    pm.setString0(MASTER_VALUE);
                    pm.setNum0(numpieces);
                    pm.setNum1(source.length());
                    pm.setNum2(PIECE_SIZE);
                    pm.setNum3(metafile.length());
                    LocalPost lp = this.CoreUser.addLocalFile(networkid, metafile, 0L, metafile.length(), pm);
                    if (lp != null) {
                        fs = new FileStatus();
                        fs.setCompleteDigest(fulldig);
                        fs.setFile(new File(source.getPath()));
                        fs.setMasterPost(new BBytes(lp.getPost().getSignedDigest().getDigest()));
                        fs.setMetaFileDigest(new BBytes(lp.getPost().getFileReferenceDigest()));
                        fs.setNetworkId(new BBytes(networkid));
                        fs.setNumberParts(numpieces);
                        fs.setNumberPartsPresent(0L);
                        fs.setPiecePostsFound(numpieces);
                        fs.setNumberPending(0L);
                        fs.setPriority(0L);
                        fs.setTotalFileSize(source.length());
                        fs.setRequestDate(this.getTime().getTime());
                        this.CoreDB.saveFileStatus(fs);
                        long c2 = 0L;
                        while (c2 < numpieces) {
                            long pat = c2 * PIECE_SIZE;
                            long size = Math.min(PIECE_SIZE, source.length() - pat);
                            pm = new PostMessage();
                            pm.setRef0(lp.getPost().getSignedDigest().getDigest());
                            pm.setString0(PIECE_VALUE);
                            pm.setNum0(pat);
                            pm.setNum1(size);
                            this.CoreUser.addLocalFile(networkid, source, pat, size, pm);
                            Log.info("Insert file part: " + pat + " : " + size);
                            fs.setNumberPartsPresent(c2 + 1L);
                            this.fireFileStatusEvent(fs);
                            ++c2;
                        }
                        this.CoreDB.saveFileStatus(fs);
                        lp.setLocalFile(source);
                        this.CoreDB.saveLocalPost(lp);
                        List<LocalPost> lplst = this.CoreDB.getPostsReferencingFile(lp.getPost().getNetworkId(), lp.getPost().getFileReferenceDigest());
                        for (LocalPost lp2 : lplst) {
                            lp2.setLocalFile(source);
                            this.CoreDB.saveLocalPost(lp2);
                        }
                    } else {
                        Log.info("Could not insert master post file");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.warning(e.getMessage());
                }
            } else {
                Log.info("FileStatus already exists!  Will not insert.");
            }
        } else {
            Log.info("Cannot insert a file that doesn't exist.");
        }
    }

    public synchronized void reDownloadFile(FileStatus fs) {
        this.ReDownloads.add(fs);
        this.notifyAll();
    }

    public synchronized void downloadFile(LocalPost master) {
        if (master.getPost().getMessage() instanceof PostMessage) {
            PostMessage pm = (PostMessage)master.getPost().getMessage();
            File tf = new File(String.valueOf(this.DefaultDownloadDir.getPath()) + File.separator + pm.getFileName());
            int cnt = 0;
            while (tf.exists() && cnt < 1000) {
                tf = new File(String.valueOf(this.DefaultDownloadDir.getPath()) + File.separator + pm.getFileName() + "_" + cnt);
                ++cnt;
            }
            if (!tf.exists()) {
                try {
                    tf.createNewFile();
                    Log.info("Download to file: " + tf.getPath());
                    this.downloadFile(master, tf, this.DefaultPriority);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void downloadFile(LocalPost master, File target, long priority) {
        Download d = new Download();
        d.MasterPost = master;
        d.Priority = priority;
        d.Target = target;
        Log.info("Target: " + d.Target);
        this.DownloadQueue.add(d);
        this.notifyAll();
    }

    private void doReDownload(FileStatus fs) throws IOException {
        File metafile = File.createTempFile("download", ".dat", this.MetaFileDir);
        this.CoreUser.downloadFile(fs.getNetworkId(), fs.getMetaFileDigest(), metafile, 0L, fs.getMetaFileSize(), false, fs.getPriority());
        List<LocalPost> lpl = this.CoreDB.getPostsReferencingFile(fs.getNetworkId(), fs.getMetaFileDigest());
        for (LocalPost lp : lpl) {
            lp.setLocalFile(fs.getFile());
            this.CoreDB.saveLocalPost(lp);
        }
    }

    private void doDownloadFile(Download d) throws IOException {
        if (d.MasterPost.getPost().getMessage() instanceof PostMessage) {
            BBytes netid = d.MasterPost.getPost().getNetworkId();
            BBytes metadig = d.MasterPost.getPost().getFileReferenceDigest();
            PostMessage pm = (PostMessage)d.MasterPost.getPost().getMessage();
            FileStatus fs = this.CoreDB.getFileStatus(netid, metadig);
            if (fs == null) {
                fs = new FileStatus();
                fs.setCompleteDigest(new BBytes(pm.getRef0()));
                fs.setFile(new File(d.Target.getPath()));
                fs.setMasterPost(new BBytes(d.MasterPost.getPost().getSignedDigest().getDigest()));
                fs.setMetaFileDigest(new BBytes(metadig));
                fs.setNetworkId(new BBytes(netid));
                fs.setNumberParts(pm.getNum0());
                fs.setNumberPartsPresent(0L);
                fs.setNumberPending(0L);
                fs.setPriority(d.Priority);
                fs.setTotalFileSize(pm.getNum1());
                fs.setMetaFileSize(pm.getNum3());
                fs.setPiecePostsFound(0L);
                fs.setCorrupted(false);
                fs.setPeerId(new BBytes(d.MasterPost.getPost().getSignedDigest().getPeerIdentifier()));
                fs.setRequestDate(this.getTime().getTime());
                this.CoreDB.saveFileStatus(fs);
                this.doReDownload(fs);
                List<LocalPost> lpl = this.CoreDB.getPostsReferencingFile(netid, metadig);
                for (LocalPost lp : lpl) {
                    lp.setLocalFile(fs.getFile());
                    this.CoreDB.saveLocalPost(lp);
                }
            } else {
                Log.info("FileStatus already exists.  Not downloading again.");
            }
            this.fireFileStatusEvent(fs);
        }
    }

    private synchronized void WaitForRequest() {
        if (this.InsertQueue.size() == 0 && this.DownloadQueue.size() == 0 && !this.Closed) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void Close() {
        this.Closed = true;
        this.notifyAll();
    }

    public void changePriority(File f, long pr) {
        FileStatus fs = this.CoreDB.getFileStatus(f);
        fs.setPriority(pr);
        this.CoreDB.saveFileStatus(fs);
        this.CoreUser.setDownloadPriority(f, pr);
        this.fireFileStatusEvent(fs);
    }

    public void removeFile(File f) {
        FileStatus fs = this.CoreDB.getFileStatus(f);
        List<LocalPost> lp = this.CoreDB.getPostsReferencingFile(fs.getNetworkId(), fs.getMetaFileDigest());
        for (LocalPost l : lp) {
            l.setLocalFile(null);
            this.CoreDB.saveLocalPost(l);
        }
        this.CoreDB.deleteFileStatus(fs);
        this.CoreUser.deleteFile(f);
    }

    @Override
    public void run() {
        while (!this.Closed) {
            FileStatus rf;
            Download d;
            this.WaitForRequest();
            Insert i = this.InsertQueue.poll();
            if (i != null) {
                this.doInsertFile(i);
            }
            if ((d = this.DownloadQueue.poll()) != null) {
                try {
                    this.doDownloadFile(d);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((rf = this.ReDownloads.poll()) == null) continue;
            try {
                this.doReDownload(rf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void newPostReceived(LocalPost post) {
        FileStatus fs;
        BBytes fileref = post.getPost().getFileReferenceDigest();
        if (fileref != null && (fs = this.CoreDB.getFileStatus(post.getPost().getNetworkId(), fileref)) != null) {
            post.setLocalFile(fs.getFile());
            this.CoreDB.saveLocalPost(post);
        }
    }

    @Override
    public void newPublicPostReceived(LocalPublicPost post) {
    }

    @Override
    public void newNetworkReceived(LocalNetwork network) {
    }

    @Override
    public void newNetworkAuthReceived(LocalNetworkAuthorization auth) {
    }

    @Override
    public void newPeerReceived(LocalPeer peer) {
    }

    @Override
    public void newFileDownloaded(FileReference filelist) {
        FileStatus fs = this.CoreDB.getFileStatus(filelist.getNetworkId(), filelist.getUnsignedDigest());
        if (fs != null) {
            Log.info("Found file status: " + fs.getFile());
            try {
                ByteCounter tb = new ByteCounter();
                FileInputStream fis = new FileInputStream(filelist.getFile());
                FileUtils.readBBytes(fis, tb);
                BBytes digofdigs = FileUtils.readBBytes(fis, tb);
                fis.close();
                SHA512Digest dig = new SHA512Digest();
                SearchQuery sq = new SearchQuery();
                sq.Network = filelist.getNetworkId();
                sq.PeerId = fs.getPeerId();
                sq.Refs0 = fs.getMasterPost();
                sq.SortBy = DataBaseLuceneIndexer.POST_POSTNUM;
                sq.SortReverse = false;
                sq.MaxResults = (int)fs.getNumberParts() * 2;
                QueryResultsInterface qr = this.CoreDB.getDBQuery().searchPosts(sq);
                LinkedList<LocalPost> dolist = new LinkedList<LocalPost>();
                fs.setPiecePostsFound(0L);
                fs.setNumberPartsPresent(0L);
                Log.info("Number of peices found from search: " + qr.size());
                int c = 0;
                while (c < qr.size()) {
                    LocalPost lp = (LocalPost)qr.get(c);
                    Log.info("Check if post is a proper piece post.");
                    if (lp.getPost().getMessage() instanceof PostMessage) {
                        PostMessage ppm = (PostMessage)lp.getPost().getMessage();
                        if (ppm.getRef0().equals(fs.getMasterPost()) && lp.getPost().getNetworkId().equals(fs.getNetworkId()) && lp.getPost().getSignedDigest().getPeerIdentifier().equals(sq.PeerId)) {
                            fs.setPiecePostsFound(fs.getPiecePostsFound() + 1L);
                            SecurityTools.digestBBytes((Digest)dig, lp.getPost().getFileReferenceDigest());
                            dolist.add(lp);
                            Log.info("Adding piece. " + c);
                        } else {
                            Log.info("Piece was not proper for the download!");
                        }
                    } else {
                        Log.info("Post message was not a PostMessage");
                    }
                    ++c;
                }
                this.CoreDB.saveFileStatus(fs);
                this.fireFileStatusEvent(fs);
                Log.info("Ok!  Number of pieces: " + dolist.size());
                byte[] chkdig = new byte[dig.getDigestSize()];
                dig.doFinal(chkdig, 0);
                BBytes chkb = new BBytes(chkdig);
                if (chkb.equals(digofdigs)) {
                    Log.info("Digest matches!");
                    for (LocalPost lp : dolist) {
                        PostMessage ppm = (PostMessage)lp.getPost().getMessage();
                        this.CoreUser.downloadFile(fs.getNetworkId(), lp.getPost().getFileReferenceDigest(), fs.getFile(), ppm.getNum0(), ppm.getNum1(), false, fs.getPriority());
                        Log.info("Download piece! : " + ppm.getNum0() + " : " + ppm.getNum1() + " :: " + fs.getFile().getPath());
                    }
                } else {
                    Log.warning("Digest of digests did not match the expected digest from the metafile!");
                    fs.setCorrupted(true);
                    this.CoreDB.saveFileStatus(fs);
                    this.fireFileStatusEvent(fs);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        fs = this.CoreDB.getFileStatus(filelist.getFile());
        Log.info("Is this a piece? " + fs + " checing: " + filelist.getFile().getPath());
        if (fs != null) {
            Log.info("Adding piece for: " + fs.getFile().getPath());
            fs.setNumberPartsPresent(fs.getNumberPartsPresent() + 1L);
            this.CoreDB.saveFileStatus(fs);
            this.fireFileStatusEvent(fs);
        }
    }

    @Override
    public void downloadFailed(Object dig) {
    }

    @Override
    public void connectionEvent(ConnectionUpdateInterface con) {
    }

    @Override
    public void connectionFailure(Peer p) {
    }

    public boolean isAutoDownloadFiles() {
        return this.AutoDownloadFiles;
    }

    public void setAutoDownloadFiles(boolean autoDownloadFiles) {
        this.AutoDownloadFiles = autoDownloadFiles;
    }

    public long getMinRankForAutoDownload() {
        return this.MinRankForAutoDownload;
    }

    public void setMinRankForAutoDownload(long minRankForAutoDownload) {
        this.MinRankForAutoDownload = minRankForAutoDownload;
    }

    public long getDefaultPriority() {
        return this.DefaultPriority;
    }

    public void setDefaultPriority(long defaultPriority) {
        this.DefaultPriority = defaultPriority;
    }

    public File getDefaultDownloadDir() {
        return this.DefaultDownloadDir;
    }

    public TimeInterface getTime() {
        return this.Time;
    }

    public void setTime(TimeInterface time) {
        this.Time = time;
    }

    private class Download {
        public LocalPost MasterPost;
        public File Target;
        public long Priority;

        private Download() {
        }
    }

    private class Insert {
        public BBytes NetworkId;
        public File Source;
        public PostMessage Message;

        private Insert() {
        }
    }
}

