/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.DataBaseCoreImplHSQLDB;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.TopDocsQueryResultsAbstract;
import org.ourfilesystem.utilities.BBytes;

public class PublicPostQueryResultsHSQLDB
extends TopDocsQueryResultsAbstract {
    private DataBaseCoreImplHSQLDB DB;

    public PublicPostQueryResultsHSQLDB(TopDocs t, IndexSearcher s, DirectoryReader reader, DataBaseCoreImplHSQLDB db) {
        super(t, s, reader);
        this.DB = db;
    }

    @Override
    public Object getHits(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                StoredField lf = (StoredField)d.getField(DataBaseLuceneIndexer.PUBLIC_POST_ID_STR);
                if (lf != null) {
                    BBytes lfb = new BBytes(lf.binaryValue().bytes);
                    return this.DB.getLocalPublicPost(lfb);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

