/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.NumericConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.ourfilesystem.db.DataBaseCoreImplHSQLDB;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.DataBaseQueryInterface;
import org.ourfilesystem.db.EmptyQueryResults;
import org.ourfilesystem.db.NetworkAuthQueryResultsHSQLDB;
import org.ourfilesystem.db.NetworkAuthQueryResultsList;
import org.ourfilesystem.db.NetworkQueryResultsHSQLDB;
import org.ourfilesystem.db.NetworkQueryResultsList;
import org.ourfilesystem.db.OFSAnalyzer;
import org.ourfilesystem.db.PeerQueryResultsHSQLDB;
import org.ourfilesystem.db.PeerQueryResultsList;
import org.ourfilesystem.db.PostQueryResultsHSQLDB;
import org.ourfilesystem.db.PostQueryResultsList;
import org.ourfilesystem.db.PublicPostQueryResultsHSQLDB;
import org.ourfilesystem.db.PublicPostQueryResultsList;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.utilities.BBytes;

public class DataBaseQueryHSQLDB
implements DataBaseQueryInterface {
    public static final Logger Log = Logger.getLogger(DataBaseQueryHSQLDB.class.getName());
    private String BaseDir;
    private StandardQueryParser Parser;
    private DataBaseCoreImplHSQLDB DB;

    public DataBaseQueryHSQLDB(String basedir) throws IOException, SQLException {
        this.BaseDir = basedir;
        this.DB = new DataBaseCoreImplHSQLDB(basedir, true);
        this.Parser = new StandardQueryParser((Analyzer)new OFSAnalyzer(Version.LUCENE_44));
        HashMap<String, NumericConfig> numconfig = new HashMap<String, NumericConfig>();
        NumericConfig nc = new NumericConfig(6, (NumberFormat)new DecimalFormat(), FieldType.NumericType.LONG);
        NumericConfig dc = new NumericConfig(6, (NumberFormat)new DecimalFormat(), FieldType.NumericType.DOUBLE);
        numconfig.put(DataBaseLuceneIndexer.PUBLIC_POST_DATE, nc);
        numconfig.put(DataBaseLuceneIndexer.NETWORK_DATE, nc);
        numconfig.put(DataBaseLuceneIndexer.PEER_DATE, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_DATE, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM0, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM1, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM2, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM3, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM4, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM5, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM6, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM7, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM8, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_NUM9, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_PEERRANK, nc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE0, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE1, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE2, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE3, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE4, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE5, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE6, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE7, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE8, dc);
        numconfig.put(DataBaseLuceneIndexer.POST_DOUBLE9, dc);
        this.Parser.setNumericConfigMap(numconfig);
    }

    @Override
    public void Close() {
        this.DB.Close();
    }

    @Override
    public QueryResultsInterface searchPosts(SearchQuery srch) {
        try {
            String qstring = srch.buildQueryString2();
            Matcher m = Pattern.compile("\\S+").matcher(qstring);
            if (!m.find()) {
                List<LocalPost> r = this.DB.getPosts(srch.MaxResults);
                return new PostQueryResultsList(r);
            }
            File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseLuceneIndexer.INDEX_DIR);
            SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
            DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            Sort s = srch.getSort();
            Query q = this.Parser.parse(qstring, "comment");
            TopDocs d = null;
            if (s != null) {
                d = searcher.search(q, null, srch.MaxResults, s);
                Log.info("totalHits: " + d.totalHits);
            } else {
                d = searcher.search(q, srch.MaxResults);
                Log.info("totalHits: " + d.totalHits);
            }
            return this.removeAddMarked(searcher, reader, srch, new PostQueryResultsHSQLDB(d, searcher, reader, this.DB));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EmptyQueryResults();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean searchToRemove(IndexSearcher searcher, SearchQuery sq0, Set<Long> removelist, int refnum) {
        String qstring = sq0.buildQueryString2();
        try {
            Query q = this.Parser.parse(qstring, "comment");
            TopDocs d = searcher.search(q, Integer.MAX_VALUE);
            int c0 = 0;
            while (true) {
                long pid2;
                long id2;
                long pid1;
                long id1;
                long pid0;
                long id0;
                if (c0 >= d.scoreDocs.length) {
                    return false;
                }
                ScoreDoc sd = d.scoreDocs[c0];
                Document doc = searcher.doc(sd.doc);
                StoredField sf0 = null;
                StoredField sf1 = null;
                StoredField sf2 = null;
                StoredField prf = (StoredField)doc.getField(DataBaseLuceneIndexer.POST_FILEREF_STR);
                if (refnum == 0) {
                    sf0 = (StoredField)doc.getField(DataBaseLuceneIndexer.POST_REF0_STR);
                }
                if (refnum == 1) {
                    sf1 = (StoredField)doc.getField(DataBaseLuceneIndexer.POST_REF1_STR);
                }
                if (refnum == 2) {
                    sf2 = (StoredField)doc.getField(DataBaseLuceneIndexer.POST_REF2_STR);
                }
                if (sf0 != null && prf != null && (id0 = new BBytes(sf0.binaryValue().bytes).getIndex0()) != (pid0 = new BBytes(prf.binaryValue().bytes).getIndex0()) && !removelist.contains(id0)) {
                    return true;
                }
                if (sf1 != null && prf != null && (id1 = new BBytes(sf1.binaryValue().bytes).getIndex0()) != (pid1 = new BBytes(prf.binaryValue().bytes).getIndex0()) && !removelist.contains(id1)) {
                    return true;
                }
                if (sf2 != null && prf != null && (id2 = new BBytes(sf2.binaryValue().bytes).getIndex0()) != (pid2 = new BBytes(prf.binaryValue().bytes).getIndex0()) && !removelist.contains(id2)) {
                    return true;
                }
                ++c0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void addNewRefs(IndexSearcher searcher, DirectoryReader reader, SearchQuery sq0, QueryResultsInterface qr, Set<Long> existlst) {
        String qstring = sq0.buildQueryString2();
        try {
            Query q = this.Parser.parse(qstring, "comment");
            TopDocs d = searcher.search(q, Integer.MAX_VALUE);
            PostQueryResultsHSQLDB nqr = new PostQueryResultsHSQLDB(d, searcher, reader, this.DB);
            int c = 0;
            while (c < nqr.size()) {
                LocalPost lp = (LocalPost)nqr.get(c);
                long idx0 = lp.getPost().getSignedDigest().getDigest().getIndex0();
                if (!existlst.contains(idx0)) {
                    qr.add(lp);
                    existlst.add(idx0);
                }
                ++c;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private QueryResultsInterface removeAddMarked(IndexSearcher searcher, DirectoryReader reader, SearchQuery sq, QueryResultsInterface qr) {
        try {
            if (sq.Excludefilesreferencedbyothers0 || sq.Excludefilesreferencedbyothers1 || sq.Excludefilesreferencedbyothers2 || sq.Includefileswithreferences0 || sq.Includefileswithreferences1 || sq.Includefileswithreferences2) {
                if (reader == null) {
                    File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseLuceneIndexer.INDEX_DIR);
                    SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                    reader = DirectoryReader.open((Directory)fsdir);
                }
                if (searcher == null) {
                    searcher = new IndexSearcher((IndexReader)reader);
                }
                HashSet<Long> removelist = new HashSet<Long>();
                HashSet<Long> existlist = new HashSet<Long>();
                int c = 0;
                while (c < qr.size()) {
                    LocalPost lp = (LocalPost)qr.get(c);
                    BBytes chk = lp.getPost().getFileReferenceDigest();
                    long pstid = lp.getPost().getSignedDigest().getDigest().getIndex0();
                    if (!existlist.contains(pstid) && chk != null) {
                        SearchQuery sq0;
                        boolean removed = false;
                        if (removelist.contains(chk.getIndex0())) {
                            removed = true;
                        }
                        if (!removed && sq.Excludefilesreferencedbyothers0) {
                            sq0 = new SearchQuery();
                            sq0.Minpeerrank = sq.Minpeerrank;
                            sq0.Directref = chk;
                            removed = this.searchToRemove(searcher, sq0, removelist, 0);
                        }
                        if (!removed && sq.Excludefilesreferencedbyothers1) {
                            sq0 = new SearchQuery();
                            sq0.Minpeerrank = sq.Minpeerrank;
                            sq0.Directref = chk;
                            removed = this.searchToRemove(searcher, sq0, removelist, 1);
                        }
                        if (!removed && sq.Excludefilesreferencedbyothers2) {
                            sq0 = new SearchQuery();
                            sq0.Minpeerrank = sq.Minpeerrank;
                            sq0.Directref = chk;
                            removed = this.searchToRemove(searcher, sq0, removelist, 2);
                        }
                        if (removed) {
                            qr.remove(c);
                            --c;
                            removelist.add(chk.getIndex0());
                        } else {
                            existlist.add(pstid);
                            if (sq.Includefileswithreferences0) {
                                sq0 = new SearchQuery();
                                sq0.Minpeerrank = sq.Minpeerrank;
                                sq0.Refs0 = chk;
                                this.addNewRefs(searcher, reader, sq0, qr, existlist);
                            }
                            if (sq.Includefileswithreferences1) {
                                sq0 = new SearchQuery();
                                sq0.Minpeerrank = sq.Minpeerrank;
                                sq0.Refs1 = chk;
                                this.addNewRefs(searcher, reader, sq0, qr, existlist);
                            }
                            if (sq.Includefileswithreferences2) {
                                sq0 = new SearchQuery();
                                sq0.Minpeerrank = sq.Minpeerrank;
                                sq0.Refs2 = chk;
                                this.addNewRefs(searcher, reader, sq0, qr, existlist);
                            }
                        }
                    }
                    ++c;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qr;
    }

    private Sort getNetworkSort(String col, boolean reverse) {
        if (col != null) {
            if (col.equals(DataBaseLuceneIndexer.NETWORK_DESCRIPTION)) {
                return new Sort(new SortField(DataBaseLuceneIndexer.NETWORK_DESCRIPTION, SortField.Type.STRING, reverse));
            }
            if (col.equals(DataBaseLuceneIndexer.NETWORK_TITLE)) {
                return new Sort(new SortField(DataBaseLuceneIndexer.NETWORK_TITLE, SortField.Type.STRING, reverse));
            }
        }
        return new Sort(new SortField(DataBaseLuceneIndexer.NETWORK_DATE, SortField.Type.LONG, reverse));
    }

    @Override
    public QueryResultsInterface searchNetworks(String terms, String sortfield, int max, boolean reverse) {
        Matcher m;
        if (terms != null && (m = Pattern.compile("\\S+").matcher(terms)).find()) {
            try {
                String qt = String.valueOf(DataBaseLuceneIndexer.NETWORK_TITLE) + ":" + terms + " OR " + DataBaseLuceneIndexer.NETWORK_DESCRIPTION + ":" + terms;
                File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseLuceneIndexer.INDEX_DIR);
                SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                Log.info("qstring: " + qt);
                Query q = this.Parser.parse(qt, DataBaseLuceneIndexer.NETWORK_DESCRIPTION);
                TopFieldDocs d = null;
                d = searcher.search(q, null, max, this.getNetworkSort(sortfield, reverse));
                Log.info("totalHits: " + d.totalHits);
                return new NetworkQueryResultsHSQLDB((TopDocs)d, searcher, reader, this.DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<LocalNetwork> r = this.DB.getLocalNetworks(max);
        return new NetworkQueryResultsList(r);
    }

    private Sort getPublicPostSort(String col, boolean reverse) {
        if (col != null) {
            if (col.equals(DataBaseLuceneIndexer.PUBLIC_POST_DECODED_MESSAGE)) {
                return new Sort(new SortField(DataBaseLuceneIndexer.PUBLIC_POST_DECODED_MESSAGE, SortField.Type.STRING, reverse));
            }
            if (col.equals(DataBaseLuceneIndexer.PUBLIC_POST_MESSAGE)) {
                return new Sort(new SortField(DataBaseLuceneIndexer.PUBLIC_POST_MESSAGE, SortField.Type.STRING, reverse));
            }
        }
        return new Sort(new SortField(DataBaseLuceneIndexer.PUBLIC_POST_DATE, SortField.Type.LONG, reverse));
    }

    @Override
    public QueryResultsInterface searchPublicPosts(String terms, boolean enc, String sortfield, int max, boolean reverse) {
        Matcher m;
        if (terms != null && (m = Pattern.compile("\\S+").matcher(terms)).find()) {
            try {
                String qt = "(" + DataBaseLuceneIndexer.PUBLIC_POST_DECODED_MESSAGE + ":" + terms + " OR " + DataBaseLuceneIndexer.PUBLIC_POST_MESSAGE + ":" + terms + ") AND ";
                qt = enc ? String.valueOf(qt) + DataBaseLuceneIndexer.PUBLIC_POST_PRIVATE + ":1" : String.valueOf(qt) + DataBaseLuceneIndexer.PUBLIC_POST_ENCRYPTED + ":0";
                File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseLuceneIndexer.INDEX_DIR);
                SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                Log.info("qstring: " + qt);
                Query q = this.Parser.parse(qt, DataBaseLuceneIndexer.PUBLIC_POST_MESSAGE);
                TopFieldDocs d = null;
                d = searcher.search(q, null, max, this.getPublicPostSort(sortfield, reverse));
                Log.info("totalHits: " + d.totalHits);
                return new PublicPostQueryResultsHSQLDB((TopDocs)d, searcher, reader, this.DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<LocalPublicPost> r = this.DB.getPublicPosts(max, enc);
        return new PublicPostQueryResultsList(r);
    }

    private Sort getPeerSort(String col, boolean reverse) {
        if (col != null) {
            if (col.equals(DataBaseLuceneIndexer.PEER_INTRO)) {
                return new Sort(new SortField(DataBaseLuceneIndexer.PEER_INTRO, SortField.Type.STRING, reverse));
            }
            if (col.equals(DataBaseLuceneIndexer.PEER_NICKNAME)) {
                return new Sort(new SortField(DataBaseLuceneIndexer.PEER_NICKNAME, SortField.Type.STRING, reverse));
            }
        }
        return new Sort(new SortField(DataBaseLuceneIndexer.PEER_DATE, SortField.Type.LONG, reverse));
    }

    @Override
    public QueryResultsInterface searchPeers(String terms, String sortfield, int max, boolean reverse) {
        Matcher m;
        if (terms != null && (m = Pattern.compile("\\S+").matcher(terms)).find()) {
            try {
                String qt = String.valueOf(DataBaseLuceneIndexer.PEER_NICKNAME) + ":" + terms + " OR " + DataBaseLuceneIndexer.PEER_INTRO + ":" + terms;
                File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseLuceneIndexer.INDEX_DIR);
                SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                Log.info("qstring: " + qt);
                Query q = this.Parser.parse(qt, DataBaseLuceneIndexer.PEER_INTRO);
                TopFieldDocs d = null;
                d = searcher.search(q, null, max, this.getPeerSort(sortfield, reverse));
                Log.info("totalHits: " + d.totalHits);
                return new PeerQueryResultsHSQLDB((TopDocs)d, searcher, reader, this.DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<LocalPeer> r = this.DB.getLocalPeers();
        return new PeerQueryResultsList(r);
    }

    @Override
    public QueryResultsInterface queryNetworkAuths(BBytes networkid) {
        List<LocalNetworkAuthorization> r = this.DB.getNetworkAuths(networkid);
        NetworkAuthQueryResultsList lst = new NetworkAuthQueryResultsList(r);
        return lst;
    }

    @Override
    public QueryResultsInterface queryMyNetworkAuths(String terms) {
        Matcher m;
        if (terms != null && (m = Pattern.compile("\\S+").matcher(terms)).find()) {
            try {
                String qt = "( " + DataBaseLuceneIndexer.NETWORK_TITLE + ":" + terms + " OR " + DataBaseLuceneIndexer.NETWORK_DESCRIPTION + ":" + terms + " ) AND " + DataBaseLuceneIndexer.NETWORK_AUTH + ":1";
                File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseLuceneIndexer.INDEX_DIR);
                SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                Log.info("qstring: " + qt);
                Query q = this.Parser.parse(qt, DataBaseLuceneIndexer.NETWORK_DESCRIPTION);
                TopFieldDocs d = null;
                d = searcher.search(q, null, Integer.MAX_VALUE, this.getNetworkSort(DataBaseLuceneIndexer.NETWORK_DATE, true));
                Log.info("totalHits: " + d.totalHits);
                return new NetworkAuthQueryResultsHSQLDB((TopDocs)d, searcher, reader, this.DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MyPeerDataSO me = this.DB.getMyPeerData();
        List<LocalNetworkAuthorization> lna = this.DB.getNetworkAuthsForPeer(me.getPeer().getPeer().getIdentity());
        return new NetworkAuthQueryResultsList(lna);
    }
}

