/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConnectionPoolHSQLDB {
    public static int MAXCONS = 100;
    private String DBURL;
    private ConcurrentLinkedQueue<Connection> ConList;
    private long NumCons;

    public ConnectionPoolHSQLDB(String url) {
        this.DBURL = url;
        this.ConList = new ConcurrentLinkedQueue();
        this.NumCons = 0L;
    }

    private Connection getNewCon() throws SQLException {
        return DriverManager.getConnection(this.DBURL, "SA", "");
    }

    public Connection getCon() throws SQLException {
        Connection con = this.ConList.poll();
        if (con == null) {
            con = this.getNewCon();
            ++this.NumCons;
        }
        return con;
    }

    public void done(Connection c) {
        if (this.ConList.size() > MAXCONS) {
            try {
                c.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.ConList.add(c);
    }

    public void close() {
        Connection c = this.ConList.poll();
        while (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = this.ConList.poll();
        }
    }
}

