/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.com;

import java.io.File;
import java.util.logging.Logger;
import org.ourfilesystem.com.ComConnectionInterface;
import org.ourfilesystem.com.ComPeerImpl;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSServerSocket;
import org.ourfilesystem.com.OFSSocket;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.security.CryptoComInterface;

public class ComConnectionImpl
implements ComConnectionInterface,
Runnable {
    public static final Logger Log = Logger.getLogger(ComConnectionImpl.class.getName());
    private boolean Closed;
    private CoreComInterface Core;
    private DataBaseCoreInterface DB;
    private CryptoComInterface Crypt;
    private boolean Run;
    private OFSServerSocket Server;
    private OFSConnector Connector;
    private File TempDir;

    public ComConnectionImpl(CoreComInterface core, DataBaseCoreInterface db, CryptoComInterface crypt, OFSServerSocket ss, OFSConnector con, File tmpdir) {
        this.TempDir = tmpdir;
        this.DB = db;
        this.Server = ss;
        this.Connector = con;
        this.Core = core;
        this.Crypt = crypt;
        this.Run = true;
        this.Closed = false;
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void Close() {
        if (!this.Closed) {
            this.Closed = true;
            try {
                if (this.Server != null) {
                    Log.info("Closing socket!");
                    this.Server.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public ComPeerInterface getComPeerInterface(Peer peer) {
        if (!this.Closed) {
            ComPeerImpl c = new ComPeerImpl(this.Core, this.DB, this.Crypt, this.TempDir, peer, this.Connector);
            return c;
        }
        return null;
    }

    @Override
    public void run() {
        while (this.Run && !this.Closed) {
            try {
                OFSSocket s = this.Server.accept();
                if (s == null) continue;
                s.setSoTimeout(60000);
                new ComPeerImpl(this.Core, this.DB, this.Crypt, this.TempDir, null, s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

