/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.generic;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Listener4;
import com.db4o.foundation.ListenerRegistry;
import com.db4o.foundation.Procedure4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.FieldMarshaller;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.RawClassSpec;
import com.db4o.internal.marshall.RawFieldSpec;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.ReflectClassBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownClassesRepository {
    private static final Hashtable4 PRIMITIVES = new Hashtable4();
    private ObjectContainerBase _stream;
    private Transaction _trans;
    private ReflectClassBuilder _builder;
    private final ListenerRegistry<ReflectClass> _listeners = ListenerRegistry.newInstance();
    private final Hashtable4 _classByName = new Hashtable4();
    private final Hashtable4 _classByID = new Hashtable4();
    private Collection4 _pendingClasses = new Collection4();
    private final Collection4 _classes = new Collection4();

    private static void registerPrimitive(Class primitive) {
        PRIMITIVES.put(ReflectPlatform.fullyQualifiedName(Platform4.nullableTypeFor(primitive)), (Object)primitive);
    }

    public KnownClassesRepository(ReflectClassBuilder builder) {
        this._builder = builder;
    }

    public void setTransaction(Transaction trans) {
        if (trans != null) {
            this._trans = trans;
            this._stream = trans.container();
        }
    }

    public void register(ReflectClass clazz) {
        this.register(clazz.getName(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectClass forID(int id) {
        Object object = this._stream.lock();
        synchronized (object) {
            if (this._stream.handlers().isSystemHandler(id)) {
                return this._stream.handlers().classForID(id);
            }
            return this.ensureClassAvailability(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectClass forName(String className) {
        ReflectClass clazz = this.lookupByName(className);
        if (clazz != null) {
            return clazz;
        }
        if (this._stream == null) {
            return null;
        }
        Object object = this._stream.lock();
        synchronized (object) {
            if (this._stream.classCollection() == null) {
                return null;
            }
            int classID = this._stream.classMetadataIdForName(className);
            if (classID <= 0) {
                return null;
            }
            return this.initializeClass(classID, className);
        }
    }

    private ReflectClass initializeClass(int classID, String className) {
        ReflectClass newClazz = this.ensureClassInitialised(classID);
        this._classByName.put(className, (Object)newClazz);
        return newClazz;
    }

    private void readAll() {
        this.forEachClassId(new Procedure4<Integer>(){

            @Override
            public void apply(Integer id) {
                KnownClassesRepository.this.ensureClassAvailability(id);
            }
        });
        this.forEachClassId(new Procedure4<Integer>(){

            @Override
            public void apply(Integer id) {
                KnownClassesRepository.this.ensureClassRead(id);
            }
        });
    }

    private void forEachClassId(Procedure4<Integer> procedure) {
        Iterator4 ids = this._stream.classCollection().ids();
        while (ids.moveNext()) {
            procedure.apply((Integer)ids.current());
        }
    }

    private ReflectClass ensureClassAvailability(int id) {
        if (id == 0) {
            return null;
        }
        ReflectClass ret = (ReflectClass)this._classByID.get(id);
        if (ret != null) {
            return ret;
        }
        ClassMarshaller marshaller = this.marshallerFamily()._class;
        StatefulBuffer classreader = this._stream.readWriterByID(this._trans, id);
        RawClassSpec spec = marshaller.readSpec(this._trans, classreader);
        String className = spec.name();
        ret = this.lookupByName(className);
        if (ret != null) {
            this._classByID.put(id, (Object)ret);
            this._pendingClasses.add(new Integer(id));
            return ret;
        }
        ret = this._builder.createClass(className, this.ensureClassAvailability(spec.superClassID()), spec.numFields());
        this._classByID.put(id, (Object)ret);
        this._pendingClasses.add(new Integer(id));
        return ret;
    }

    private void ensureClassRead(int id) {
        ReflectClass clazz = this.lookupByID(id);
        ClassMarshaller classMarshaller = this.marshallerFamily()._class;
        StatefulBuffer classreader = this._stream.readWriterByID(this._trans, id);
        RawClassSpec classInfo = classMarshaller.readSpec(this._trans, classreader);
        String className = classInfo.name();
        if (this.lookupByName(className) != null) {
            return;
        }
        this.register(className, clazz);
        int numFields = classInfo.numFields();
        ReflectField[] fields = this._builder.fieldArray(numFields);
        FieldMarshaller fieldMarshaller = this.marshallerFamily()._field;
        for (int i = 0; i < numFields; ++i) {
            RawFieldSpec fieldInfo = fieldMarshaller.readSpec(this._stream, classreader);
            String fieldName = fieldInfo.name();
            ReflectClass fieldClass = this.reflectClassForFieldSpec(fieldInfo, this._stream.reflector());
            if (null == fieldClass && fieldInfo.isField() && !fieldInfo.isVirtual()) {
                throw new IllegalStateException("Could not read field type for '" + className + "." + fieldName + "'");
            }
            fields[i] = this._builder.createField(clazz, fieldName, fieldClass, fieldInfo.isVirtual(), fieldInfo.isPrimitive(), fieldInfo.isArray(), fieldInfo.isNArray());
        }
        this._builder.initFields(clazz, fields);
    }

    private void register(String className, ReflectClass clazz) {
        if (this.lookupByName(className) != null) {
            throw new IllegalArgumentException();
        }
        this._classByName.put(className, (Object)clazz);
        this._classes.add(clazz);
        this._listeners.notifyListeners(clazz);
    }

    private ReflectClass reflectClassForFieldSpec(RawFieldSpec fieldInfo, Reflector reflector) {
        if (fieldInfo.isVirtualField()) {
            return this.virtualFieldByName(fieldInfo.name()).classReflector(reflector);
        }
        int fieldTypeID = fieldInfo.fieldTypeID();
        switch (fieldTypeID) {
            case 11: {
                return this.objectClass();
            }
            case 12: {
                return this.arrayClass(this.objectClass());
            }
        }
        ReflectClass fieldClass = this.forID(fieldTypeID);
        if (null != fieldClass) {
            return this.normalizeFieldClass(fieldInfo, fieldClass);
        }
        return null;
    }

    private ReflectClass normalizeFieldClass(RawFieldSpec fieldInfo, ReflectClass fieldClass) {
        ReflectClass theClass = this._stream.reflector().forName(fieldClass.getName());
        if (fieldInfo.isPrimitive()) {
            theClass = this.primitiveClass(theClass);
        }
        if (fieldInfo.isArray()) {
            theClass = this.arrayClass(theClass);
        }
        return theClass;
    }

    private ReflectClass objectClass() {
        return this._stream.reflector().forClass(Object.class);
    }

    private VirtualFieldMetadata virtualFieldByName(String fieldName) {
        return this._stream.handlers().virtualFieldByName(fieldName);
    }

    private MarshallerFamily marshallerFamily() {
        return MarshallerFamily.forConverterVersion(this._stream.converterVersion());
    }

    private ReflectClass ensureClassInitialised(int id) {
        ReflectClass ret = this.ensureClassAvailability(id);
        while (this._pendingClasses.size() > 0) {
            Collection4 pending = this._pendingClasses;
            this._pendingClasses = new Collection4();
            Iterator4 i = pending.iterator();
            while (i.moveNext()) {
                this.ensureClassRead((Integer)i.current());
            }
        }
        return ret;
    }

    public Iterator4 classes() {
        this.readAll();
        return this._classes.iterator();
    }

    public void register(int id, ReflectClass clazz) {
        this._classByID.put(id, (Object)clazz);
    }

    public ReflectClass lookupByID(int id) {
        return (ReflectClass)this._classByID.get(id);
    }

    public ReflectClass lookupByName(String name) {
        return (ReflectClass)this._classByName.get(name);
    }

    private ReflectClass arrayClass(ReflectClass clazz) {
        Object proto = clazz.reflector().array().newInstance(clazz, 0);
        return clazz.reflector().forObject(proto);
    }

    private ReflectClass primitiveClass(ReflectClass baseClass) {
        Class primitive = (Class)PRIMITIVES.get(baseClass.getName());
        if (primitive != null) {
            return baseClass.reflector().forClass(primitive);
        }
        return baseClass;
    }

    public void addListener(Listener4<ReflectClass> listener) {
        this._listeners.register(listener);
    }

    public void removeListener(Listener4<ReflectClass> listener) {
        this._listeners.remove(listener);
    }

    static {
        for (Class primitive : Platform4.primitiveTypes()) {
            KnownClassesRepository.registerPrimitive(primitive);
        }
    }
}

