/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.PagingMemoryBin;
import com.db4o.io.ReadOnlyBin;
import com.db4o.io.Storage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PagingMemoryStorage
implements Storage {
    private static final int DEFAULT_PAGESIZE = 4096;
    private final Map<String, Bin> _binsByUri = new HashMap<String, Bin>();
    private final int _pageSize;

    public PagingMemoryStorage() {
        this(4096);
    }

    public PagingMemoryStorage(int pageSize) {
        this._pageSize = pageSize;
    }

    public boolean exists(String uri) {
        return this._binsByUri.containsKey(uri);
    }

    public Bin open(BinConfiguration config) throws Db4oIOException {
        Bin bin = this.produceBin(config);
        return config.readOnly() ? new ReadOnlyBin(bin) : bin;
    }

    public Bin bin(String uri) {
        return this._binsByUri.get(uri);
    }

    public void bin(String uri, Bin bin) {
        this._binsByUri.put(uri, bin);
    }

    private Bin produceBin(BinConfiguration config) {
        Bin storage = this.bin(config.uri());
        if (null != storage) {
            return storage;
        }
        PagingMemoryBin newStorage = new PagingMemoryBin(this._pageSize, config.initialLength());
        this._binsByUri.put(config.uri(), newStorage);
        return newStorage;
    }

    public void delete(String uri) throws IOException {
        this._binsByUri.remove(uri);
    }

    public void rename(String oldUri, String newUri) throws IOException {
        Bin bin = this._binsByUri.remove(oldUri);
        if (bin == null) {
            throw new IOException("Bin not found: " + oldUri);
        }
        this._binsByUri.put(newUri, bin);
    }
}

