/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.threading;

import com.db4o.events.Event4;
import com.db4o.internal.events.Event4Impl;
import com.db4o.internal.threading.ThreadPool4;
import com.db4o.internal.threading.UncaughtExceptionEventArgs;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPool4Impl
implements ThreadPool4 {
    private final Event4Impl<UncaughtExceptionEventArgs> _uncaughtException = Event4Impl.newInstance();
    private final List<Thread> _activeThreads = new ArrayList<Thread>();

    @Override
    public void join(int timeoutMilliseconds) throws InterruptedException {
        for (Thread thread : this.activeThreads()) {
            thread.join(timeoutMilliseconds);
        }
    }

    @Override
    public void startLowPriority(Runnable task) {
        Thread thread = this.threadFor(task);
        this.setLowPriorityOn(thread);
        this.activateThread(thread);
    }

    private void setLowPriorityOn(Thread thread) {
        thread.setPriority(1);
    }

    @Override
    public void start(Runnable task) {
        Thread thread = this.threadFor(task);
        this.activateThread(thread);
    }

    @Override
    public void start(String taskName, Runnable task) {
        Thread thread = this.threadFor(task);
        thread.setName(taskName);
        this.activateThread(thread);
    }

    private Thread threadFor(final Runnable task) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    ThreadPool4Impl.this.triggerUncaughtExceptionEvent(e);
                }
                finally {
                    ThreadPool4Impl.this.dispose(Thread.currentThread());
                }
            }
        });
        thread.setDaemon(true);
        return thread;
    }

    private void activateThread(Thread thread) {
        this.addActiveThread(thread);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread[] activeThreads() {
        List<Thread> list = this._activeThreads;
        synchronized (list) {
            return this._activeThreads.toArray(new Thread[this._activeThreads.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addActiveThread(Thread thread) {
        List<Thread> list = this._activeThreads;
        synchronized (list) {
            this._activeThreads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose(Thread thread) {
        List<Thread> list = this._activeThreads;
        synchronized (list) {
            this._activeThreads.remove(thread);
        }
    }

    protected void triggerUncaughtExceptionEvent(Throwable e) {
        this._uncaughtException.trigger(new UncaughtExceptionEventArgs(e));
    }

    @Override
    public Event4<UncaughtExceptionEventArgs> uncaughtException() {
        return this._uncaughtException;
    }
}

