/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.result;

import com.db4o.ext.Db4oRecoverableException;
import com.db4o.foundation.Algorithms4;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.IntArrayList;
import com.db4o.foundation.IntComparator;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Sortable4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;

public class IdListQueryResult
extends AbstractQueryResult
implements Visitor4 {
    private Tree _candidates;
    private boolean _checkDuplicates;
    public IntArrayList _ids;

    public IdListQueryResult(Transaction trans, int initialSize) {
        super(trans);
        this._ids = new IntArrayList(initialSize);
    }

    public IdListQueryResult(Transaction trans) {
        this(trans, 0);
    }

    public IntIterator4 iterateIDs() {
        return this._ids.intIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        Object object = this.lock();
        synchronized (object) {
            return this.activatedObject(this.getId(index));
        }
    }

    public int getId(int index) {
        if (index < 0 || index >= this.size()) {
            throw new Db4oRecoverableException(new IndexOutOfBoundsException());
        }
        return this._ids.get(index);
    }

    public final void checkDuplicates() {
        this._checkDuplicates = true;
    }

    public void visit(Object a_tree) {
        QCandidate candidate = (QCandidate)a_tree;
        if (candidate.include()) {
            this.addKeyCheckDuplicates(candidate._key);
        }
    }

    public void addKeyCheckDuplicates(int a_key) {
        if (this._checkDuplicates) {
            TreeInt newNode = new TreeInt(a_key);
            this._candidates = Tree.add(this._candidates, newNode);
            if (newNode._size == 0) {
                return;
            }
        }
        this.add(a_key);
    }

    public void sort(final QueryComparator cmp) {
        Algorithms4.sort(new Sortable4(){

            public void swap(int leftIndex, int rightIndex) {
                IdListQueryResult.this._ids.swap(leftIndex, rightIndex);
            }

            public int size() {
                return IdListQueryResult.this.size();
            }

            public int compare(int leftIndex, int rightIndex) {
                return cmp.compare(IdListQueryResult.this.get(leftIndex), IdListQueryResult.this.get(rightIndex));
            }
        });
    }

    public void sortIds(final IntComparator cmp) {
        Algorithms4.sort(new Sortable4(){

            public void swap(int leftIndex, int rightIndex) {
                IdListQueryResult.this._ids.swap(leftIndex, rightIndex);
            }

            public int size() {
                return IdListQueryResult.this.size();
            }

            public int compare(int leftIndex, int rightIndex) {
                return cmp.compare(IdListQueryResult.this._ids.get(leftIndex), IdListQueryResult.this._ids.get(rightIndex));
            }
        });
    }

    public void loadFromClassIndex(ClassMetadata clazz) {
        ClassIndexStrategy index = clazz.index();
        if (index instanceof BTreeClassIndexStrategy) {
            BTree btree = ((BTreeClassIndexStrategy)index).btree();
            this._ids = new IntArrayList(btree.size(this.transaction()));
        }
        index.traverseAll(this._transaction, new Visitor4(){

            public void visit(Object a_object) {
                IdListQueryResult.this.add((Integer)a_object);
            }
        });
    }

    public void loadFromQuery(QQuery query) {
        query.executeLocal(this);
    }

    public void loadFromClassIndexes(ClassMetadataIterator iter) {
        final ByRef duplicates = new ByRef();
        while (iter.moveNext()) {
            ReflectClass claxx;
            ClassMetadata classMetadata = iter.currentClass();
            if (classMetadata.getName() == null || (claxx = classMetadata.classReflector()) != null && this.stream()._handlers.ICLASS_INTERNAL.isAssignableFrom(claxx)) continue;
            ClassIndexStrategy index = classMetadata.index();
            index.traverseAll(this._transaction, new Visitor4(){

                public void visit(Object obj) {
                    int id = (Integer)obj;
                    TreeInt newNode = new TreeInt(id);
                    duplicates.value = Tree.add((Tree)duplicates.value, newNode);
                    if (newNode.size() != 0) {
                        IdListQueryResult.this.add(id);
                    }
                }
            });
        }
    }

    public void loadFromIdReader(Iterator4 ids) {
        while (ids.moveNext()) {
            this.add((Integer)ids.current());
        }
    }

    public void add(int id) {
        this._ids.add(id);
    }

    public int indexOf(int id) {
        return this._ids.indexOf(id);
    }

    public int size() {
        return this._ids.size();
    }
}

