/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectID;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.ReadsObjectIds;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.marshall.IdObjectCollector;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderContext;
import com.db4o.marshall.ReadBuffer;

public class CollectIdContext
extends ObjectHeaderContext {
    private final IdObjectCollector _collector;

    public CollectIdContext(Transaction transaction, IdObjectCollector collector, ObjectHeader oh, ReadBuffer buffer) {
        super(transaction, buffer, oh);
        this._collector = collector;
    }

    public CollectIdContext(Transaction transaction, ObjectHeader oh, ReadBuffer buffer) {
        this(transaction, new IdObjectCollector(), oh, buffer);
    }

    public static CollectIdContext forID(Transaction transaction, int id) {
        return CollectIdContext.forID(transaction, new IdObjectCollector(), id);
    }

    public static CollectIdContext forID(Transaction transaction, IdObjectCollector collector, int id) {
        StatefulBuffer reader = transaction.container().readWriterByID(transaction, id);
        if (reader == null) {
            return null;
        }
        ObjectHeader oh = new ObjectHeader(transaction.container(), (ReadWriteBuffer)reader);
        return new CollectIdContext(transaction, collector, oh, reader);
    }

    public void addId() {
        int id = this.readInt();
        if (id <= 0) {
            return;
        }
        this.addId(id);
    }

    private void addId(int id) {
        this._collector.addId(id);
    }

    public ClassMetadata classMetadata() {
        return this._objectHeader.classMetadata();
    }

    public TreeInt ids() {
        return this._collector.ids();
    }

    public void readID(ReadsObjectIds objectIDHandler) {
        ObjectID objectID = objectIDHandler.readObjectID(this);
        if (objectID.isValid()) {
            this.addId(objectID._id);
        }
    }

    public IdObjectCollector collector() {
        return this._collector;
    }
}

