/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.foundation.io.File4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.ids.TransactionLogHandler;
import com.db4o.internal.slots.Slot;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.FileStorage;

public class FileBasedTransactionLogHandler
extends TransactionLogHandler {
    static final int LOCK_INT = 0x7FFFFFFE;
    private Bin _lockFile;
    private Bin _logFile;
    private final String _fileName;

    public FileBasedTransactionLogHandler(IdSystem idSystem, String fileName) {
        this._fileName = fileName;
    }

    public static String logFileName(String fileName) {
        return fileName + ".log";
    }

    public static String lockFileName(String fileName) {
        return fileName + ".lock";
    }

    private Bin openBin(IdSystem idSystem, String fileName) {
        return new FileStorage().open(new BinConfiguration(fileName, idSystem.config().lockFile(), 0L, false));
    }

    public boolean checkForInterruptedTransaction(IdSystem idSystem, ByteArrayBuffer reader) {
        reader.incrementOffset(8);
        if (!File4.exists(FileBasedTransactionLogHandler.lockFileName(this._fileName))) {
            return false;
        }
        return this.lockFileSignalsInterruptedTransaction(idSystem);
    }

    private boolean lockFileSignalsInterruptedTransaction(IdSystem idSystem) {
        this.openLockFile(idSystem);
        ByteArrayBuffer buffer = this.newLockFileBuffer();
        this.read(this._lockFile, buffer);
        for (int i = 0; i < 2; ++i) {
            int checkInt = buffer.readInt();
            if (checkInt == 0x7FFFFFFE) continue;
            this.closeLockFile();
            return false;
        }
        this.closeLockFile();
        return true;
    }

    public void close() {
        if (!this.logsOpened()) {
            return;
        }
        this.closeLockFile();
        this.closeLogFile();
        this.deleteLockFile();
        this.deleteLogFile();
    }

    private void closeLockFile() {
        this.syncAndClose(this._lockFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAndClose(Bin bin) {
        try {
            bin.sync();
        }
        finally {
            bin.close();
        }
    }

    private void closeLogFile() {
        this.syncAndClose(this._logFile);
    }

    private void deleteLockFile() {
        File4.delete(FileBasedTransactionLogHandler.lockFileName(this._fileName));
    }

    private void deleteLogFile() {
        File4.delete(FileBasedTransactionLogHandler.logFileName(this._fileName));
    }

    public Slot allocateSlot(IdSystem idSystem, boolean append) {
        return null;
    }

    public void applySlotChanges(IdSystem idSystem, Slot reservedSlot) {
        int slotChangeCount = this.countSlotChanges(idSystem);
        if (slotChangeCount < 1) {
            return;
        }
        this.flushDatabaseFile(idSystem);
        this.ensureLogAndLock(idSystem);
        int length = this.transactionLogSlotLength(idSystem);
        ByteArrayBuffer logBuffer = new ByteArrayBuffer(length);
        logBuffer.writeInt(length);
        logBuffer.writeInt(slotChangeCount);
        this.appendSlotChanges(idSystem, logBuffer);
        this.write(this._logFile, logBuffer);
        this._logFile.sync();
        this.writeToLockFile(0x7FFFFFFE);
        if (idSystem.writeSlots()) {
            this.flushDatabaseFile(idSystem);
        }
        this.writeToLockFile(0);
    }

    private void writeToLockFile(int lockSignal) {
        ByteArrayBuffer lockBuffer = this.newLockFileBuffer();
        lockBuffer.writeInt(lockSignal);
        lockBuffer.writeInt(lockSignal);
        this.write(this._lockFile, lockBuffer);
        this._lockFile.sync();
    }

    private ByteArrayBuffer newLockFileBuffer() {
        return new ByteArrayBuffer(this.lockFileBufferLength());
    }

    private int lockFileBufferLength() {
        return 16;
    }

    private void ensureLogAndLock(IdSystem idSystem) {
        if (idSystem.config().isReadOnly()) {
            return;
        }
        if (this.logsOpened()) {
            return;
        }
        this.openLockFile(idSystem);
        this.openLogFile(idSystem);
    }

    private void openLogFile(IdSystem idSystem) {
        this._logFile = this.openBin(idSystem, FileBasedTransactionLogHandler.logFileName(this._fileName));
    }

    private void openLockFile(IdSystem idSystem) {
        this._lockFile = this.openBin(idSystem, FileBasedTransactionLogHandler.lockFileName(this._fileName));
    }

    private boolean logsOpened() {
        return this._lockFile != null;
    }

    public void completeInterruptedTransaction(IdSystem idSystem) {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        this.openLogFile(idSystem);
        this.read(this._logFile, buffer);
        int length = buffer.readInt();
        if (length > 0) {
            buffer = new ByteArrayBuffer(length);
            this.read(this._logFile, buffer);
            buffer.incrementOffset(4);
            idSystem.readSlotChanges(buffer);
            if (idSystem.writeSlots()) {
                this.flushDatabaseFile(idSystem);
            }
            this.deleteLockFile();
            idSystem.freeSlotChanges(false);
        } else {
            this.deleteLockFile();
        }
        this.closeLogFile();
        this.deleteLogFile();
    }

    private void read(Bin storage, ByteArrayBuffer buffer) {
        storage.read(0L, buffer._buffer, buffer.length());
    }

    private void write(Bin storage, ByteArrayBuffer buffer) {
        storage.write(0L, buffer._buffer, buffer.length());
    }
}

