/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.DTrace;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.TreeReader;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.FreeSlotNode;
import com.db4o.internal.freespace.FreespaceListener;
import com.db4o.internal.freespace.NullFreespaceListener;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public class RamFreespaceManager
extends AbstractFreespaceManager {
    private final TreeIntObject _finder = new TreeIntObject(0);
    private Tree _freeByAddress;
    private Tree _freeBySize;
    private FreespaceListener _listener = NullFreespaceListener.INSTANCE;

    public RamFreespaceManager(LocalObjectContainer file) {
        super(file);
    }

    private void addFreeSlotNodes(int address, int length) {
        FreeSlotNode addressNode = new FreeSlotNode(address);
        addressNode.createPeer(length);
        this._freeByAddress = Tree.add(this._freeByAddress, addressNode);
        this.addToFreeBySize(addressNode._peer);
    }

    private void addToFreeBySize(FreeSlotNode node) {
        this._freeBySize = Tree.add(this._freeBySize, node);
        this._listener.slotAdded(node._key);
    }

    public Slot allocateTransactionLogSlot(int length) {
        FreeSlotNode sizeNode = (FreeSlotNode)Tree.last(this._freeBySize);
        if (sizeNode == null || sizeNode._key < length) {
            return null;
        }
        int limit = length + 100;
        if (sizeNode._key > limit) {
            return this.getSlot(limit);
        }
        this.removeFromBothTrees(sizeNode);
        return new Slot(sizeNode._peer._key, sizeNode._key);
    }

    public void freeTransactionLogSlot(Slot slot) {
        this.free(slot);
    }

    public void beginCommit() {
    }

    public void commit() {
    }

    public void endCommit() {
    }

    public void free(Slot slot) {
        int address = slot.address();
        if (address <= 0) {
            throw new IllegalArgumentException();
        }
        int length = slot.length();
        if (DTrace.enabled) {
            DTrace.FREESPACEMANAGER_RAM_FREE.logLength(address, length);
        }
        this._finder._key = address;
        FreeSlotNode addressnode = (FreeSlotNode)Tree.findSmaller(this._freeByAddress, this._finder);
        if (addressnode != null && addressnode._key + addressnode._peer._key == address) {
            FreeSlotNode sizeNode = addressnode._peer;
            this.removeFromFreeBySize(sizeNode);
            sizeNode._key += length;
            FreeSlotNode secondAddressNode = (FreeSlotNode)Tree.findGreaterOrEqual(this._freeByAddress, this._finder);
            if (secondAddressNode != null && address + length == secondAddressNode._key) {
                sizeNode._key += secondAddressNode._peer._key;
                this.removeFromBothTrees(secondAddressNode._peer);
            }
            sizeNode.removeChildren();
            this.addToFreeBySize(sizeNode);
        } else {
            addressnode = (FreeSlotNode)Tree.findGreaterOrEqual(this._freeByAddress, this._finder);
            if (addressnode != null && address + length == addressnode._key) {
                FreeSlotNode sizeNode = addressnode._peer;
                this.removeFromBothTrees(sizeNode);
                sizeNode._key += length;
                addressnode._key = address;
                addressnode.removeChildren();
                sizeNode.removeChildren();
                this._freeByAddress = Tree.add(this._freeByAddress, addressnode);
                this.addToFreeBySize(sizeNode);
            } else {
                if (this.canDiscard(length)) {
                    return;
                }
                this.addFreeSlotNodes(address, length);
            }
        }
        this._file.overwriteDeletedBlockedSlot(slot);
    }

    public void freeSelf() {
    }

    private void freeReader(StatefulBuffer reader) {
        this._file.free(reader.getAddress(), reader.length());
    }

    public Slot getSlot(int length) {
        this._finder._key = length;
        this._finder._object = null;
        this._freeBySize = FreeSlotNode.removeGreaterOrEqual((FreeSlotNode)this._freeBySize, this._finder);
        if (this._finder._object == null) {
            return null;
        }
        FreeSlotNode node = (FreeSlotNode)this._finder._object;
        this._listener.slotRemoved(node._key);
        int blocksFound = node._key;
        int address = node._peer._key;
        this._freeByAddress = this._freeByAddress.removeNode(node._peer);
        int remainingBlocks = blocksFound - length;
        if (this.canDiscard(remainingBlocks)) {
            length = blocksFound;
        } else {
            this.addFreeSlotNodes(address + length, remainingBlocks);
        }
        if (DTrace.enabled) {
            DTrace.FREESPACEMANAGER_GET_SLOT.logLength(address, length);
        }
        return new Slot(address, length);
    }

    int marshalledLength() {
        return TreeInt.marshalledLength((TreeInt)this._freeBySize);
    }

    public void read(int freeSlotsID) {
        this.readById(freeSlotsID);
    }

    private void read(StatefulBuffer reader) {
        FreeSlotNode.sizeLimit = this.blockedDiscardLimit();
        this._freeBySize = new TreeReader(reader, new FreeSlotNode(0), true).read();
        final ByRef addressTree = ByRef.newInstance();
        if (this._freeBySize != null) {
            this._freeBySize.traverse(new Visitor4(){

                public void visit(Object a_object) {
                    FreeSlotNode node = ((FreeSlotNode)a_object)._peer;
                    addressTree.value = Tree.add((Tree)addressTree.value, node);
                }
            });
        }
        this._freeByAddress = (Tree)addressTree.value;
    }

    void read(Slot slot) {
        if (slot.isNull()) {
            return;
        }
        StatefulBuffer reader = this._file.readWriterByAddress(this.transaction(), slot.address(), slot.length());
        if (reader == null) {
            return;
        }
        this.read(reader);
        this.freeReader(reader);
    }

    private void readById(int freeSlotsID) {
        if (freeSlotsID <= 0) {
            return;
        }
        if (this.discardLimit() == Integer.MAX_VALUE) {
            return;
        }
        StatefulBuffer reader = this._file.readWriterByID(this.transaction(), freeSlotsID);
        if (reader == null) {
            return;
        }
        this.read(reader);
        this._file.free(freeSlotsID, 8);
        this.freeReader(reader);
    }

    private void removeFromBothTrees(FreeSlotNode sizeNode) {
        this.removeFromFreeBySize(sizeNode);
        this._freeByAddress = this._freeByAddress.removeNode(sizeNode._peer);
    }

    private void removeFromFreeBySize(FreeSlotNode node) {
        this._freeBySize = this._freeBySize.removeNode(node);
        this._listener.slotRemoved(node._key);
    }

    public int slotCount() {
        return Tree.size(this._freeByAddress);
    }

    public void start(int slotAddress) {
    }

    public byte systemType() {
        return 2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RAM FreespaceManager\n");
        sb.append("Address Index\n");
        this._freeByAddress.traverse(new ToStringVisitor(sb));
        sb.append("Length Index\n");
        this._freeBySize.traverse(new ToStringVisitor(sb));
        return sb.toString();
    }

    public void traverse(final Visitor4 visitor) {
        if (this._freeByAddress == null) {
            return;
        }
        this._freeByAddress.traverse(new Visitor4(){

            public void visit(Object a_object) {
                FreeSlotNode fsn = (FreeSlotNode)a_object;
                int address = fsn._key;
                int length = fsn._peer._key;
                visitor.visit(new Slot(address, length));
            }
        });
    }

    public int write() {
        Pointer4 pointer = this._file.newSlot(this.marshalledLength());
        this.write(pointer);
        return pointer._id;
    }

    void write(Pointer4 pointer) {
        StatefulBuffer buffer = new StatefulBuffer((Transaction)this.transaction(), pointer);
        TreeInt.write(buffer, (TreeInt)this._freeBySize);
        buffer.writeEncrypt();
        this.transaction().flushFile();
        this.transaction().writePointer(pointer);
    }

    public void listener(FreespaceListener listener) {
        this._listener = listener;
    }

    static final class ToStringVisitor
    implements Visitor4 {
        private final StringBuffer _sb;

        ToStringVisitor(StringBuffer sb) {
            this._sb = sb;
        }

        public void visit(Object obj) {
            this._sb.append(obj);
            this._sb.append("\n");
        }
    }
}

