/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.collections;

import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.defragment.IDMappingCollector;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.IDHandler;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.collections.BigSetPersistence;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReferenceActivationContext;
import com.db4o.marshall.WriteContext;
import com.db4o.typehandlers.ActivationContext;
import com.db4o.typehandlers.CascadingTypeHandler;
import com.db4o.typehandlers.ReferenceTypeHandler;
import com.db4o.typehandlers.TypeHandler4;

public class BigSetTypeHandler
implements ReferenceTypeHandler,
CascadingTypeHandler {
    public void defragment(DefragmentContext context) {
        int pos = context.offset();
        int id = context.readInt();
        BTree bTree = this.newBTree(context, id);
        DefragmentServicesImpl services = (DefragmentServicesImpl)context.services();
        IDMappingCollector collector = new IDMappingCollector();
        services.registerBTreeIDs(bTree, collector);
        collector.flush(services);
        context.seek(pos);
        context.copyID();
        bTree.defragBTree(services);
    }

    public void delete(DeleteContext context) throws Db4oIOException {
        this.invalidBigSet(context);
        int id = context.readInt();
        this.freeBTree(context, id);
    }

    private void invalidBigSet(DeleteContext context) {
        BigSetPersistence bigSet = (BigSetPersistence)context.transaction().objectForIdFromCache(context.id());
        if (bigSet != null) {
            bigSet.invalidate();
        }
    }

    private void freeBTree(DeleteContext context, int id) {
        BTree bTree = this.newBTree(context, id);
        bTree.free(BigSetTypeHandler.systemTransaction(context));
        bTree = null;
    }

    private static Transaction systemTransaction(Context context) {
        return context.transaction().systemTransaction();
    }

    private BTree newBTree(Context context, int id) {
        return new BTree(BigSetTypeHandler.systemTransaction(context), id, new IDHandler());
    }

    public void write(WriteContext context, Object obj) {
        BigSetPersistence bigSet = (BigSetPersistence)obj;
        bigSet.write(context);
    }

    public PreparedComparison prepareComparison(Context context, Object obj) {
        return null;
    }

    public void activate(ReferenceActivationContext context) {
        BigSetPersistence bigSet = (BigSetPersistence)context.persistentObject();
        bigSet.read(context);
    }

    public void cascadeActivation(ActivationContext context) {
    }

    public void collectIDs(QueryingReadContext context) {
    }

    public TypeHandler4 readCandidateHandler(QueryingReadContext context) {
        return null;
    }
}

