/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNode;

public class BTreePointer {
    private final BTreeNode _node;
    private final int _index;
    private final Transaction _transaction;
    private final ByteArrayBuffer _nodeReader;

    public static BTreePointer max(BTreePointer x, BTreePointer y) {
        if (x == null) {
            return x;
        }
        if (y == null) {
            return y;
        }
        if (x.compareTo(y) > 0) {
            return x;
        }
        return y;
    }

    public static BTreePointer min(BTreePointer x, BTreePointer y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x.compareTo(y) < 0) {
            return x;
        }
        return y;
    }

    public BTreePointer(Transaction transaction, ByteArrayBuffer nodeReader, BTreeNode node, int index) {
        if (transaction == null || node == null) {
            throw new ArgumentNullException();
        }
        this._transaction = transaction;
        this._nodeReader = nodeReader;
        this._node = node;
        this._index = index;
    }

    public final Transaction transaction() {
        return this._transaction;
    }

    public final int index() {
        return this._index;
    }

    public final BTreeNode node() {
        return this._node;
    }

    public final Object key() {
        return this.node().key(this.transaction(), this.nodeReader(), this.index());
    }

    private ByteArrayBuffer nodeReader() {
        return this._nodeReader;
    }

    public BTreePointer next() {
        for (int indexInMyNode = this.index() + 1; indexInMyNode < this.node().count(); ++indexInMyNode) {
            if (!this.node().indexIsValid(this.transaction(), indexInMyNode)) continue;
            return new BTreePointer(this.transaction(), this.nodeReader(), this.node(), indexInMyNode);
        }
        int newIndex = -1;
        BTreeNode nextNode = this.node();
        ByteArrayBuffer nextReader = null;
        while (newIndex == -1) {
            if ((nextNode = nextNode.nextNode()) == null) {
                return null;
            }
            nextReader = nextNode.prepareRead(this.transaction());
            newIndex = nextNode.firstKeyIndex(this.transaction());
        }
        return new BTreePointer(this.transaction(), nextReader, nextNode, newIndex);
    }

    public BTreePointer previous() {
        for (int indexInMyNode = this.index() - 1; indexInMyNode >= 0; --indexInMyNode) {
            if (!this.node().indexIsValid(this.transaction(), indexInMyNode)) continue;
            return new BTreePointer(this.transaction(), this.nodeReader(), this.node(), indexInMyNode);
        }
        int newIndex = -1;
        BTreeNode previousNode = this.node();
        ByteArrayBuffer previousReader = null;
        while (newIndex == -1) {
            if ((previousNode = previousNode.previousNode()) == null) {
                return null;
            }
            previousReader = previousNode.prepareRead(this.transaction());
            newIndex = previousNode.lastKeyIndex(this.transaction());
        }
        return new BTreePointer(this.transaction(), previousReader, previousNode, newIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BTreePointer)) {
            return false;
        }
        BTreePointer other = (BTreePointer)obj;
        if (this.index() != other.index()) {
            return false;
        }
        return this.node().equals(other.node());
    }

    public int hashCode() {
        return this.node().hashCode();
    }

    public String toString() {
        return "BTreePointer(index=" + this.index() + ", node=" + this.node() + ")";
    }

    public int compareTo(BTreePointer y) {
        if (null == y) {
            throw new ArgumentNullException();
        }
        if (this.btree() != y.btree()) {
            throw new IllegalArgumentException();
        }
        return this.btree().compareKeys(this.transaction().context(), this.key(), y.key());
    }

    private BTree btree() {
        return this.node().btree();
    }

    public static boolean lessThan(BTreePointer x, BTreePointer y) {
        return BTreePointer.min(x, y) == x && !BTreePointer.equals(x, y);
    }

    public static boolean equals(BTreePointer x, BTreePointer y) {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public boolean isValid() {
        return this.node().indexIsValid(this.transaction(), this.index());
    }
}

