/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.config.ObjectAttribute;
import com.db4o.config.ObjectClass;
import com.db4o.config.TClass;
import com.db4o.config.THashtable;
import com.db4o.config.TNull;
import com.db4o.config.TVector;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.JDK;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.Reflection4;
import com.db4o.internal.ShutDownRunnable;
import com.db4o.internal.Transaction;
import com.db4o.internal.handlers.NetTypeHandler;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.query.processor.QConEvaluation;
import com.db4o.query.Candidate;
import com.db4o.query.Evaluation;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericReflector;
import java.net.Socket;
import java.util.Date;

public final class Platform4 {
    private static final String JDK_PACKAGE = "com.db4o.internal.";
    private static TernaryBool collectionCheck = TernaryBool.UNSPECIFIED;
    private static JDK jdkWrapper;
    private static TernaryBool nioCheck;
    private static TernaryBool setAccessibleCheck;
    private static TernaryBool shutDownHookCheck;
    static TernaryBool callConstructorCheck;
    static ShutDownRunnable shutDownRunnable;
    static Thread shutDownThread;
    static final String ACCESSIBLEOBJECT = "java.lang.reflect.AccessibleObject";
    static final String GETCONSTRUCTOR = "newConstructorForSerialization";
    static final String REFERENCEQUEUE = "java.lang.ref.ReferenceQueue";
    static final String REFLECTIONFACTORY = "sun.reflect.ReflectionFactory";
    static final String RUNFINALIZERSONEXIT = "runFinalizersOnExit";
    static final String UTIL = "java.util.";
    static final String DB4O_PACKAGE = "com.db4o.";
    static final String DB4O_CONFIG = "com.db4o.config.";
    static final String DB4O_ASSEMBLY = ", db4o";
    private static TernaryBool weakReferenceCheck;
    private static final Class[] SIMPLE_CLASSES;
    private static Hashtable4 _primitive2Wrapper;
    private static Hashtable4 _nullValues;

    static final synchronized void addShutDownHook(ObjectContainerBase container) {
        if (!Platform4.hasShutDownHook()) {
            return;
        }
        if (shutDownThread == null) {
            shutDownRunnable = new ShutDownRunnable();
            shutDownThread = Platform4.jdk().addShutdownHook(shutDownRunnable);
        }
        shutDownRunnable.ensure(container);
    }

    public static final boolean canSetAccessible() {
        if (setAccessibleCheck.isUnspecified()) {
            if (Platform4.jdk().ver() >= 2) {
                setAccessibleCheck = TernaryBool.YES;
            } else {
                setAccessibleCheck = TernaryBool.NO;
                if (((Config4Impl)Db4o.configure()).messageLevel() >= 0) {
                    Messages.logErr(Db4o.configure(), 47, null, null);
                }
            }
        }
        return setAccessibleCheck.definiteYes();
    }

    static final boolean classIsAvailable(String className) {
        return ReflectPlatform.forName(className) != null;
    }

    static final Reflector createReflector(Object classLoader) {
        return Platform4.jdk().createReflector(classLoader);
    }

    public static final Object createReferenceQueue() {
        return Platform4.jdk().createReferenceQueue();
    }

    public static Object createWeakReference(Object obj) {
        return Platform4.jdk().createWeakReference(obj);
    }

    public static final Object createActiveObjectReference(Object referenceQueue, Object objectReference, Object obj) {
        return Platform4.jdk().createActivateObjectReference(referenceQueue, (ObjectReference)objectReference, obj);
    }

    public static Object deserialize(byte[] bytes) {
        return Platform4.jdk().deserialize(bytes);
    }

    public static final long doubleToLong(double a_double) {
        return Double.doubleToLongBits(a_double);
    }

    public static final QConEvaluation evaluationCreate(Transaction a_trans, Object example) {
        if (example instanceof Evaluation) {
            return new QConEvaluation(a_trans, example);
        }
        return null;
    }

    public static final void evaluationEvaluate(Object a_evaluation, Candidate a_candidate) {
        ((Evaluation)a_evaluation).evaluate(a_candidate);
    }

    public static Object[] collectionToArray(ObjectContainerBase stream, Object obj) {
        Collection4 col = Platform4.flattenCollection(stream, obj);
        Object[] ret = new Object[col.size()];
        col.toArray(ret);
        return ret;
    }

    static final Collection4 flattenCollection(ObjectContainerBase stream, Object obj) {
        Collection4 col = new Collection4();
        Platform4.flattenCollection1(stream, obj, col);
        return col;
    }

    public static Config4Class extendConfiguration(ReflectClass clazz, Configuration config, Config4Class classConfig) {
        return Platform4.jdk().extendConfiguration(clazz, config, classConfig);
    }

    static final void flattenCollection1(ObjectContainerBase stream, Object obj, Collection4 col) {
        if (obj == null) {
            col.add(null);
        } else {
            ReflectClass claxx = stream.reflector().forObject(obj);
            if (claxx.isArray()) {
                Iterator4 objects = ArrayHandler.iterator(claxx, obj);
                while (objects.moveNext()) {
                    Platform4.flattenCollection1(stream, objects.current(), col);
                }
            } else {
                Platform4.flattenCollection2(stream, obj, col);
            }
        }
    }

    static final void flattenCollection2(final ObjectContainerBase container, Object obj, final Collection4 col) {
        if (container.reflector().forObject(obj).isCollection()) {
            Platform4.forEachCollectionElement(obj, new Visitor4(){

                public void visit(Object element) {
                    Platform4.flattenCollection1(container, element, col);
                }
            });
        } else {
            col.add(obj);
        }
    }

    public static final void forEachCollectionElement(Object obj, Visitor4 visitor) {
        Platform4.jdk().forEachCollectionElement(obj, visitor);
    }

    public static final String format(Date date, boolean showTime) {
        return Platform4.jdk().format(date, showTime);
    }

    public static final void getDefaultConfiguration(Config4Impl config) {
        Platform4.jdk();
        Platform4.hasWeakReferences();
        Platform4.hasNio();
        Platform4.hasCollections();
        Platform4.hasShutDownHook();
        if (config.reflector() == null) {
            config.reflectWith(Platform4.jdk().createReflector(null));
        }
        Platform4.configStringBufferCompare(config);
        Platform4.translate(config.objectClass("java.lang.Class"), "TClass");
        Platform4.translateCollection(config, "Hashtable", "THashtable", false);
        if (Platform4.jdk().ver() >= 2) {
            try {
                Platform4.translateCollection(config, "AbstractCollection", "TCollection", false);
                Platform4.translateUtilNull(config, "AbstractList");
                Platform4.translateUtilNull(config, "AbstractSequentialList");
                Platform4.translateUtilNull(config, "LinkedList");
                Platform4.translateUtilNull(config, "ArrayList");
                Platform4.translateUtilNull(config, "Vector");
                Platform4.translateUtilNull(config, "Stack");
                Platform4.translateUtilNull(config, "AbstractSet");
                Platform4.translateUtilNull(config, "HashSet");
                Platform4.translate(config, "java.util.TreeSet", "TTreeSet");
                Platform4.translateCollection(config, "AbstractMap", "TMap", false);
                Platform4.translateUtilNull(config, "HashMap");
                Platform4.translateUtilNull(config, "WeakHashMap");
                Platform4.translate(config, "java.util.TreeMap", "TTreeMap");
            }
            catch (Exception exception) {}
        } else {
            Platform4.translateCollection(config, "Vector", "TVector", false);
        }
        Platform4.netReadAsJava(config, "ext.Db4oDatabase");
        Platform4.netReadAsJava(config, "P1Object");
        Platform4.netReadAsJava(config, "StaticClass");
        Platform4.netReadAsJava(config, "StaticField");
        Platform4.jdk().commonConfigurations(config);
        Platform4.jdk().extendConfiguration(config);
    }

    private static void configStringBufferCompare(Config4Impl config) {
        config.objectClass("java.lang.StringBuffer").compare(new ObjectAttribute(){

            public Object attribute(Object original) {
                if (original instanceof StringBuffer) {
                    return ((StringBuffer)original).toString();
                }
                return original;
            }
        });
    }

    public static Object getTypeForClass(Object obj) {
        return obj;
    }

    static final Object getYapRefObject(Object a_object) {
        return Platform4.jdk().getYapRefObject(a_object);
    }

    static final synchronized boolean hasCollections() {
        if (collectionCheck.isUnspecified()) {
            if (Platform4.classIsAvailable("java.util.Collection")) {
                collectionCheck = TernaryBool.YES;
                return true;
            }
            collectionCheck = TernaryBool.NO;
        }
        return collectionCheck.definiteYes();
    }

    public static boolean needsLockFileThread() {
        return !Platform4.hasNio();
    }

    private static final boolean hasNio() {
        if (nioCheck.isUnspecified()) {
            if (Platform4.jdk().ver() >= 4 && !Platform4.noNIO()) {
                nioCheck = TernaryBool.YES;
                return true;
            }
            nioCheck = TernaryBool.NO;
        }
        return nioCheck.definiteYes();
    }

    static final boolean hasShutDownHook() {
        if (shutDownHookCheck.isUnspecified()) {
            if (Platform4.jdk().ver() >= 3) {
                shutDownHookCheck = TernaryBool.YES;
                return true;
            }
            Reflection4.invoke(System.class, RUNFINALIZERSONEXIT, new Class[]{Boolean.TYPE}, new Object[]{new Boolean(true)});
            shutDownHookCheck = TernaryBool.NO;
        }
        return shutDownHookCheck.definiteYes();
    }

    public static final boolean hasWeakReferences() {
        if (weakReferenceCheck.isUnspecified()) {
            if (Platform4.classIsAvailable(ACCESSIBLEOBJECT) && Platform4.classIsAvailable(REFERENCEQUEUE) && Platform4.jdk().ver() >= 2) {
                weakReferenceCheck = TernaryBool.YES;
                return true;
            }
            weakReferenceCheck = TernaryBool.NO;
        }
        return weakReferenceCheck.definiteYes();
    }

    static final boolean ignoreAsConstraint(Object obj) {
        return false;
    }

    static final boolean isCollectionTranslator(Config4Class a_config) {
        return Platform4.jdk().isCollectionTranslator(a_config);
    }

    public static boolean isConnected(Socket socket) {
        return Platform4.jdk().isConnected(socket);
    }

    public static final boolean isStruct(ReflectClass claxx) {
        return false;
    }

    public static JDK jdk() {
        if (jdkWrapper == null) {
            Platform4.createJdk();
        }
        return jdkWrapper;
    }

    private static void createJdk() {
        if (Platform4.classIsAvailable("java.lang.reflect.Method")) {
            jdkWrapper = (JDK)ReflectPlatform.createInstance("com.db4o.internal.JDKReflect");
        }
        if (Platform4.classIsAvailable(ACCESSIBLEOBJECT)) {
            jdkWrapper = Platform4.createJDKWrapper("1_2");
        }
        if (Platform4.jdk().methodIsAvailable("java.lang.Runtime", "addShutdownHook", new Class[]{Thread.class})) {
            jdkWrapper = Platform4.createJDKWrapper("1_3");
        }
        if (Platform4.classIsAvailable("java.nio.channels.FileLock")) {
            jdkWrapper = Platform4.createJDKWrapper("1_4");
        }
        if (Platform4.classIsAvailable("java.lang.Enum")) {
            jdkWrapper = Platform4.createJDKWrapper("5");
        }
    }

    private static JDK createJDKWrapper(String name) {
        JDK newWrapper = (JDK)ReflectPlatform.createInstance("com.db4o.internal.JDK_" + name);
        if (newWrapper != null) {
            return newWrapper;
        }
        return jdkWrapper;
    }

    public static boolean isSimple(Class a_class) {
        for (int i = 0; i < SIMPLE_CLASSES.length; ++i) {
            if (a_class != SIMPLE_CLASSES[i]) continue;
            return true;
        }
        return false;
    }

    static final void killYapRef(Object a_object) {
        Platform4.jdk().killYapRef(a_object);
    }

    public static void link() {
        new TClass();
        new TVector();
        new THashtable();
        new TNull();
    }

    public static final void lockFile(String path, Object file) {
        if (!Platform4.hasNio()) {
            return;
        }
        Platform4.jdk().lockFile(path, file);
    }

    public static final void unlockFile(String path, Object file) {
        if (Platform4.hasNio()) {
            Platform4.jdk().unlockFile(path, file);
        }
    }

    public static final double longToDouble(long a_long) {
        return Double.longBitsToDouble(a_long);
    }

    static void markTransient(String marker) {
    }

    public static boolean callConstructor() {
        if (callConstructorCheck.isUnspecified()) {
            if (Platform4.jdk().methodIsAvailable(REFLECTIONFACTORY, GETCONSTRUCTOR, new Class[]{Class.class, Platform4.jdk().constructorClass()})) {
                callConstructorCheck = TernaryBool.NO;
                return false;
            }
            callConstructorCheck = TernaryBool.YES;
        }
        return callConstructorCheck.definiteYes();
    }

    private static final void netReadAsJava(Config4Impl config, String className) {
        Config4Class classConfig = (Config4Class)config.objectClass(Platform4.db4oClass(className) + DB4O_ASSEMBLY);
        if (classConfig == null) {
            return;
        }
        classConfig.maintainMetaClass(false);
        classConfig.readAs(Platform4.db4oClass(className));
    }

    private static String db4oClass(String className) {
        return DB4O_PACKAGE + className;
    }

    private static final boolean noNIO() {
        try {
            return Platform4.propertyIs("java.vendor", "Sun") && Platform4.propertyIs("java.version", "1.4.0") && (Platform4.propertyIs("os.name", "Linux") || Platform4.propertyIs("os.name", "Windows 95") || Platform4.propertyIs("os.name", "Windows 98"));
        }
        catch (Exception e) {
            return true;
        }
    }

    public static final void pollReferenceQueue(Object a_stream, Object a_referenceQueue) {
        Platform4.jdk().pollReferenceQueue((ObjectContainerBase)a_stream, a_referenceQueue);
    }

    private static final boolean propertyIs(String propertyName, String propertyValue) {
        String property = System.getProperty(propertyName);
        return property != null && property.indexOf(propertyValue) == 0;
    }

    public static void registerCollections(GenericReflector reflector) {
        Platform4.jdk().registerCollections(reflector);
    }

    static final synchronized void removeShutDownHook(ObjectContainerBase container) {
        if (!Platform4.hasShutDownHook() || shutDownRunnable == null) {
            return;
        }
        shutDownRunnable.remove(container);
        if (shutDownRunnable.size() == 0) {
            if (!Platform4.shutDownRunnable.dontRemove) {
                try {
                    Platform4.jdk().removeShutdownHook(shutDownThread);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            shutDownThread = null;
            shutDownRunnable = null;
        }
    }

    public static final byte[] serialize(Object obj) throws Exception {
        return Platform4.jdk().serialize(obj);
    }

    public static final void setAccessible(Object a_accessible) {
        if (setAccessibleCheck == TernaryBool.UNSPECIFIED) {
            Platform4.canSetAccessible();
        }
        if (setAccessibleCheck == TernaryBool.YES) {
            Platform4.jdk().setAccessible(a_accessible);
        }
    }

    public static boolean storeStaticFieldValues(Reflector reflector, ReflectClass claxx) {
        return Platform4.isEnum(reflector, claxx);
    }

    public static boolean isJavaEnum(Reflector reflector, ReflectClass claxx) {
        return Platform4.isEnum(reflector, claxx);
    }

    public static boolean isEnum(Reflector reflector, ReflectClass claxx) {
        return Platform4.jdk().isEnum(reflector, claxx);
    }

    private static final void translate(ObjectClass oc, String to) {
        ((Config4Class)oc).translateOnDemand(DB4O_CONFIG + to);
    }

    private static final void translate(Config4Impl config, String from, String to) {
        Platform4.translate(config.objectClass(from), to);
    }

    private static final void translateCollection(Config4Impl config, String from, String to, boolean cascadeOnDelete) {
        ObjectClass oc = config.objectClass(UTIL + from);
        oc.updateDepth(3);
        if (cascadeOnDelete) {
            oc.cascadeOnDelete(true);
        }
        Platform4.translate(oc, to);
    }

    private static final void translateUtilNull(Config4Impl config, String className) {
        Platform4.translate(config, UTIL + className, "TNull");
    }

    static final NetTypeHandler[] types(Reflector reflector) {
        return Platform4.jdk().types(reflector);
    }

    public static byte[] updateClassName(byte[] bytes) {
        return bytes;
    }

    public static Object weakReferenceTarget(Object weakRef) {
        return Platform4.jdk().weakReferenceTarget(weakRef);
    }

    public static Object wrapEvaluation(Object evaluation) {
        return evaluation;
    }

    public static boolean isTransient(ReflectClass claxx) {
        return false;
    }

    public static Reflector reflectorForType(Class clazz) {
        return Platform4.jdk().reflectorForType(clazz);
    }

    public static Date now() {
        return new Date();
    }

    public static boolean useNativeSerialization() {
        return Platform4.jdk().useNativeSerialization();
    }

    public static void registerPlatformHandlers(ObjectContainerBase container) {
        container.handlers().treatAsOpenType(Number.class);
    }

    public static Class nullableTypeFor(Class primitiveJavaClass) {
        Class wrapperClazz;
        if (_primitive2Wrapper == null) {
            Platform4.initPrimitive2Wrapper();
        }
        if ((wrapperClazz = (Class)_primitive2Wrapper.get(primitiveJavaClass)) == null) {
            throw new NotImplementedException("No nullableTypeFor : " + primitiveJavaClass.getName());
        }
        return wrapperClazz;
    }

    private static void initPrimitive2Wrapper() {
        _primitive2Wrapper = new Hashtable4();
        _primitive2Wrapper.put(Integer.TYPE, Integer.class);
        _primitive2Wrapper.put(Byte.TYPE, Byte.class);
        _primitive2Wrapper.put(Short.TYPE, Short.class);
        _primitive2Wrapper.put(Float.TYPE, Float.class);
        _primitive2Wrapper.put(Double.TYPE, Double.class);
        _primitive2Wrapper.put(Long.TYPE, Long.class);
        _primitive2Wrapper.put(Boolean.TYPE, Boolean.class);
        _primitive2Wrapper.put(Character.TYPE, Character.class);
    }

    public static Object nullValue(Class clazz) {
        if (_nullValues == null) {
            Platform4.initNullValues();
        }
        return _nullValues.get(clazz);
    }

    private static void initNullValues() {
        _nullValues = new Hashtable4();
        _nullValues.put(Boolean.TYPE, (Object)Boolean.FALSE);
        _nullValues.put(Byte.TYPE, (Object)new Byte(0));
        _nullValues.put(Short.TYPE, (Object)new Short(0));
        _nullValues.put(Character.TYPE, (Object)new Character('\u0000'));
        _nullValues.put(Integer.TYPE, (Object)new Integer(0));
        _nullValues.put(Float.TYPE, (Object)new Float(0.0));
        _nullValues.put(Long.TYPE, (Object)new Long(0L));
        _nullValues.put(Double.TYPE, (Object)new Double(0.0));
    }

    public static Class[] primitiveTypes() {
        return new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    }

    public static void throwUncheckedException(Throwable origExc) {
        if (origExc instanceof RuntimeException) {
            throw (RuntimeException)origExc;
        }
        if (origExc instanceof Error) {
            throw (Error)origExc;
        }
        Platform4.jdk().throwIllegalArgumentException(origExc);
    }

    static {
        nioCheck = TernaryBool.UNSPECIFIED;
        setAccessibleCheck = TernaryBool.UNSPECIFIED;
        shutDownHookCheck = TernaryBool.UNSPECIFIED;
        callConstructorCheck = TernaryBool.UNSPECIFIED;
        weakReferenceCheck = TernaryBool.UNSPECIFIED;
        SIMPLE_CLASSES = new Class[]{Integer.class, Long.class, Float.class, Boolean.class, Double.class, Byte.class, Character.class, Short.class, String.class, Date.class};
    }
}

