/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.Configuration;
import com.db4o.ext.MemoryFile;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.NotSupportedException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.io.Storage;

public class InMemoryObjectContainer
extends LocalObjectContainer {
    private boolean _closed = false;
    private final MemoryFile _memoryFile;
    private int _capacity = 0;
    private int _length = 0;
    protected static final ConstructionMode DEFERRED_OPEN_MODE = new ConstructionMode();

    public InMemoryObjectContainer(Configuration config, MemoryFile memoryFile) throws OldFormatException {
        super(config);
        this._memoryFile = memoryFile;
        this.open();
    }

    protected InMemoryObjectContainer(Config4Impl config, MemoryFile memoryFile, ConstructionMode ignored) {
        super(config);
        this._memoryFile = memoryFile;
    }

    public void deferredOpen() {
        this.open();
    }

    protected final void openImpl() throws OldFormatException {
        byte[] bytes = this._memoryFile.getBytes();
        if (bytes == null || bytes.length == 0) {
            this._memoryFile.setBytes(new byte[this._memoryFile.getInitialSize()]);
            this.configureNewFile();
            this.commitTransaction();
            this.writeHeader(false, false);
        } else {
            this._length = this._capacity = bytes.length;
            this.readThis();
        }
    }

    public void backup(Storage targetStorage, String path) throws NotSupportedException {
        throw new NotSupportedException();
    }

    public void blockSize(int size) {
    }

    protected void closeTransaction() {
    }

    protected void closeSystemTransaction() {
    }

    protected void shutdownDataStorage() {
        if (!this._closed) {
            byte[] temp = new byte[this._capacity];
            System.arraycopy(this._memoryFile.getBytes(), 0, temp, 0, this._capacity);
            this._memoryFile.setBytes(temp);
        }
        this._closed = true;
        this.dropReferences();
    }

    protected void dropReferences() {
    }

    public long fileLength() {
        return this._length;
    }

    public String fileName() {
        return "Memory File";
    }

    protected boolean hasShutDownHook() {
        return false;
    }

    public final boolean needsLockFileThread() {
        return false;
    }

    public void readBytes(byte[] bytes, int address, int length) {
        try {
            System.arraycopy(this._memoryFile.getBytes(), address, bytes, 0, length);
        }
        catch (Exception e) {
            Exceptions4.throwRuntimeException(13, e);
        }
    }

    public void readBytes(byte[] bytes, int address, int addressOffset, int length) {
        this.readBytes(bytes, address + addressOffset, length);
    }

    public void syncFiles() {
    }

    public void writeBytes(ByteArrayBuffer buffer, int address, int addressOffset) {
        int fullAddress = address + addressOffset;
        int length = buffer.length();
        this.ensureMemoryFileSize(fullAddress + length);
        System.arraycopy(buffer._buffer, 0, this._memoryFile.getBytes(), fullAddress, length);
        this._length = Math.max(this._length, fullAddress + length + 1);
    }

    private void ensureMemoryFileSize(int last) {
        if (last < this._capacity) {
            return;
        }
        byte[] bytes = this._memoryFile.getBytes();
        if (last < bytes.length) {
            this._capacity = last;
            return;
        }
        int increment = this._memoryFile.getIncrementSizeBy();
        while (last > increment + bytes.length) {
            increment <<= 1;
        }
        byte[] newBytes = new byte[bytes.length + increment];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        this._memoryFile.setBytes(newBytes);
        this._capacity = newBytes.length;
    }

    public void overwriteDeletedBytes(int a_address, int a_length) {
    }

    public void reserve(int byteCount) {
        throw new NotSupportedException();
    }

    public byte blockSize() {
        return 1;
    }

    protected void fatalStorageShutdown() {
        this.shutdownDataStorage();
    }

    protected static final class ConstructionMode {
        protected ConstructionMode() {
        }
    }
}

