/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.Arrays4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Entry4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.HashtableIntEntry;
import com.db4o.foundation.HashtableIterator;
import com.db4o.foundation.HashtableObjectEntry;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;

public class HashtableBase {
    private static final float FILL = 0.5f;
    public int _tableSize;
    public int _mask;
    public int _maximumSize;
    public int _size;
    public HashtableIntEntry[] _table;

    public HashtableBase(int size) {
        size = this.newSize(size);
        this._tableSize = 1;
        while (this._tableSize < size) {
            this._tableSize <<= 1;
        }
        this._mask = this._tableSize - 1;
        this._maximumSize = (int)((float)this._tableSize * 0.5f);
        this._table = new HashtableIntEntry[this._tableSize];
    }

    public HashtableBase() {
        this(1);
    }

    protected HashtableBase(DeepClone cloneOnlyCtor) {
    }

    public void clear() {
        this._size = 0;
        Arrays4.fill(this._table, null);
    }

    private final int newSize(int size) {
        return (int)((float)size / 0.5f);
    }

    public int size() {
        return this._size;
    }

    protected HashtableIntEntry findWithSameKey(HashtableIntEntry newEntry) {
        HashtableIntEntry existing = this._table[this.entryIndex(newEntry)];
        while (null != existing) {
            if (existing.sameKeyAs(newEntry)) {
                return existing;
            }
            existing = existing._next;
        }
        return null;
    }

    protected int entryIndex(HashtableIntEntry entry) {
        return entry._key & this._mask;
    }

    protected void putEntry(HashtableIntEntry newEntry) {
        HashtableIntEntry existing = this.findWithSameKey(newEntry);
        if (null != existing) {
            this.replace(existing, newEntry);
        } else {
            this.insert(newEntry);
        }
    }

    private void insert(HashtableIntEntry newEntry) {
        ++this._size;
        if (this._size > this._maximumSize) {
            this.increaseSize();
        }
        int index = this.entryIndex(newEntry);
        newEntry._next = this._table[index];
        this._table[index] = newEntry;
    }

    private void replace(HashtableIntEntry existing, HashtableIntEntry newEntry) {
        newEntry._next = existing._next;
        HashtableIntEntry entry = this._table[this.entryIndex(existing)];
        if (entry == existing) {
            this._table[this.entryIndex((HashtableIntEntry)existing)] = newEntry;
        } else {
            while (entry._next != existing) {
                entry = entry._next;
            }
            entry._next = newEntry;
        }
    }

    private void increaseSize() {
        this._tableSize <<= 1;
        this._maximumSize <<= 1;
        this._mask = this._tableSize - 1;
        HashtableIntEntry[] temp = this._table;
        this._table = new HashtableIntEntry[this._tableSize];
        for (int i = 0; i < temp.length; ++i) {
            this.reposition(temp[i]);
        }
    }

    protected HashtableIterator hashtableIterator() {
        return new HashtableIterator(this._table);
    }

    private void reposition(HashtableIntEntry entry) {
        HashtableIntEntry currentEntry = entry;
        HashtableIntEntry nextEntry = null;
        while (currentEntry != null) {
            nextEntry = currentEntry._next;
            currentEntry._next = this._table[this.entryIndex(currentEntry)];
            this._table[this.entryIndex((HashtableIntEntry)currentEntry)] = currentEntry;
            currentEntry = nextEntry;
        }
    }

    public Iterator4 keys() {
        return Iterators.map(this.hashtableIterator(), new Function4(){

            public Object apply(Object current) {
                return ((Entry4)current).key();
            }
        });
    }

    public Iterable4 values() {
        return new Iterable4(){

            public Iterator4 iterator() {
                return HashtableBase.this.valuesIterator();
            }
        };
    }

    public Iterator4 valuesIterator() {
        return Iterators.map(this.hashtableIterator(), new Function4(){

            public Object apply(Object current) {
                return ((Entry4)current).value();
            }
        });
    }

    public String toString() {
        return Iterators.join(this.hashtableIterator(), "{", "}", ", ");
    }

    protected void removeEntry(HashtableIntEntry predecessor, HashtableIntEntry entry) {
        if (predecessor != null) {
            predecessor._next = entry._next;
        } else {
            this._table[this.entryIndex((HashtableIntEntry)entry)] = entry._next;
        }
        --this._size;
    }

    protected Object removeObjectEntry(int intKey, Object objectKey) {
        HashtableObjectEntry entry = (HashtableObjectEntry)this._table[intKey & this._mask];
        HashtableObjectEntry predecessor = null;
        while (entry != null) {
            if (entry._key == intKey && entry.hasKey(objectKey)) {
                this.removeEntry(predecessor, entry);
                return entry._object;
            }
            predecessor = entry;
            entry = (HashtableObjectEntry)entry._next;
        }
        return null;
    }

    protected Object removeIntEntry(int key) {
        HashtableIntEntry entry = this._table[key & this._mask];
        HashtableIntEntry predecessor = null;
        while (entry != null) {
            if (entry._key == key) {
                this.removeEntry(predecessor, entry);
                return entry._object;
            }
            predecessor = entry;
            entry = entry._next;
        }
        return null;
    }
}

