/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.LogUtil;
import net.i2p.client.streaming.MessageChannel;
import net.i2p.client.streaming.MessageOutputStream;
import net.i2p.data.Destination;
import net.i2p.util.Log;

class I2PSocketFull
implements I2PSocket {
    private final Log log;
    private volatile Connection _connection;
    private final Destination _remotePeer;
    private final Destination _localPeer;
    private volatile MessageChannel _channel;
    private final AtomicBoolean _closed = new AtomicBoolean(false);

    public I2PSocketFull(Connection con, I2PAppContext context) {
        this.log = context.logManager().getLog(I2PSocketFull.class);
        this._connection = con;
        if (con != null) {
            this._remotePeer = con.getRemotePeer();
            this._localPeer = con.getSession().getMyDestination();
        } else {
            this._localPeer = null;
            this._remotePeer = null;
        }
    }

    public void close() throws IOException {
        if (!this._closed.compareAndSet(false, true)) {
            LogUtil.logCloseLoop(this.log, "I2PSocket", this._localPeer, "-->", this._remotePeer, this._connection);
            return;
        }
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        if (c.getIsConnected()) {
            MessageOutputStream out = c.getOutputStream();
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            c.disconnect(true);
        }
        this.destroy();
    }

    Connection getConnection() {
        return this._connection;
    }

    public InputStream getInputStream() {
        Connection c = this._connection;
        if (c != null) {
            return c.getInputStream();
        }
        return null;
    }

    public I2PSocketOptions getOptions() {
        Connection c = this._connection;
        if (c != null) {
            return c.getOptions();
        }
        return null;
    }

    public synchronized SelectableChannel getChannel() {
        if (this._channel == null) {
            this._channel = new MessageChannel(this);
        }
        return this._channel;
    }

    public OutputStream getOutputStream() throws IOException {
        Connection c = this._connection;
        if (c != null) {
            return c.getOutputStream();
        }
        return null;
    }

    public Destination getPeerDestination() {
        return this._remotePeer;
    }

    public long getReadTimeout() {
        I2PSocketOptions opts = this.getOptions();
        if (opts != null) {
            return opts.getReadTimeout();
        }
        return -1L;
    }

    public Destination getThisDestination() {
        return this._localPeer;
    }

    public void setOptions(I2PSocketOptions options) {
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        if (options instanceof ConnectionOptions) {
            c.setOptions((ConnectionOptions)options);
        } else {
            c.setOptions(new ConnectionOptions(options));
        }
    }

    public void setReadTimeout(long ms) {
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        c.getInputStream().setReadTimeout((int)ms);
        c.getOptions().setReadTimeout(ms);
    }

    public void setSocketErrorListener(I2PSocket.SocketErrorListener lsnr) {
    }

    public boolean isClosed() {
        Connection c = this._connection;
        return c == null || !c.getIsConnected() || c.getResetReceived() || c.getResetSent();
    }

    void destroy() {
        Connection c = this._connection;
        this.destroy2();
        if (c != null) {
            c.disconnectComplete();
        }
    }

    void destroy2() {
        this._connection = null;
    }

    public int getPort() {
        Connection c = this._connection;
        return c == null ? 0 : c.getPort();
    }

    public int getLocalPort() {
        Connection c = this._connection;
        return c == null ? 0 : c.getLocalPort();
    }

    public String toString() {
        Connection c = this._connection;
        if (c == null) {
            return super.toString();
        }
        return c.toString();
    }
}

