/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.DataBaseCoreImpl;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkAuthTableModel;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewNetworkDialog;
import org.ourfilesystem.ui.NewPostDialog;
import org.ourfilesystem.ui.NewTemplateDialog;
import org.ourfilesystem.ui.PostPanel;
import org.ourfilesystem.ui.PostTableModel;
import org.ourfilesystem.ui.QueryTableModel;
import org.ourfilesystem.ui.TemplateTableModel;
import org.ourfilesystem.utilities.BBytes;

public class PostSearchPanel
extends JPanel
implements NetworkSelectInterface {
    private static final long serialVersionUID = 1L;
    private JTextField textQueryName;
    private JLabel lblGeneralSearch;
    private JTextField textGeneral;
    private JCheckBox chckbxUseGeneral;
    private JTextField textFileName;
    private JCheckBox chckbxUseFileName;
    private JTextField textSubject;
    private JCheckBox chckbxUseSubject;
    private JTextField textComment;
    private JCheckBox chckbxUseComment;
    private JTextField textMinRank;
    private JCheckBox chckbxUseMinRank;
    private JCheckBox[] chckbxBool;
    private JLabel lblPrimaryReference;
    private BBytes PrimaryReference;
    private JLabel[] lblRefName;
    private JLabel[] lblReference;
    private BBytes[] References;
    private JCheckBox[] chckbxRemoveRef;
    private JCheckBox[] chckbxAddRef;
    private JLabel[] lblNumLessThan;
    private JTextField[] txtNumLessThan;
    private JCheckBox[] chckbxNumLessThan;
    private JLabel[] lblNumGreaterThan;
    private JTextField[] txtNumGreaterThan;
    private JCheckBox[] chckbxNumGreaterThan;
    private JLabel[] lblDoubleLessThan;
    private JTextField[] txtDoubleLessThan;
    private JCheckBox[] chckbxDoubleLessThan;
    private JLabel[] lblDoubleGreaterThan;
    private JTextField[] txtDoubleGreaterThan;
    private JCheckBox[] chckbxDoubleGreaterThan;
    private JLabel[] lblString;
    private JTextField[] textString;
    private JCheckBox[] chckbxUseString;
    private JSplitPane mainSplitPane;
    private JScrollPane mainScroll;
    private Main Mn;
    private JLabel lblGroupSel;
    private JLabel lblTemplateSel;
    private JTable table;
    private JTable table_1;
    private QueryTableModel QueryTableModel;
    private TemplateTableModel TemplateTableModel;
    private NetworkAuthTableModel NetworkAuthTableModel;
    private NewTemplateDialog NewTemplateDialog;
    private NewPostDialog NewPostDialog;
    private PostTemplate SelectedTemplate;
    private LocalNetwork SelectedNetwork;
    private LocalPost SelectedPost;
    private SearchQuery SelectedQuery;
    private JButton btnSearch;
    private PostTableModel PostTableModel;
    private JButton btnRefreshTemplates;
    private JButton btnNewGroup;
    private JSplitPane splitPane;
    private JPanel panel_1;
    private JTextField textGrpSearch;
    private JButton btnSearch_1;
    private JPanel panel_2;
    private JScrollPane scrollPane_2;
    private JTable table_2;
    private NewNetworkDialog Dialog;
    private JLabel lblMaxResults;
    private JTextField textMaxResults;
    private JLabel lblFileReference;
    private JButton btnClear;
    private PostPanel PostPanel;
    private JLabel lblFromDate;
    private JCheckBox chckbxUseFromDate;
    private JDateChooser FromDate;
    private JLabel lblToDate;
    private JCheckBox chckbxUseToDate;
    private JDateChooser ToDate;
    private JTextField textDaysBackwards;
    private JCheckBox chckbxUseDaysBackwards;

    public PostSearchPanel(Main m, PostPanel pp, PostTableModel tm) {
        this.Mn = m;
        this.PostPanel = pp;
        this.PostTableModel = tm;
        this.QueryTableModel = new QueryTableModel(this.Mn);
        this.TemplateTableModel = new TemplateTableModel(this.Mn);
        this.NetworkAuthTableModel = new NetworkAuthTableModel();
        this.NetworkAuthTableModel.setSimple(true);
        this.Dialog = new NewNetworkDialog(this.Mn);
        this.setLayout(new BorderLayout(0, 0));
        this.NewTemplateDialog = new NewTemplateDialog(this.TemplateTableModel);
        this.NewPostDialog = new NewPostDialog(this.Mn, this);
        this.mainSplitPane = new JSplitPane();
        this.add((Component)this.mainSplitPane, "Center");
        JSplitPane splitPane_1 = new JSplitPane();
        this.mainSplitPane.setLeftComponent(splitPane_1);
        JSplitPane splitPane_2 = new JSplitPane();
        splitPane_1.setLeftComponent(splitPane_2);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(100, 2));
        splitPane_2.setLeftComponent(scrollPane);
        JPopupMenu querymenu = new JPopupMenu();
        JMenuItem usequery = new JMenuItem("Select Query");
        querymenu.add(usequery);
        usequery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        JMenuItem delquery = new JMenuItem("Delete Query");
        querymenu.add(delquery);
        delquery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PostSearchPanel.this.doLoadQuery();
            }
        });
        this.table = new JTable(this.QueryTableModel);
        this.table.setComponentPopupMenu(querymenu);
        this.table.setAutoCreateRowSorter(true);
        scrollPane.setViewportView(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                PostSearchPanel.this.doLoadQuery();
            }
        });
        this.splitPane = new JSplitPane();
        this.splitPane.setPreferredSize(new Dimension(100, 2));
        this.splitPane.setOrientation(0);
        splitPane_2.setRightComponent(this.splitPane);
        this.panel_1 = new JPanel();
        this.splitPane.setLeftComponent(this.panel_1);
        this.panel_1.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][][]"));
        this.textGrpSearch = new JTextField();
        this.panel_1.add((Component)this.textGrpSearch, "flowx,cell 0 1,growx");
        this.textGrpSearch.setColumns(10);
        this.panel_1.setPreferredSize(new Dimension(100, 2));
        this.btnSearch_1 = new JButton("Search");
        this.panel_1.add((Component)this.btnSearch_1, "cell 0 2");
        this.btnSearch_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostSearchPanel.this.doSearch();
            }
        });
        this.panel_2 = new JPanel();
        this.splitPane.setRightComponent(this.panel_2);
        this.panel_2.setLayout(new BorderLayout(0, 0));
        this.panel_2.setPreferredSize(new Dimension(100, 2));
        this.scrollPane_2 = new JScrollPane();
        this.scrollPane_2.setPreferredSize(new Dimension(100, 2));
        this.panel_2.add((Component)this.scrollPane_2, "Center");
        this.table_2 = new JTable(this.NetworkAuthTableModel);
        this.table_2.setSelectionMode(0);
        this.table_2.setAutoCreateRowSorter(true);
        this.scrollPane_2.setViewportView(this.table_2);
        this.table_2.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!PostSearchPanel.this.table_2.getSelectionModel().isSelectionEmpty()) {
                    int r = PostSearchPanel.this.table_2.getSelectedRow();
                    r = PostSearchPanel.this.table_2.convertRowIndexToModel(r);
                    LocalNetworkAuthorization lna = PostSearchPanel.this.NetworkAuthTableModel.getNetworkAuth(r);
                    if (lna != null) {
                        LocalNetwork ln = PostSearchPanel.this.Mn.getCoreDB().getLocalNetwork(lna.getNetworkAuthorization().getNetworkId());
                        PostSearchPanel.this.Mn.getGui().setNewNetwork(ln, lna);
                    }
                }
            }
        });
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setPreferredSize(new Dimension(100, 2));
        JSplitPane splitPane_3 = new JSplitPane();
        splitPane_3.setOrientation(0);
        splitPane_1.setRightComponent(splitPane_3);
        this.btnRefreshTemplates = new JButton("Refresh");
        splitPane_3.setLeftComponent(this.btnRefreshTemplates);
        this.btnRefreshTemplates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostSearchPanel.this.TemplateTableModel.refresh();
            }
        });
        splitPane_3.setRightComponent(scrollPane_1);
        this.table_1 = new JTable(this.TemplateTableModel);
        this.table_1.setAutoCreateRowSorter(true);
        this.table_1.setSelectionMode(0);
        scrollPane_1.setViewportView(this.table_1);
        this.table_1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!PostSearchPanel.this.table_1.getSelectionModel().isSelectionEmpty()) {
                    int r = PostSearchPanel.this.table_1.getSelectedRow();
                    r = PostSearchPanel.this.table_1.convertRowIndexToModel(r);
                    PostSearchPanel.this.SelectedTemplate = PostSearchPanel.this.TemplateTableModel.getTemplate(r);
                    PostSearchPanel.this.buildSearchPane();
                    PostSearchPanel.this.PostPanel.buildPopupMenu(PostSearchPanel.this.SelectedTemplate);
                }
            }
        });
        this.mainScroll = new JScrollPane();
        this.mainSplitPane.setRightComponent(this.mainScroll);
        this.mainSplitPane.setDividerLocation(350);
        splitPane_1.setDividerLocation(250);
        splitPane_2.setDividerLocation(100);
        this.buildSearchPane();
        this.doSearch();
    }

    private void doLoadQuery() {
        if (!this.table.getSelectionModel().isSelectionEmpty()) {
            int r = this.table.getSelectedRow();
            r = this.table.convertRowIndexToModel(r);
            this.SelectedQuery = this.QueryTableModel.getSearchQuery(r);
            this.updateFromSelectedQuery();
        }
    }

    public void doSearch() {
        String s = this.textGrpSearch.getText();
        QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().queryMyNetworkAuths(s);
        this.NetworkAuthTableModel.setNetworkAuths(qr);
    }

    public void doSearchPosts() {
        SearchQuery sq = this.buildQuery();
        if (sq != null && this.Mn != null && this.PostTableModel != null) {
            QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().searchPosts(sq);
            this.PostTableModel.setPosts(qr);
        }
    }

    public void searchPrimaryPost(BBytes ref) {
        this.buildSearchPane();
        this.lblPrimaryReference.setText("(" + ref.toString().substring(0, 20) + ")");
        this.PrimaryReference = ref;
        this.doSearchPosts();
    }

    private void addKeyListener(final JTextField field, final JCheckBox chk) {
        field.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                Matcher m = Pattern.compile("\\S+").matcher(field.getText());
                if (m.find()) {
                    chk.setSelected(true);
                } else {
                    chk.setSelected(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
    }

    private void buildSearchPane() {
        final JPanel panel = new JPanel();
        this.mainScroll.setViewportView(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow][]", "[][][][][][][][][][][][]"));
        String grpname = "none";
        if (this.SelectedNetwork != null) {
            grpname = this.SelectedNetwork.getNetwork().getTitleSig();
        }
        String tempname = "none";
        if (this.SelectedTemplate != null) {
            tempname = this.SelectedTemplate.getTemplateName();
        }
        JButton btnNewPost = new JButton("New Post");
        panel.add((Component)btnNewPost, "flowx,cell 1 2,alignx left");
        btnNewPost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PostSearchPanel.this.SelectedTemplate != null) {
                    if (PostSearchPanel.this.SelectedNetwork != null) {
                        PostSearchPanel.this.NewPostDialog.showDialog(PostSearchPanel.this.SelectedTemplate, PostSearchPanel.this.SelectedPost, PostSearchPanel.this.SelectedNetwork.getNetwork().getTitleSig());
                    } else {
                        JOptionPane.showMessageDialog(panel, "Select a group first.", "Select group", 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(panel, "Select a template first.", "Select template", 2);
                }
            }
        });
        JButton btnUpdatePosts = new JButton("Update Posts");
        panel.add((Component)btnUpdatePosts, "cell 1 2,alignx right");
        btnUpdatePosts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostSearchPanel.this.Mn.getUpdater().updatePostsNow();
            }
        });
        this.btnSearch = new JButton("Search");
        panel.add((Component)this.btnSearch, "cell 2 2");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PostSearchPanel.this.SelectedNetwork == null) {
                    JOptionPane.showMessageDialog(panel, "No Group is selected.", "No Group", 2);
                    return;
                }
                if (PostSearchPanel.this.SelectedTemplate == null) {
                    JOptionPane.showMessageDialog(panel, "No template is selected.", "No template", 2);
                    return;
                }
                PostSearchPanel.this.doSearchPosts();
            }
        });
        JLabel lblQueryName = new JLabel("Query name");
        panel.add((Component)lblQueryName, "cell 0 3,alignx trailing");
        this.textQueryName = new JTextField();
        panel.add((Component)this.textQueryName, "cell 1 3,growx");
        this.textQueryName.setColumns(10);
        JButton btnSaveQuery = new JButton("Save Query");
        panel.add((Component)btnSaveQuery, "cell 2 3");
        btnSaveQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchQuery sq = PostSearchPanel.this.buildQuery();
                Matcher m = Pattern.compile("\\S+").matcher(sq.QueryName);
                if (m.find()) {
                    PostSearchPanel.this.SelectedQuery = sq;
                    PostSearchPanel.this.QueryTableModel.saveSearchQuery(sq);
                } else {
                    JOptionPane.showMessageDialog(panel, "You must name the query.", "Name Query", 2);
                }
            }
        });
        this.lblFileReference = new JLabel("File Reference");
        panel.add((Component)this.lblFileReference, "cell 0 4,alignx trailing");
        this.lblPrimaryReference = new JLabel("none");
        panel.add((Component)this.lblPrimaryReference, "cell 1 4");
        this.btnClear = new JButton("Clear");
        panel.add((Component)this.btnClear, "cell 2 4");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PostSearchPanel.this.lblPrimaryReference.setText("none");
                PostSearchPanel.this.PrimaryReference = null;
            }
        });
        this.lblGeneralSearch = new JLabel("General Search");
        panel.add((Component)this.lblGeneralSearch, "cell 0 5,alignx trailing");
        this.textGeneral = new JTextField();
        panel.add((Component)this.textGeneral, "cell 1 5,growx");
        this.textGeneral.setColumns(10);
        this.chckbxUseGeneral = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseGeneral, "cell 2 5");
        this.addKeyListener(this.textGeneral, this.chckbxUseGeneral);
        JLabel lblFileName = new JLabel("File name");
        panel.add((Component)lblFileName, "cell 0 6,alignx trailing");
        this.textFileName = new JTextField();
        panel.add((Component)this.textFileName, "cell 1 6,growx");
        this.textFileName.setColumns(10);
        this.chckbxUseFileName = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseFileName, "cell 2 6");
        this.addKeyListener(this.textFileName, this.chckbxUseFileName);
        JLabel lblSubject = new JLabel("Subject");
        panel.add((Component)lblSubject, "cell 0 7,alignx trailing");
        this.textSubject = new JTextField();
        panel.add((Component)this.textSubject, "cell 1 7,growx");
        this.textSubject.setColumns(10);
        this.chckbxUseSubject = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseSubject, "cell 2 7");
        this.addKeyListener(this.textSubject, this.chckbxUseSubject);
        JLabel lblComment = new JLabel("Comment");
        panel.add((Component)lblComment, "cell 0 8,alignx trailing");
        this.textComment = new JTextField();
        panel.add((Component)this.textComment, "cell 1 8,growx");
        this.textComment.setColumns(10);
        this.chckbxUseComment = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseComment, "cell 2 8");
        this.addKeyListener(this.textComment, this.chckbxUseComment);
        JLabel lblMinPeerRank = new JLabel("Min Peer Rank");
        panel.add((Component)lblMinPeerRank, "cell 0 9,alignx trailing");
        this.textMinRank = new JTextField();
        panel.add((Component)this.textMinRank, "cell 1 9,growx");
        this.textMinRank.setColumns(10);
        this.chckbxUseMinRank = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseMinRank, "cell 2 9");
        this.addKeyListener(this.textMinRank, this.chckbxUseMinRank);
        JButton btnNewTemplate = new JButton("New Template");
        panel.add((Component)btnNewTemplate, "flowx,cell 1 1,alignx left");
        btnNewTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PostSearchPanel.this.NewTemplateDialog != null) {
                    if (PostSearchPanel.this.SelectedNetwork != null) {
                        PostSearchPanel.this.NewTemplateDialog.showDialog(PostSearchPanel.this.SelectedNetwork);
                    } else {
                        JOptionPane.showMessageDialog(panel, "Group must be selected first.\nUse the Group tab.", "Select Group", 2);
                    }
                }
            }
        });
        JLabel lblTemplate = new JLabel("Current Template:");
        panel.add((Component)lblTemplate, "cell 1 1,alignx trailing");
        this.lblTemplateSel = new JLabel(tempname);
        panel.add((Component)this.lblTemplateSel, "cell 1 1,alignx left");
        this.btnNewGroup = new JButton("New Group");
        panel.add((Component)this.btnNewGroup, "flowx,cell 1 0");
        this.btnNewGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PostSearchPanel.this.Dialog.showDialog();
            }
        });
        JLabel lblGroup = new JLabel("Current Group:");
        panel.add((Component)lblGroup, "cell 1 0,alignx left");
        this.lblGroupSel = new JLabel(grpname);
        panel.add((Component)this.lblGroupSel, "cell 1 0");
        this.lblNumLessThan = new JLabel[10];
        this.txtNumLessThan = new JTextField[10];
        this.chckbxNumLessThan = new JCheckBox[10];
        this.lblNumGreaterThan = new JLabel[10];
        this.txtNumGreaterThan = new JTextField[10];
        this.chckbxNumGreaterThan = new JCheckBox[10];
        this.lblDoubleLessThan = new JLabel[10];
        this.txtDoubleLessThan = new JTextField[10];
        this.chckbxDoubleLessThan = new JCheckBox[10];
        this.lblDoubleGreaterThan = new JLabel[10];
        this.txtDoubleGreaterThan = new JTextField[10];
        this.chckbxDoubleGreaterThan = new JCheckBox[10];
        this.chckbxBool = new JCheckBox[10];
        this.textString = new JTextField[8];
        this.chckbxUseString = new JCheckBox[8];
        this.lblRefName = new JLabel[3];
        this.lblReference = new JLabel[3];
        this.References = new BBytes[3];
        this.chckbxRemoveRef = new JCheckBox[3];
        this.chckbxAddRef = new JCheckBox[3];
        int r = 11;
        if (this.SelectedTemplate != null) {
            int c3;
            JButton btnMin;
            int c2;
            JButton btnMax;
            String nv;
            int numinserted = 0;
            int c = 0;
            while (c < 10) {
                nv = this.SelectedTemplate.getBool(c);
                if (nv != null) {
                    this.chckbxBool[c] = new JCheckBox(nv);
                    panel.add((Component)this.chckbxBool[c], "cell 1 " + r);
                    if (++numinserted % 2 == 0) {
                        ++r;
                    }
                }
                ++c;
            }
            if (numinserted % 2 != 0) {
                ++r;
            }
            c = 0;
            while (c < 10) {
                nv = this.SelectedTemplate.getNum(c);
                if (nv != null) {
                    this.lblNumLessThan[c] = new JLabel(String.valueOf(nv) + " <");
                    panel.add((Component)this.lblNumLessThan[c], "cell 0 " + r + ",alignx trailing");
                    this.txtNumLessThan[c] = new JTextField();
                    panel.add((Component)this.txtNumLessThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtNumLessThan[c].setColumns(10);
                    btnMax = new JButton("Max");
                    panel.add((Component)btnMax, "cell 1 " + r);
                    c2 = c;
                    btnMax.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            PostSearchPanel.this.txtNumLessThan[c2].setText(Long.toString(Long.MAX_VALUE));
                            PostSearchPanel.this.chckbxNumLessThan[c2].setSelected(true);
                        }
                    });
                    this.chckbxNumLessThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxNumLessThan[c], "cell 2 " + r);
                    this.addKeyListener(this.txtNumLessThan[c], this.chckbxNumLessThan[c]);
                    this.lblNumGreaterThan[c] = new JLabel(String.valueOf(nv) + " >");
                    panel.add((Component)this.lblNumGreaterThan[c], "cell 0 " + ++r + ",alignx trailing");
                    this.txtNumGreaterThan[c] = new JTextField();
                    panel.add((Component)this.txtNumGreaterThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtNumGreaterThan[c].setColumns(10);
                    btnMin = new JButton("Min");
                    panel.add((Component)btnMin, "cell 1 " + r);
                    c3 = c;
                    btnMin.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PostSearchPanel.this.txtNumGreaterThan[c3].setText(Long.toString(Long.MIN_VALUE));
                            PostSearchPanel.this.chckbxNumGreaterThan[c3].setSelected(true);
                        }
                    });
                    this.chckbxNumGreaterThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxNumGreaterThan[c], "cell 2 " + r);
                    this.addKeyListener(this.txtNumGreaterThan[c], this.chckbxNumGreaterThan[c]);
                    ++r;
                }
                ++c;
            }
            c = 0;
            while (c < 10) {
                nv = this.SelectedTemplate.getDouble(c);
                if (nv != null) {
                    this.lblDoubleLessThan[c] = new JLabel(String.valueOf(nv) + " <");
                    panel.add((Component)this.lblDoubleLessThan[c], "cell 0 " + r + ",alignx trailing");
                    this.txtDoubleLessThan[c] = new JTextField();
                    panel.add((Component)this.txtDoubleLessThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtDoubleLessThan[c].setColumns(10);
                    btnMax = new JButton("Max");
                    panel.add((Component)btnMax, "cell 1 " + r);
                    c2 = c;
                    btnMax.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            PostSearchPanel.this.txtDoubleLessThan[c2].setText(Double.toString(9.223372036854776E18));
                            PostSearchPanel.this.chckbxDoubleLessThan[c2].setSelected(true);
                        }
                    });
                    this.chckbxDoubleLessThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxDoubleLessThan[c], "cell 2 " + r);
                    this.addKeyListener(this.txtDoubleLessThan[c], this.chckbxDoubleLessThan[c]);
                    this.lblDoubleGreaterThan[c] = new JLabel(String.valueOf(nv) + " >");
                    panel.add((Component)this.lblDoubleGreaterThan[c], "cell 0 " + ++r + ",alignx trailing");
                    this.txtDoubleGreaterThan[c] = new JTextField();
                    panel.add((Component)this.txtDoubleGreaterThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtDoubleGreaterThan[c].setColumns(10);
                    btnMin = new JButton("Min");
                    panel.add((Component)btnMin, "cell 1 " + r);
                    c3 = c;
                    btnMin.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PostSearchPanel.this.txtDoubleGreaterThan[c3].setText(Double.toString(-9.223372036854776E18));
                            PostSearchPanel.this.chckbxDoubleGreaterThan[c3].setSelected(true);
                        }
                    });
                    this.chckbxDoubleGreaterThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxDoubleGreaterThan[c], "cell 2 " + r);
                    this.addKeyListener(this.txtDoubleGreaterThan[c], this.chckbxDoubleGreaterThan[c]);
                    ++r;
                }
                ++c;
            }
            c = 0;
            while (c < 8) {
                nv = this.SelectedTemplate.getString(c);
                if (nv != null) {
                    this.lblString[c] = new JLabel(nv);
                    panel.add((Component)this.lblString[c], "cell 0 " + r + ",alignx trailing");
                    this.textString[c] = new JTextField();
                    panel.add((Component)this.textString[c], "flowx,cell 1 " + r + ",growx");
                    this.textString[c].setColumns(10);
                    this.chckbxUseString[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxUseString[c], "cell 2 " + r);
                    this.addKeyListener(this.textString[c], this.chckbxUseString[c]);
                    ++r;
                }
                ++c;
            }
            c = 0;
            while (c < 3) {
                nv = this.SelectedTemplate.getRef(c);
                if (nv != null) {
                    this.lblRefName[c] = new JLabel(String.valueOf(nv) + ":");
                    panel.add((Component)this.lblRefName[c], "cell 0 " + r + ",alignx trailing");
                    this.lblReference[c] = new JLabel("none");
                    panel.add((Component)this.lblReference[c], "flowx,cell 1 " + r + ",growx");
                    this.References[c] = null;
                    JButton clr = new JButton("Clear");
                    panel.add((Component)clr, "cell 2 " + r);
                    final int rnum = c;
                    clr.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            ((PostSearchPanel)PostSearchPanel.this).References[rnum] = null;
                            PostSearchPanel.this.lblReference[rnum].setText("none");
                        }
                    });
                    this.chckbxRemoveRef[c] = new JCheckBox("Remove posts marked as " + nv);
                    panel.add((Component)this.chckbxRemoveRef[c], "cell 1 " + ++r);
                    this.chckbxAddRef[c] = new JCheckBox("Include posts marked as " + nv);
                    panel.add((Component)this.chckbxAddRef[c], "cell 1 " + ++r);
                    ++r;
                }
                ++c;
            }
        }
        this.lblMaxResults = new JLabel("Max Results");
        panel.add((Component)this.lblMaxResults, "cell 0 " + r + ",alignx trailing");
        this.textMaxResults = new JTextField("1000");
        panel.add((Component)this.textMaxResults, "flowx,cell 1 " + r);
        this.textMaxResults.setColumns(6);
        this.lblFromDate = new JLabel("From Date:");
        panel.add((Component)this.lblFromDate, "cell 0 " + ++r + ",alignx trailing");
        this.FromDate = new JDateChooser();
        panel.add((Component)this.FromDate, "cell 1 " + r);
        this.chckbxUseFromDate = new JCheckBox("Use From Date");
        panel.add((Component)this.chckbxUseFromDate, "cell 1 " + r);
        this.FromDate.getDateEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("date".equals(e.getPropertyName())) {
                    PostSearchPanel.this.chckbxUseFromDate.setSelected(true);
                }
            }
        });
        this.lblToDate = new JLabel("To Date:");
        panel.add((Component)this.lblToDate, "cell 0 " + ++r + ",alignx trailing");
        this.ToDate = new JDateChooser();
        panel.add((Component)this.ToDate, "cell 1 " + r);
        this.chckbxUseToDate = new JCheckBox("Use To Date");
        panel.add((Component)this.chckbxUseToDate, "cell 1 " + r);
        this.ToDate.getDateEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("date".equals(e.getPropertyName())) {
                    PostSearchPanel.this.chckbxUseToDate.setSelected(true);
                }
            }
        });
        JLabel lbldaysback = new JLabel("Number Days back:");
        panel.add((Component)lbldaysback, "cell 0 " + ++r + ",alignx trailing");
        this.textDaysBackwards = new JTextField();
        panel.add((Component)this.textDaysBackwards, "cell 1 " + r);
        this.textDaysBackwards.setColumns(6);
        this.chckbxUseDaysBackwards = new JCheckBox("Use Days Backwards");
        panel.add((Component)this.chckbxUseDaysBackwards, "cell 1 " + r);
        this.addKeyListener(this.textDaysBackwards, this.chckbxUseDaysBackwards);
        JButton search2 = new JButton("Search");
        panel.add((Component)search2, "cell 2 2");
        search2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PostSearchPanel.this.SelectedNetwork == null) {
                    JOptionPane.showMessageDialog(panel, "No Group is selected.", "No Group", 2);
                    return;
                }
                if (PostSearchPanel.this.SelectedTemplate == null) {
                    JOptionPane.showMessageDialog(panel, "No template is selected.", "No template", 2);
                    return;
                }
                PostSearchPanel.this.doSearchPosts();
            }
        });
        panel.add((Component)search2, "cell 2 " + r);
    }

    private void updateFromSelectedQuery() {
        if (this.SelectedQuery != null) {
            Double v;
            Map<String, Double> dl;
            Long v2;
            int c;
            Map<String, Long> l;
            Set<String> b;
            Long mr;
            SearchQuery s = this.SelectedQuery;
            if (s.UseTemplate != null) {
                this.SelectedTemplate = this.Mn.getCoreDB().getPostTemplate(s.UseTemplate);
            }
            this.buildSearchPane();
            this.textQueryName.setText(s.QueryName);
            if (s.Generalterms != null) {
                this.textGeneral.setText(s.Generalterms);
                this.chckbxUseGeneral.setSelected(true);
            }
            if (s.Searchterms != null) {
                String n = s.Searchterms.get(DataBaseCoreImpl.POST_FILENAME);
                if (n != null) {
                    this.chckbxUseFileName.setSelected(true);
                    this.textFileName.setText(n);
                }
                if ((n = s.Searchterms.get(DataBaseCoreImpl.POST_SUBJECT)) != null) {
                    this.chckbxUseSubject.setSelected(true);
                    this.textSubject.setText(n);
                }
                if ((n = s.Searchterms.get(DataBaseCoreImpl.POST_COMMENT)) != null) {
                    this.chckbxUseComment.setSelected(true);
                    this.textComment.setText(n);
                }
                int c2 = 0;
                while (c2 < 8) {
                    n = s.Searchterms.get(PostTemplate.getStringKey(c2));
                    if (n != null) {
                        this.chckbxUseString[c2].setSelected(true);
                        this.textString[c2].setText(n);
                    }
                    ++c2;
                }
            }
            if ((mr = s.Minpeerrank) != null) {
                this.chckbxUseMinRank.setSelected(true);
                this.textMinRank.setText(Long.toString(mr));
            }
            if ((b = s.Andtruebools) != null) {
                int c3 = 0;
                while (c3 < 10) {
                    if (b.contains(PostTemplate.getBoolKey(c3))) {
                        this.chckbxBool[c3].setSelected(true);
                    }
                    ++c3;
                }
            }
            if ((l = s.Lessthan) != null) {
                c = 0;
                while (c < 10) {
                    v2 = l.get(PostTemplate.getNumKey(c));
                    if (v2 != null) {
                        this.chckbxNumLessThan[c].setSelected(true);
                        this.txtNumLessThan[c].setText(Long.toString(v2));
                    }
                    ++c;
                }
            }
            if ((l = s.Greaterthan) != null) {
                c = 0;
                while (c < 10) {
                    v2 = l.get(PostTemplate.getNumKey(c));
                    if (v2 != null) {
                        this.chckbxNumGreaterThan[c].setSelected(true);
                        this.txtNumGreaterThan[c].setText(Long.toString(v2));
                    }
                    ++c;
                }
            }
            if ((dl = s.Dlessthan) != null) {
                int c4 = 0;
                while (c4 < 10) {
                    v = dl.get(PostTemplate.getDoubleKey(c4));
                    if (v != null) {
                        this.chckbxDoubleLessThan[c4].setSelected(true);
                        this.txtDoubleLessThan[c4].setText(Double.toString(v));
                    }
                    ++c4;
                }
            }
            if ((dl = s.Dgreaterthan) != null) {
                int c5 = 0;
                while (c5 < 10) {
                    v = dl.get(PostTemplate.getDoubleKey(c5));
                    if (v != null) {
                        this.chckbxDoubleGreaterThan[c5].setSelected(true);
                        this.txtDoubleGreaterThan[c5].setText(Double.toString(v));
                    }
                    ++c5;
                }
            }
            if (s.Directref != null) {
                this.lblPrimaryReference.setText(s.Directref.toString().substring(0, 20));
                this.PrimaryReference = s.Directref;
            }
            if (s.Excludefilesreferencedbyothers0) {
                this.chckbxRemoveRef[0].setSelected(true);
            }
            if (s.Excludefilesreferencedbyothers1) {
                this.chckbxRemoveRef[1].setSelected(true);
            }
            if (s.Excludefilesreferencedbyothers2) {
                this.chckbxRemoveRef[2].setSelected(true);
            }
            if (s.Includefileswithreferences0) {
                this.chckbxAddRef[0].setSelected(true);
            }
            if (s.Includefileswithreferences1) {
                this.chckbxAddRef[1].setSelected(true);
            }
            if (s.Includefileswithreferences2) {
                this.chckbxAddRef[2].setSelected(true);
            }
            if (s.Refs0 != null) {
                this.lblReference[0].setText(s.Refs0.toString().substring(0, 20));
                this.References[0] = s.Refs0;
            }
            if (s.Refs1 != null) {
                this.lblReference[1].setText(s.Refs1.toString().substring(0, 20));
                this.References[1] = s.Refs1;
            }
            if (s.Refs2 != null) {
                this.lblReference[2].setText(s.Refs2.toString().substring(0, 20));
                this.References[2] = s.Refs2;
            }
            if (s.DaysBack != null) {
                s.Fromdate = null;
                this.textDaysBackwards.setText(Integer.toString(s.DaysBack));
                this.chckbxUseDaysBackwards.setSelected(true);
            } else {
                this.chckbxUseDaysBackwards.setSelected(false);
            }
            if (s.Fromdate != null) {
                this.FromDate.setDate(s.Fromdate);
                this.chckbxUseFromDate.setSelected(true);
            } else {
                this.chckbxUseFromDate.setSelected(false);
            }
            if (s.Todate != null) {
                this.ToDate.setDate(s.Todate);
                this.chckbxUseToDate.setSelected(true);
            } else {
                this.chckbxUseToDate.setSelected(false);
            }
        }
    }

    private SearchQuery buildQuery() {
        if (this.SelectedTemplate != null) {
            long v2;
            SearchQuery sq = new SearchQuery();
            try {
                sq.MaxResults = Integer.valueOf(this.textMaxResults.getText());
            }
            catch (Exception e) {
                sq.MaxResults = 1000;
            }
            if (this.chckbxUseFromDate.isSelected()) {
                sq.Fromdate = this.FromDate.getDate();
            }
            if (this.chckbxUseToDate.isSelected()) {
                sq.Todate = this.ToDate.getDate();
            }
            if (this.chckbxUseDaysBackwards.isSelected()) {
                try {
                    sq.DaysBack = Integer.valueOf(this.textDaysBackwards.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.SelectedTemplate.getDigest() != null) {
                sq.UseTemplate = new BBytes(this.SelectedTemplate.getDigest());
            }
            if (this.SelectedTemplate.getNetworkId() != null) {
                sq.Network = new BBytes(this.SelectedTemplate.getNetworkId());
            }
            sq.QueryName = this.textQueryName.getText();
            if (this.chckbxUseGeneral.isSelected()) {
                sq.Generalterms = this.textGeneral.getText();
            }
            if (this.chckbxUseSubject.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseCoreImpl.POST_SUBJECT, this.textSubject.getText());
            }
            if (this.chckbxUseFileName.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseCoreImpl.POST_FILENAME, this.textFileName.getText());
            }
            if (this.chckbxUseComment.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseCoreImpl.POST_COMMENT, this.textComment.getText());
            }
            if (this.chckbxUseMinRank.isSelected()) {
                try {
                    long minr = Long.valueOf(this.textMinRank.getText());
                    sq.Minpeerrank = minr;
                }
                catch (Exception minr) {
                    // empty catch block
                }
            }
            int cnt = 0;
            while (cnt < 8) {
                if (this.chckbxUseString[cnt] != null && this.chckbxUseString[cnt].isSelected()) {
                    if (sq.Searchterms == null) {
                        sq.Searchterms = new HashMap<String, String>();
                    }
                    sq.Searchterms.put(PostTemplate.getStringKey(cnt), this.textString[cnt].getText());
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxBool[cnt] != null && this.chckbxBool[cnt].isSelected()) {
                    if (sq.Andtruebools == null) {
                        sq.Andtruebools = new HashSet<String>();
                    }
                    sq.Andtruebools.add(PostTemplate.getBoolKey(cnt));
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxNumLessThan[cnt] != null && this.chckbxNumLessThan[cnt].isSelected()) {
                    if (sq.Lessthan == null) {
                        sq.Lessthan = new HashMap<String, Long>();
                    }
                    try {
                        v2 = Long.valueOf(this.txtNumLessThan[cnt].getText());
                        sq.Lessthan.put(PostTemplate.getNumKey(cnt), v2);
                    }
                    catch (Exception v2) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxNumGreaterThan[cnt] != null && this.chckbxNumGreaterThan[cnt].isSelected()) {
                    if (sq.Greaterthan == null) {
                        sq.Greaterthan = new HashMap<String, Long>();
                    }
                    try {
                        v2 = Long.valueOf(this.txtNumGreaterThan[cnt].getText());
                        sq.Greaterthan.put(PostTemplate.getNumKey(cnt), v2);
                    }
                    catch (Exception v3) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxDoubleLessThan[cnt] != null && this.chckbxDoubleLessThan[cnt].isSelected()) {
                    if (sq.Dlessthan == null) {
                        sq.Dlessthan = new HashMap<String, Double>();
                    }
                    try {
                        double v4 = Double.valueOf(this.txtDoubleLessThan[cnt].getText());
                        sq.Dlessthan.put(PostTemplate.getDoubleKey(cnt), v4);
                    }
                    catch (Exception v4) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxDoubleGreaterThan[cnt] != null && this.chckbxDoubleGreaterThan[cnt].isSelected()) {
                    if (sq.Dgreaterthan == null) {
                        sq.Dgreaterthan = new HashMap<String, Double>();
                    }
                    try {
                        double v5 = Double.valueOf(this.txtDoubleGreaterThan[cnt].getText());
                        sq.Dgreaterthan.put(PostTemplate.getDoubleKey(cnt), v5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            if (this.PrimaryReference != null) {
                sq.Directref = new BBytes(this.PrimaryReference);
            }
            cnt = 0;
            while (cnt < 3) {
                if (this.References[cnt] != null) {
                    if (cnt == 0) {
                        sq.Refs0 = new BBytes(this.References[cnt]);
                    }
                    if (cnt == 1) {
                        sq.Refs1 = new BBytes(this.References[cnt]);
                    }
                    if (cnt == 2) {
                        sq.Refs2 = new BBytes(this.References[cnt]);
                    }
                }
                if (this.chckbxRemoveRef[cnt] != null && this.chckbxRemoveRef[cnt].isSelected()) {
                    if (cnt == 0) {
                        sq.Excludefilesreferencedbyothers0 = true;
                    }
                    if (cnt == 1) {
                        sq.Excludefilesreferencedbyothers1 = true;
                    }
                    if (cnt == 2) {
                        sq.Excludefilesreferencedbyothers2 = true;
                    }
                }
                if (this.chckbxAddRef[cnt] != null && this.chckbxAddRef[cnt].isSelected()) {
                    if (cnt == 0) {
                        sq.Includefileswithreferences0 = true;
                    }
                    if (cnt == 1) {
                        sq.Includefileswithreferences1 = true;
                    }
                    if (cnt == 2) {
                        sq.Includefileswithreferences2 = true;
                    }
                }
                ++cnt;
            }
            return sq;
        }
        return null;
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        this.SelectedNetwork = network;
        this.lblGroupSel.setText(network.getNetwork().getTitleSig());
        this.QueryTableModel.setSelectedNetwork(network, auth);
        this.TemplateTableModel.setSelectedNetwork(network, auth);
        this.SelectedTemplate = null;
        this.buildSearchPane();
    }

    public NewPostDialog getNewPostDialog() {
        return this.NewPostDialog;
    }

    public void setNewPostDialog(NewPostDialog newPostDialog) {
        this.NewPostDialog = newPostDialog;
    }

    public void setPrimaryReference(LocalPost lp) {
        if (lp != null) {
            this.PrimaryReference = lp.getPost().getFileReferenceDigest();
            if (lp.getPost().getMessage() instanceof PostMessage) {
                PostMessage pm = (PostMessage)lp.getPost().getMessage();
                this.lblPrimaryReference.setText(String.valueOf(pm.getFileName()) + " (" + this.PrimaryReference.toString().substring(0, 20) + ")");
            }
        }
    }

    public void setReference(int num, LocalPost lp) {
        this.References[num] = lp.getPost().getFileReferenceDigest();
        if (this.References[num] != null) {
            StringBuilder sb = new StringBuilder();
            if (lp.getPost().getMessage() instanceof PostMessage) {
                PostMessage pm = (PostMessage)lp.getPost().getMessage();
                sb.append(pm.getFileName());
                sb.append(" ");
            }
            sb.append("(");
            sb.append(this.References[num].toString().substring(0, 20));
            sb.append(")");
            this.lblReference[num].setText(sb.toString());
        }
    }

    public void setPostReference(int num, LocalPost lp) {
        this.NewPostDialog.setReference(num, lp);
    }
}

