/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.ui.Replier;
import org.ourfilesystem.utilities.BBytes;

public class NewPublicPostDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static String SUBJECTBODY = "<<SUBJECT<>BODY>>";
    private CoreUserInterface CoreUser;
    private BBytes NetworkId;
    private JTextField textSubject;
    private JTextArea textMessage;
    private JLabel lblNetwork;
    private JLabel lblPeer;
    private JLabel lblDate;
    private JButton button;
    private boolean Edit;

    public NewPublicPostDialog(CoreUserInterface core) {
        this.CoreUser = core;
        this.setTitle("New Public Post");
        this.setBounds(100, 100, 400, 300);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][grow][]"));
        JLabel lblPeer0 = new JLabel("Peer:");
        this.getContentPane().add((Component)lblPeer0, "cell 0 0,alignx trailing");
        this.lblPeer = new JLabel("none");
        this.getContentPane().add((Component)this.lblPeer, "cell 1 0");
        JLabel lblRelatedToNetwork = new JLabel("Related to group:");
        this.getContentPane().add((Component)lblRelatedToNetwork, "cell 0 1,alignx trailing");
        this.lblNetwork = new JLabel("none");
        this.getContentPane().add((Component)this.lblNetwork, "flowx,cell 1 1,growx");
        JLabel lblDate0 = new JLabel("Date:");
        this.getContentPane().add((Component)lblDate0, "cell 0 2,alignx trailing");
        this.lblDate = new JLabel("none");
        this.getContentPane().add((Component)this.lblDate, "cell 1 2");
        JLabel lblSubject = new JLabel("Subject");
        this.getContentPane().add((Component)lblSubject, "cell 0 3,alignx trailing");
        this.textSubject = new JTextField();
        this.getContentPane().add((Component)this.textSubject, "cell 1 3,growx");
        this.textSubject.setColumns(10);
        JLabel lblMessage = new JLabel("Message");
        this.getContentPane().add((Component)lblMessage, "cell 0 4,alignx trailing");
        JScrollPane scrl = new JScrollPane();
        this.textMessage = new JTextArea();
        scrl.setViewportView(this.textMessage);
        this.getContentPane().add((Component)scrl, "cell 1 4,grow");
        this.button = new JButton("Post");
        this.getContentPane().add((Component)this.button, "flowx,cell 1 5");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (NewPublicPostDialog.this.Edit) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(NewPublicPostDialog.this.textSubject.getText());
                    sb.append(SUBJECTBODY);
                    sb.append(NewPublicPostDialog.this.textMessage.getText());
                    NewPublicPostDialog.this.CoreUser.addLocalPublicPost(NewPublicPostDialog.this.NetworkId, sb.toString(), null);
                    NewPublicPostDialog.this.setVisible(false);
                } else {
                    NewPublicPostDialog.this.reply();
                }
            }
        });
        JButton btnCancel = new JButton("Cancel");
        this.getContentPane().add((Component)btnCancel, "cell 1 5");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPublicPostDialog.this.setVisible(false);
            }
        });
        JButton btnNewButton = new JButton("Clear Network");
        this.getContentPane().add((Component)btnNewButton, "cell 1 1");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPublicPostDialog.this.lblNetwork.setText("none");
                NewPublicPostDialog.this.NetworkId = null;
            }
        });
    }

    private void setSubjMsg(String m) {
        String[] parts = m.split(SUBJECTBODY);
        if (parts.length > 0) {
            this.textSubject.setText(parts[0]);
        }
        if (parts.length > 1) {
            this.textMessage.setText(parts[1]);
        }
    }

    public void showDialog(LocalNetwork ln) {
        this.textSubject.setText("");
        this.textSubject.setEditable(true);
        this.textMessage.setText("");
        this.textMessage.setEditable(true);
        this.lblPeer.setText("you");
        this.lblDate.setText(new Date().toString());
        if (ln != null) {
            this.lblNetwork.setText(ln.getNetwork().getTitleSig());
            this.NetworkId = ln.getNetwork().getSignature().getDigest();
        } else {
            this.lblNetwork.setText("");
            this.NetworkId = null;
        }
        this.button.setText("Send");
        this.Edit = true;
        this.setVisible(true);
    }

    public void viewMessage(LocalPublicPost lp) {
        if (lp.isPrivateMessage()) {
            String m = (String)lp.getDecodedMessage();
            this.setSubjMsg(m);
        } else if (lp.getPublicPost().isEncrypted()) {
            this.textSubject.setText("*Encrypted for someone else*");
            this.textMessage.setText("*Encrypted for someone else*");
        } else {
            String m = (String)lp.getPublicPost().getMessage();
            this.setSubjMsg(m);
        }
        this.textSubject.setEditable(false);
        this.textMessage.setEditable(false);
        this.lblPeer.setText(lp.getCreator());
        this.lblNetwork.setText(lp.getNetworkTitle());
        this.lblDate.setText(lp.getLocalDate().toString());
        this.NetworkId = lp.getPublicPost().getNetworkId();
        this.button.setText("Reply");
        this.Edit = false;
        this.setVisible(true);
    }

    public void replyToMessage(LocalPublicPost lp) {
        this.viewMessage(lp);
        this.reply();
    }

    private void reply() {
        this.textSubject.setText(Replier.getSubjectReply(this.textSubject.getText()));
        this.textMessage.setText(Replier.getBodyReply(this.textMessage.getText(), this.lblPeer.getText()));
        this.textSubject.setEditable(true);
        this.textMessage.setEditable(true);
        this.lblPeer.setText("you");
        this.lblDate.setText(new Date().toString());
        this.button.setText("Send");
        this.Edit = true;
    }
}

