/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthorization;

public class NetworkTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface Networks;
    private boolean SimpleMode;
    private String[] Columnnames = new String[]{"Title", "Description", "Creator", "Your Authorization"};

    @Override
    public String getColumnName(int col) {
        if (this.SimpleMode) {
            return "Groups";
        }
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        if (this.SimpleMode) {
            return 1;
        }
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Networks != null) {
            return this.Networks.size();
        }
        return 0;
    }

    public synchronized LocalNetwork getNetwork(int r) {
        if (this.Networks != null && r < this.Networks.size()) {
            return (LocalNetwork)this.Networks.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalNetwork ln = this.getNetwork(r);
        if (ln != null) {
            if (this.SimpleMode) {
                return ln.getNetwork().getTitleSig();
            }
            Network n = ln.getNetwork();
            if (c == 0) {
                return n.getTitleSig();
            }
            if (c == 1) {
                return n.getDescription();
            }
            if (c == 2) {
                return ln.getCreator();
            }
            if (c == 3) {
                if (ln.isAuthorized()) {
                    if (ln.getAuthorization() == NetworkAuthorization.NOSIGN) {
                        return "Authorized";
                    }
                    if (ln.getAuthorization() == NetworkAuthorization.CANSIGN) {
                        return "Grant Authorized";
                    }
                    if (ln.getAuthorization() == NetworkAuthorization.CANGIVESIGNAUTH) {
                        return "Super Authorized";
                    }
                } else {
                    return "";
                }
            }
        }
        return null;
    }

    public synchronized void setNetworks(QueryResultsInterface lst) {
        if (this.Networks != null) {
            this.Networks.Close();
        }
        this.Networks = lst;
        this.fireTableDataChanged();
    }

    public boolean isSimpleMode() {
        return this.SimpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.SimpleMode = simpleMode;
    }
}

