/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.ui.AuthorizationPanel;
import org.ourfilesystem.ui.ConnectionPanel;
import org.ourfilesystem.ui.FileStatusPanel;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkPanel;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.NewPublicPostDialog;
import org.ourfilesystem.ui.PeerIdentityPanel;
import org.ourfilesystem.ui.PeerPanel;
import org.ourfilesystem.ui.PostPanel;
import org.ourfilesystem.ui.PrivatePanel;
import org.ourfilesystem.ui.PublicPostPanel;
import org.ourfilesystem.ui.ViewPeerDialog;

public class Gui {
    private Main Main;
    private List<NetworkSelectInterface> NetworkListeners;
    private NewPeerMessageDialog NewPeerMessageDialog;
    private NewPublicPostDialog NewPublicMessageDialog;

    public Gui(Main m) {
        this.Main = m;
        this.NetworkListeners = new LinkedList<NetworkSelectInterface>();
        this.NewPublicMessageDialog = new NewPublicPostDialog(this.Main.getCoreUser());
        this.NewPeerMessageDialog = new NewPeerMessageDialog(this.Main.getCoreUser());
        ViewPeerDialog viewpeerdialog = new ViewPeerDialog(this.NewPeerMessageDialog);
        JFrame frame = new JFrame("OurFileSystem");
        frame = new JFrame();
        frame.setBounds(100, 100, 980, 700);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        frame.getContentPane().add(tabbedPane);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("resources/ofs2_wiki.png"));
            frame.setIconImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PublicPostPanel pubpost = new PublicPostPanel(this.Main);
        pubpost.setDialog(this.NewPublicMessageDialog);
        pubpost.setPeerDialog(viewpeerdialog);
        pubpost.setPeerMsgDialog(this.NewPeerMessageDialog);
        NetworkPanel netpan = new NetworkPanel(this.Main);
        netpan.setMessageDialog(this.NewPeerMessageDialog);
        netpan.setPublicMessageDialog(this.NewPublicMessageDialog);
        netpan.setPeerDialog(viewpeerdialog);
        AuthorizationPanel authpan = new AuthorizationPanel(this.Main);
        authpan.setMessageDialog(this.NewPeerMessageDialog);
        authpan.setPeerDialog(viewpeerdialog);
        PeerPanel peerpan = new PeerPanel(this.Main);
        peerpan.setPeerMessageDialog(this.NewPeerMessageDialog);
        peerpan.setPeerDialog(viewpeerdialog);
        PostPanel postpan = new PostPanel(this.Main);
        postpan.setMessageDialog(this.NewPeerMessageDialog);
        postpan.setPeerDialog(viewpeerdialog);
        PrivatePanel privpan = new PrivatePanel(this.Main);
        privpan.setDialog(this.NewPeerMessageDialog);
        privpan.setPeerDialog(viewpeerdialog);
        this.addNetworkSelectListener(netpan);
        this.addNetworkSelectListener(peerpan);
        this.addNetworkSelectListener(postpan);
        this.addNetworkSelectListener(authpan);
        tabbedPane.add("Settings", new PeerIdentityPanel(this.Main));
        tabbedPane.add("Peers", peerpan);
        tabbedPane.add("Public Messages", pubpost);
        tabbedPane.add("Private Messages", privpan);
        tabbedPane.add("Groups", netpan);
        tabbedPane.add("Authorizations", authpan);
        tabbedPane.add("Posts", postpan);
        tabbedPane.add("Connections", new ConnectionPanel(this.Main));
        tabbedPane.add("Files", new FileStatusPanel(this.Main));
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkSelectListener(NetworkSelectInterface i) {
        List<NetworkSelectInterface> list = this.NetworkListeners;
        synchronized (list) {
            this.NetworkListeners.add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        LinkedList<NetworkSelectInterface> r = new LinkedList<NetworkSelectInterface>();
        List<NetworkSelectInterface> list = this.NetworkListeners;
        synchronized (list) {
            r.addAll(this.NetworkListeners);
        }
        for (NetworkSelectInterface n : r) {
            n.setSelectedNetwork(network, auth);
        }
    }

    public NewPeerMessageDialog getNewPeerMessageDialog() {
        return this.NewPeerMessageDialog;
    }

    public NewPublicPostDialog getNewPublicMessageDialog() {
        return this.NewPublicMessageDialog;
    }
}

