/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.filehandler.FileStatusEventInterface;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.utilities.HumReadFileSize;

public class FileStatusTableModel
extends AbstractTableModel
implements FileStatusEventInterface {
    private static final long serialVersionUID = 1L;
    public static final Logger Log = Logger.getLogger(FileStatusTableModel.class.getName());
    private HashMap<File, FileStatus> StatusList;
    private List<File> Files;
    private List<File> Completed;
    private Main Mn;
    private boolean HideCompleted;
    private String[] Columnnames = new String[]{"File", "Digest", "Progress", "Pieces downloaded", "Pieces known", "Total pieces", "Size", "Priority"};

    public FileStatusTableModel(Main m) {
        this.Mn = m;
        this.StatusList = new HashMap();
        this.Files = new LinkedList<File>();
        this.Completed = new LinkedList<File>();
        this.HideCompleted = true;
        List<FileStatus> fl = this.Mn.getCoreDB().getFileStatusList();
        for (FileStatus f : fl) {
            this.fireStatusEvent(f);
        }
    }

    public void insertProgressIntoTable(JTable t) {
        TableColumn col = t.getColumnModel().getColumn(2);
        col.setCellRenderer(new ProgressCellRenderer());
    }

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 2) {
            return FileStatus.class;
        }
        if (col == 3 || col == 4 || col == 5) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    public synchronized void removeFile(File f) {
        this.Files.remove(f);
        this.Completed.remove(f);
        this.StatusList.remove(f);
        this.Mn.getFileHandler().removeFile(f);
        this.fireTableDataChanged();
    }

    @Override
    public synchronized int getRowCount() {
        if (!this.HideCompleted) {
            return this.Files.size() + this.Completed.size();
        }
        return this.Files.size();
    }

    public synchronized FileStatus getFileStatus(int r) {
        if (r < this.Files.size()) {
            File f = this.Files.get(r);
            return this.StatusList.get(f);
        }
        if ((r -= this.Files.size()) < this.Completed.size()) {
            File f = this.Completed.get(r);
            return this.StatusList.get(f);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        FileStatus s = this.getFileStatus(r);
        if (s != null) {
            if (c == 0) {
                return s.getFile().getPath();
            }
            if (c == 1) {
                return s.getCompleteDigest().toString().substring(0, 10);
            }
            if (c == 2) {
                return s;
            }
            if (c == 3) {
                return s.getNumberPartsPresent();
            }
            if (c == 4) {
                return s.getPiecePostsFound();
            }
            if (c == 5) {
                return s.getNumberParts();
            }
            if (c == 6) {
                return HumReadFileSize.fileSize(s.getTotalFileSize());
            }
            if (c == 7) {
                return Long.toString(s.getPriority());
            }
        }
        return null;
    }

    private int findCurrentIndex(File fs) {
        int idx = this.Files.indexOf(fs);
        if (idx != -1) {
            return idx;
        }
        idx = this.Completed.indexOf(fs);
        if (idx != -1) {
            return this.Files.size() + idx;
        }
        return -1;
    }

    @Override
    public synchronized void fireStatusEvent(FileStatus nfs) {
        final FileStatus fs = nfs;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileStatusTableModel.this.StatusList.put(fs.getFile(), fs);
                int oldidx = FileStatusTableModel.this.findCurrentIndex(fs.getFile());
                int oldsize = FileStatusTableModel.this.getRowCount();
                if (fs.getNumberPartsPresent() == fs.getNumberParts()) {
                    if (!FileStatusTableModel.this.Completed.contains(fs.getFile())) {
                        FileStatusTableModel.this.Completed.add(fs.getFile());
                    }
                    FileStatusTableModel.this.Files.remove(fs.getFile());
                } else {
                    if (!FileStatusTableModel.this.Files.contains(fs.getFile())) {
                        FileStatusTableModel.this.Files.add(fs.getFile());
                    }
                    FileStatusTableModel.this.Completed.remove(fs.getFile());
                }
                int newidx = FileStatusTableModel.this.findCurrentIndex(fs.getFile());
                int newsize = FileStatusTableModel.this.getRowCount();
                if (oldidx == newidx && oldsize == newsize) {
                    if (newidx < newsize) {
                        FileStatusTableModel.this.fireTableRowsUpdated(newidx, newidx);
                    }
                } else {
                    FileStatusTableModel.this.fireTableDataChanged();
                }
            }
        });
    }

    public synchronized void setHideCompleted(boolean hide) {
        this.HideCompleted = hide;
        this.fireTableDataChanged();
    }

    public class ProgressCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            if (arg1 instanceof FileStatus) {
                FileStatus dl = (FileStatus)arg1;
                Log.info("File status: " + dl.getNumberPartsPresent() + " / " + dl.getNumberParts());
                if (dl.getNumberParts() == 0L) {
                    this.setIndeterminate(true);
                } else {
                    int tot = (int)Math.min(dl.getNumberParts(), Integer.MAX_VALUE);
                    int prg = (int)Math.min(dl.getNumberPartsPresent(), Integer.MAX_VALUE);
                    this.setMaximum(tot);
                    this.setValue(prg);
                    this.setIndeterminate(false);
                }
                return this;
            }
            return null;
        }
    }
}

