/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.security;

import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.security.CryptoComInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;

public class CryptoComImpl
implements CryptoComInterface {
    @Override
    public Object getChallenge() {
        byte[] b = new byte[32];
        SecurityTools.Random.nextBytes(b);
        return new BBytes(b);
    }

    @Override
    public boolean verifyChallenge(Object sent, SignedDigest in, Peer p) {
        BBytes clng = (BBytes)sent;
        return SecurityTools.verifySignedDigest(in, clng.getBytes(), p.getPeerKeys());
    }

    @Override
    public SignedDigest signChallenge(Object challenge, BBytes peerid, KeySet mykeys) {
        BBytes bb = (BBytes)challenge;
        return SecurityTools.signDigest(bb.getBytes(), peerid, (RSAPrivateCrtKeyParameters)mykeys.getPrivateSigningKey());
    }

    @Override
    public boolean verifyIdentity(Peer p) {
        return SecurityTools.verifyIdentity(p);
    }
}

