/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import com.db4o.ObjectContainer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.QueryResultsInterface;

public abstract class TopDocsQueryResultsAbstract
implements QueryResultsInterface {
    private ObjectContainer DB;
    private TopDocs CurDocs;
    private IndexSearcher Searcher;
    private DirectoryReader Reader;
    private List<Integer> Removed;
    private List<Object> AddedObjs;

    public TopDocsQueryResultsAbstract(TopDocs t, IndexSearcher s, DirectoryReader reader, ObjectContainer d) {
        this.DB = d;
        this.CurDocs = t;
        this.Searcher = s;
        this.Reader = reader;
        this.Removed = new LinkedList<Integer>();
        this.AddedObjs = new LinkedList<Object>();
    }

    @Override
    public void Close() {
        try {
            this.Reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int size() {
        return this.CurDocs.scoreDocs.length - this.Removed.size() + this.AddedObjs.size();
    }

    public abstract Object getHits(int var1);

    @Override
    public Object get(int i) {
        if ((i = this.translateIndex(i)) < this.CurDocs.scoreDocs.length) {
            return this.getHits(i);
        }
        if ((i -= this.CurDocs.scoreDocs.length) < this.AddedObjs.size()) {
            return this.AddedObjs.get(i);
        }
        return null;
    }

    public synchronized int translateIndex(int i) {
        int idxadder = 0;
        for (int rv : this.Removed) {
            if (i < rv - idxadder) {
                return i + idxadder;
            }
            ++idxadder;
        }
        return i + idxadder;
    }

    @Override
    public synchronized void remove(int i) {
        if (i < this.size()) {
            int newremove = this.translateIndex(i);
            int idx = 0;
            for (int tv : this.Removed) {
                if (tv > newremove) break;
                ++idx;
            }
            this.Removed.add(idx, newremove);
        }
    }

    public ObjectContainer getDB() {
        return this.DB;
    }

    public TopDocs getCurDocs() {
        return this.CurDocs;
    }

    public IndexSearcher getSearcher() {
        return this.Searcher;
    }

    public DirectoryReader getReader() {
        return this.Reader;
    }

    public List<Integer> getRemoved() {
        return this.Removed;
    }

    @Override
    public void add(Object obj) {
        this.AddedObjs.add(obj);
    }
}

