/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.NumericConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.ourfilesystem.db.DataBaseCoreImpl;
import org.ourfilesystem.db.DataBaseQueryInterface;
import org.ourfilesystem.db.EmptyQueryResults;
import org.ourfilesystem.db.NetworkAuthQueryResultsImpl;
import org.ourfilesystem.db.NetworkAuthQueryResultsObjectSetImpl;
import org.ourfilesystem.db.NetworkQueryResultsImpl;
import org.ourfilesystem.db.NetworkQueryResultsObjectSetImpl;
import org.ourfilesystem.db.OFSAnalyzer;
import org.ourfilesystem.db.PeerQueryResultsImpl;
import org.ourfilesystem.db.PeerQueryResultsObjectSetImpl;
import org.ourfilesystem.db.PostsQueryResultsImpl;
import org.ourfilesystem.db.PostsQueryResultsObjectSetImpl;
import org.ourfilesystem.db.PublicPostQueryResultsImpl;
import org.ourfilesystem.db.PublicPostQueryResultsObjectSetImpl;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.utilities.BBytes;

public class DataBaseQueryImpl
implements DataBaseQueryInterface {
    public static final Logger Log = Logger.getLogger(DataBaseQueryImpl.class.getName());
    private String BaseDir;
    private StandardQueryParser Parser;
    private ObjectContainer DB;

    public DataBaseQueryImpl(String basedir, ObjectContainer db) throws IOException {
        this.DB = db;
        this.BaseDir = basedir;
        this.Parser = new StandardQueryParser((Analyzer)new OFSAnalyzer(Version.LUCENE_44));
        HashMap<String, NumericConfig> numconfig = new HashMap<String, NumericConfig>();
        NumericConfig nc = new NumericConfig(6, (NumberFormat)new DecimalFormat(), FieldType.NumericType.LONG);
        NumericConfig dc = new NumericConfig(6, (NumberFormat)new DecimalFormat(), FieldType.NumericType.DOUBLE);
        numconfig.put(DataBaseCoreImpl.PUBLIC_POST_DATE, nc);
        numconfig.put(DataBaseCoreImpl.PUBLIC_POST_ID0, nc);
        numconfig.put(DataBaseCoreImpl.PUBLIC_POST_ID1, nc);
        numconfig.put(DataBaseCoreImpl.PUBLIC_POST_PEERID0, nc);
        numconfig.put(DataBaseCoreImpl.PUBLIC_POST_PEERID1, nc);
        numconfig.put(DataBaseCoreImpl.NETWORK_DATE, nc);
        numconfig.put(DataBaseCoreImpl.NETWORK_ID0, nc);
        numconfig.put(DataBaseCoreImpl.NETWORK_ID1, nc);
        numconfig.put(DataBaseCoreImpl.NETWORK_PEERID0, nc);
        numconfig.put(DataBaseCoreImpl.NETWORK_PEERID1, nc);
        numconfig.put(DataBaseCoreImpl.PEER_DATE, nc);
        numconfig.put(DataBaseCoreImpl.PEER_ID0, nc);
        numconfig.put(DataBaseCoreImpl.PEER_ID1, nc);
        numconfig.put(DataBaseCoreImpl.POST_NETID0, nc);
        numconfig.put(DataBaseCoreImpl.POST_NETID1, nc);
        numconfig.put(DataBaseCoreImpl.POST_DATE, nc);
        numconfig.put(DataBaseCoreImpl.POST_PEERID0, nc);
        numconfig.put(DataBaseCoreImpl.POST_PEERID1, nc);
        numconfig.put(DataBaseCoreImpl.POST_ID0, nc);
        numconfig.put(DataBaseCoreImpl.POST_ID1, nc);
        numconfig.put(DataBaseCoreImpl.POST_FILEREF0, nc);
        numconfig.put(DataBaseCoreImpl.POST_FILEREF1, nc);
        numconfig.put(DataBaseCoreImpl.POST_REF00, nc);
        numconfig.put(DataBaseCoreImpl.POST_REF01, nc);
        numconfig.put(DataBaseCoreImpl.POST_REF10, nc);
        numconfig.put(DataBaseCoreImpl.POST_REF11, nc);
        numconfig.put(DataBaseCoreImpl.POST_REF20, nc);
        numconfig.put(DataBaseCoreImpl.POST_REF21, nc);
        numconfig.put(DataBaseCoreImpl.POST_USETEMPLATE0, nc);
        numconfig.put(DataBaseCoreImpl.POST_USETEMPLATE1, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM0, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM1, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM2, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM3, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM4, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM5, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM6, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM7, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM8, nc);
        numconfig.put(DataBaseCoreImpl.POST_NUM9, nc);
        numconfig.put(DataBaseCoreImpl.POST_PEERRANK, nc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE0, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE1, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE2, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE3, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE4, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE5, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE6, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE7, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE8, dc);
        numconfig.put(DataBaseCoreImpl.POST_DOUBLE9, dc);
        this.Parser.setNumericConfigMap(numconfig);
    }

    @Override
    public void Close() {
    }

    @Override
    public QueryResultsInterface searchPosts(SearchQuery srch) {
        try {
            String qstring = srch.buildQueryString();
            Matcher m = Pattern.compile("\\S+").matcher(qstring);
            if (!m.find()) {
                Query q = this.DB.query();
                q.constrain(LocalPost.class);
                String t0 = srch.getLocalPostSort();
                String t1 = srch.getPostSort();
                String t2 = srch.getPostMessageSort();
                String t3 = srch.getPostMessageSubSort();
                if (t0 != null) {
                    if (t1 != null) {
                        if (t2 != null) {
                            if (t3 != null) {
                                if (srch.SortReverse) {
                                    q.descend(t0).descend(t1).descend(t2).descend(t3).orderDescending();
                                } else {
                                    q.descend(t0).descend(t1).descend(t2).descend(t3).orderAscending();
                                }
                            } else if (srch.SortReverse) {
                                q.descend(t0).descend(t1).descend(t2).orderDescending();
                            } else {
                                q.descend(t0).descend(t1).descend(t2).orderAscending();
                            }
                        } else if (srch.SortReverse) {
                            q.descend(t0).descend(t1).orderDescending();
                        } else {
                            q.descend(t0).descend(t1).orderAscending();
                        }
                    } else if (srch.SortReverse) {
                        q.descend(t0).orderDescending();
                    } else {
                        q.descend(t0).orderAscending();
                    }
                }
                ObjectSet osa = q.execute();
                return this.removeAddMarked(null, null, srch, new PostsQueryResultsObjectSetImpl((ObjectSet<LocalPost>)osa, srch.MaxResults));
            }
            File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseCoreImpl.INDEX_DIR);
            SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
            DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            Log.info("qstring: " + qstring);
            org.apache.lucene.search.Query q = this.Parser.parse(qstring, "comment");
            Sort s = srch.getSort();
            TopDocs d = null;
            if (s != null) {
                d = searcher.search(q, null, srch.MaxResults, s);
                Log.info("totalHits: " + d.totalHits);
            } else {
                d = searcher.search(q, srch.MaxResults);
                Log.info("totalHits: " + d.totalHits);
            }
            return this.removeAddMarked(searcher, reader, srch, new PostsQueryResultsImpl(d, searcher, reader, this.DB));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EmptyQueryResults();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean searchToRemove(IndexSearcher searcher, SearchQuery sq0, Set<Long> removelist, int refnum) {
        String qstring = sq0.buildQueryString();
        try {
            org.apache.lucene.search.Query q = this.Parser.parse(qstring, "comment");
            TopDocs d = searcher.search(q, Integer.MAX_VALUE);
            int c0 = 0;
            while (true) {
                long pid0;
                long id0;
                if (c0 >= d.scoreDocs.length) {
                    return false;
                }
                ScoreDoc sd = d.scoreDocs[c0];
                Document doc = searcher.doc(sd.doc);
                StoredField sf0 = null;
                StoredField prf = (StoredField)doc.getField(DataBaseCoreImpl.POST_FILEREF0);
                if (refnum == 0) {
                    sf0 = (StoredField)doc.getField(DataBaseCoreImpl.POST_REF00);
                }
                if (refnum == 1) {
                    sf0 = (StoredField)doc.getField(DataBaseCoreImpl.POST_REF10);
                }
                if (refnum == 2) {
                    sf0 = (StoredField)doc.getField(DataBaseCoreImpl.POST_REF20);
                }
                if (sf0 != null && prf != null && (id0 = sf0.numericValue().longValue()) != (pid0 = prf.numericValue().longValue()) && !removelist.contains(id0)) {
                    return true;
                }
                ++c0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void addNewRefs(IndexSearcher searcher, DirectoryReader reader, SearchQuery sq0, QueryResultsInterface qr, Set<Long> existlst) {
        String qstring = sq0.buildQueryString();
        try {
            org.apache.lucene.search.Query q = this.Parser.parse(qstring, "comment");
            TopDocs d = searcher.search(q, Integer.MAX_VALUE);
            PostsQueryResultsImpl nqr = new PostsQueryResultsImpl(d, searcher, reader, this.DB);
            int c = 0;
            while (c < nqr.size()) {
                LocalPost lp = (LocalPost)nqr.get(c);
                long idx0 = lp.getPost().getSignedDigest().getDigest().getIndex0();
                if (!existlst.contains(idx0)) {
                    qr.add(lp);
                    existlst.add(idx0);
                }
                ++c;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private QueryResultsInterface removeAddMarked(IndexSearcher searcher, DirectoryReader reader, SearchQuery sq, QueryResultsInterface qr) {
        try {
            if (sq.Excludefilesreferencedbyothers0 || sq.Excludefilesreferencedbyothers1 || sq.Excludefilesreferencedbyothers2 || sq.Includefileswithreferences0 || sq.Includefileswithreferences1 || sq.Includefileswithreferences2) {
                if (reader == null) {
                    File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseCoreImpl.INDEX_DIR);
                    SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                    reader = DirectoryReader.open((Directory)fsdir);
                }
                if (searcher == null) {
                    searcher = new IndexSearcher((IndexReader)reader);
                }
                HashSet<Long> removelist = new HashSet<Long>();
                HashSet<Long> existlist = new HashSet<Long>();
                int c = 0;
                while (c < qr.size()) {
                    LocalPost lp = (LocalPost)qr.get(c);
                    BBytes chk = lp.getPost().getFileReferenceDigest();
                    long pstid = lp.getPost().getSignedDigest().getDigest().getIndex0();
                    if (!existlist.contains(pstid) && chk != null) {
                        SearchQuery sq0;
                        boolean removed = false;
                        if (removelist.contains(chk.getIndex0())) {
                            removed = true;
                        }
                        if (!removed && sq.Excludefilesreferencedbyothers0) {
                            sq0 = new SearchQuery();
                            sq0.Minpeerrank = sq.Minpeerrank;
                            sq0.Directref = chk;
                            removed = this.searchToRemove(searcher, sq0, removelist, 0);
                        }
                        if (!removed && sq.Excludefilesreferencedbyothers1) {
                            sq0 = new SearchQuery();
                            sq0.Minpeerrank = sq.Minpeerrank;
                            sq0.Directref = chk;
                            removed = this.searchToRemove(searcher, sq0, removelist, 1);
                        }
                        if (!removed && sq.Excludefilesreferencedbyothers2) {
                            sq0 = new SearchQuery();
                            sq0.Minpeerrank = sq.Minpeerrank;
                            sq0.Directref = chk;
                            removed = this.searchToRemove(searcher, sq0, removelist, 2);
                        }
                        if (removed) {
                            qr.remove(c);
                            --c;
                            removelist.add(chk.getIndex0());
                        } else {
                            existlist.add(pstid);
                            if (sq.Includefileswithreferences0) {
                                sq0 = new SearchQuery();
                                sq0.Minpeerrank = sq.Minpeerrank;
                                sq0.Refs0 = chk;
                                this.addNewRefs(searcher, reader, sq0, qr, existlist);
                            }
                            if (sq.Includefileswithreferences1) {
                                sq0 = new SearchQuery();
                                sq0.Minpeerrank = sq.Minpeerrank;
                                sq0.Refs1 = chk;
                                this.addNewRefs(searcher, reader, sq0, qr, existlist);
                            }
                            if (sq.Includefileswithreferences2) {
                                sq0 = new SearchQuery();
                                sq0.Minpeerrank = sq.Minpeerrank;
                                sq0.Refs2 = chk;
                                this.addNewRefs(searcher, reader, sq0, qr, existlist);
                            }
                        }
                    }
                    ++c;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qr;
    }

    @Override
    public void saveSearchQuery(SearchQuery srch) {
        this.DB.store((Object)srch);
    }

    @Override
    public void deleteSearchQuery(SearchQuery srch) {
        this.DB.delete((Object)srch);
    }

    @Override
    public List<SearchQuery> getSearchQuerys() {
        Query q = this.DB.query();
        q.constrain(SearchQuery.class);
        ObjectSet osa = q.execute();
        LinkedList<SearchQuery> r = new LinkedList<SearchQuery>();
        r.addAll((Collection<SearchQuery>)osa);
        return r;
    }

    private Sort getNetworkSort(String col, boolean reverse) {
        if (col != null) {
            if (col.equals(DataBaseCoreImpl.NETWORK_ID0)) {
                return new Sort(new SortField(DataBaseCoreImpl.NETWORK_ID0, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.NETWORK_ID1)) {
                return new Sort(new SortField(DataBaseCoreImpl.NETWORK_ID1, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.NETWORK_PEERID0)) {
                return new Sort(new SortField(DataBaseCoreImpl.NETWORK_PEERID0, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.NETWORK_PEERID1)) {
                return new Sort(new SortField(DataBaseCoreImpl.NETWORK_PEERID1, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.NETWORK_DESCRIPTION)) {
                return new Sort(new SortField(DataBaseCoreImpl.NETWORK_DESCRIPTION, SortField.Type.STRING, reverse));
            }
            if (col.equals(DataBaseCoreImpl.NETWORK_TITLE)) {
                return new Sort(new SortField(DataBaseCoreImpl.NETWORK_TITLE, SortField.Type.STRING, reverse));
            }
        }
        return new Sort(new SortField(DataBaseCoreImpl.NETWORK_DATE, SortField.Type.LONG, reverse));
    }

    @Override
    public QueryResultsInterface searchNetworks(String terms, String sortfield, int max, boolean reverse) {
        Matcher m;
        if (terms != null && (m = Pattern.compile("\\S+").matcher(terms)).find()) {
            try {
                String qt = String.valueOf(DataBaseCoreImpl.NETWORK_TITLE) + ":" + terms + " OR " + DataBaseCoreImpl.NETWORK_DESCRIPTION + ":" + terms;
                File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseCoreImpl.INDEX_DIR);
                SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                Log.info("qstring: " + qt);
                org.apache.lucene.search.Query q = this.Parser.parse(qt, DataBaseCoreImpl.NETWORK_DESCRIPTION);
                TopFieldDocs d = null;
                d = searcher.search(q, null, max, this.getNetworkSort(sortfield, reverse));
                Log.info("totalHits: " + d.totalHits);
                return new NetworkQueryResultsImpl((TopDocs)d, searcher, reader, this.DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Query q = this.DB.query();
        q.constrain(LocalNetwork.class);
        if (sortfield == null) {
            sortfield = DataBaseCoreImpl.NETWORK_DATE;
        }
        if (sortfield.equals(DataBaseCoreImpl.NETWORK_DATE)) {
            if (reverse) {
                q.descend("LocalDate").orderDescending();
            } else {
                q.descend("LocalDate").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.NETWORK_DESCRIPTION)) {
            if (reverse) {
                q.descend("Network").descend("Description").orderDescending();
            } else {
                q.descend("Network").descend("Description").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.NETWORK_ID0)) {
            if (reverse) {
                q.descend("Network").descend("Signature").descend("Digest").descend("Index0").orderDescending();
            } else {
                q.descend("Network").descend("Signature").descend("Digest").descend("Index0").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.NETWORK_ID1)) {
            if (reverse) {
                q.descend("Network").descend("Signature").descend("Digest").descend("Index1").orderDescending();
            } else {
                q.descend("Network").descend("Signature").descend("Digest").descend("Index1").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.NETWORK_PEERID0)) {
            if (reverse) {
                q.descend("Network").descend("Signature").descend("PeerIdentifier").descend("Index0").orderDescending();
            } else {
                q.descend("Network").descend("Signature").descend("PeerIdentifier").descend("Index0").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.NETWORK_PEERID1)) {
            if (reverse) {
                q.descend("Network").descend("Signature").descend("PeerIdentifier").descend("Index1").orderDescending();
            } else {
                q.descend("Network").descend("Signature").descend("PeerIdentifier").descend("Index1").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.NETWORK_TITLE)) {
            if (reverse) {
                q.descend("Networkk").descend("Title").orderDescending();
            } else {
                q.descend("Networkk").descend("Title").orderAscending();
            }
        }
        try {
            ObjectSet osa = q.execute();
            return new NetworkQueryResultsObjectSetImpl((ObjectSet<LocalNetwork>)osa, max);
        }
        catch (Exception exception) {
            return new EmptyQueryResults();
        }
    }

    private Sort getPublicPostSort(String col, boolean reverse) {
        if (col != null) {
            if (col.equals(DataBaseCoreImpl.PUBLIC_POST_ID0)) {
                return new Sort(new SortField(DataBaseCoreImpl.PUBLIC_POST_ID0, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.PUBLIC_POST_ID1)) {
                return new Sort(new SortField(DataBaseCoreImpl.PUBLIC_POST_ID1, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.PUBLIC_POST_PEERID0)) {
                return new Sort(new SortField(DataBaseCoreImpl.PUBLIC_POST_PEERID0, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.PUBLIC_POST_PEERID1)) {
                return new Sort(new SortField(DataBaseCoreImpl.PUBLIC_POST_PEERID1, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.PUBLIC_POST_DECODED_MESSAGE)) {
                return new Sort(new SortField(DataBaseCoreImpl.PUBLIC_POST_DECODED_MESSAGE, SortField.Type.STRING, reverse));
            }
            if (col.equals(DataBaseCoreImpl.PUBLIC_POST_MESSAGE)) {
                return new Sort(new SortField(DataBaseCoreImpl.PUBLIC_POST_MESSAGE, SortField.Type.STRING, reverse));
            }
        }
        return new Sort(new SortField(DataBaseCoreImpl.PUBLIC_POST_DATE, SortField.Type.LONG, reverse));
    }

    @Override
    public QueryResultsInterface searchPublicPosts(String terms, boolean enc, String sortfield, int max, boolean reverse) {
        Matcher m;
        if (terms != null && (m = Pattern.compile("\\S+").matcher(terms)).find()) {
            try {
                String qt = "(" + DataBaseCoreImpl.PUBLIC_POST_DECODED_MESSAGE + ":" + terms + " OR " + DataBaseCoreImpl.PUBLIC_POST_MESSAGE + ":" + terms + ") AND ";
                qt = enc ? String.valueOf(qt) + DataBaseCoreImpl.PUBLIC_POST_PRIVATE + ":1" : String.valueOf(qt) + DataBaseCoreImpl.PUBLIC_POST_ENCRYPTED + ":0";
                File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseCoreImpl.INDEX_DIR);
                SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                Log.info("qstring: " + qt);
                org.apache.lucene.search.Query q = this.Parser.parse(qt, DataBaseCoreImpl.PUBLIC_POST_MESSAGE);
                TopFieldDocs d = null;
                d = searcher.search(q, null, max, this.getPublicPostSort(sortfield, reverse));
                Log.info("totalHits: " + d.totalHits);
                return new PublicPostQueryResultsImpl((TopDocs)d, searcher, reader, this.DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Query q = this.DB.query();
        q.constrain(LocalPublicPost.class);
        if (enc) {
            q.descend("PrivateMessage").constrain((Object)true);
        } else {
            q.descend("PublicPost").descend("Encrypted").constrain((Object)false);
        }
        if (sortfield == null) {
            sortfield = DataBaseCoreImpl.PUBLIC_POST_DATE;
        }
        if (sortfield.equals(DataBaseCoreImpl.PUBLIC_POST_DATE)) {
            if (reverse) {
                q.descend("LocalDate").orderDescending();
            } else {
                q.descend("LocalDate").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PUBLIC_POST_ID0)) {
            if (reverse) {
                q.descend("PublicPost").descend("Signature").descend("Digest").descend("Index0").orderDescending();
            } else {
                q.descend("PublicPost").descend("Signature").descend("Digest").descend("Index0").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PUBLIC_POST_ID1)) {
            if (reverse) {
                q.descend("PublicPost").descend("Signature").descend("Digest").descend("Index1").orderDescending();
            } else {
                q.descend("PublicPost").descend("Signature").descend("Digest").descend("Index1").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PUBLIC_POST_PEERID0)) {
            if (reverse) {
                q.descend("PublicPost").descend("Signature").descend("PeerIdentifier").descend("Index0").orderDescending();
            } else {
                q.descend("PublicPost").descend("Signature").descend("PeerIdentifier").descend("Index0").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PUBLIC_POST_PEERID1)) {
            if (reverse) {
                q.descend("PublicPost").descend("Signature").descend("PeerIdentifier").descend("Index1").orderDescending();
            } else {
                q.descend("PublicPost").descend("Signature").descend("PeerIdentifier").descend("Index1").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PUBLIC_POST_MESSAGE)) {
            if (reverse) {
                q.descend("PublicPost").descend("Message").orderDescending();
            } else {
                q.descend("PublicPost").descend("Message").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PUBLIC_POST_DECODED_MESSAGE)) {
            if (reverse) {
                q.descend("DecodedMessage").orderDescending();
            } else {
                q.descend("DecodedMessage").orderAscending();
            }
        }
        ObjectSet osa = q.execute();
        return new PublicPostQueryResultsObjectSetImpl((ObjectSet<LocalPublicPost>)osa, max);
    }

    private Sort getPeerSort(String col, boolean reverse) {
        if (col != null) {
            if (col.equals(DataBaseCoreImpl.PEER_ID0)) {
                return new Sort(new SortField(DataBaseCoreImpl.PEER_ID0, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.PEER_ID1)) {
                return new Sort(new SortField(DataBaseCoreImpl.PEER_ID1, SortField.Type.LONG, reverse));
            }
            if (col.equals(DataBaseCoreImpl.PEER_INTRO)) {
                return new Sort(new SortField(DataBaseCoreImpl.PEER_INTRO, SortField.Type.STRING, reverse));
            }
            if (col.equals(DataBaseCoreImpl.PEER_NICKNAME)) {
                return new Sort(new SortField(DataBaseCoreImpl.PEER_NICKNAME, SortField.Type.STRING, reverse));
            }
        }
        return new Sort(new SortField(DataBaseCoreImpl.PEER_DATE, SortField.Type.LONG, reverse));
    }

    @Override
    public QueryResultsInterface searchPeers(String terms, String sortfield, int max, boolean reverse) {
        Matcher m;
        if (terms != null && (m = Pattern.compile("\\S+").matcher(terms)).find()) {
            try {
                String qt = String.valueOf(DataBaseCoreImpl.PEER_NICKNAME) + ":" + terms + " OR " + DataBaseCoreImpl.PEER_INTRO + ":" + terms;
                File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseCoreImpl.INDEX_DIR);
                SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                Log.info("qstring: " + qt);
                org.apache.lucene.search.Query q = this.Parser.parse(qt, DataBaseCoreImpl.PEER_INTRO);
                TopFieldDocs d = null;
                d = searcher.search(q, null, max, this.getPeerSort(sortfield, reverse));
                Log.info("totalHits: " + d.totalHits);
                return new PeerQueryResultsImpl((TopDocs)d, searcher, reader, this.DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Query q = this.DB.query();
        q.constrain(LocalPeer.class);
        if (sortfield == null) {
            sortfield = DataBaseCoreImpl.PEER_DATE;
        }
        if (sortfield.equals(DataBaseCoreImpl.PEER_DATE)) {
            if (reverse) {
                q.descend("LocalDate").orderDescending();
            } else {
                q.descend("LocalDate").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PEER_ID0)) {
            if (reverse) {
                q.descend("Peer").descend("Identity").descend("Index0").orderDescending();
            } else {
                q.descend("Peer").descend("Identity").descend("Index0").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PEER_ID1)) {
            if (reverse) {
                q.descend("Peer").descend("Identity").descend("Index1").orderDescending();
            } else {
                q.descend("Peer").descend("Identity").descend("Index1").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PEER_INTRO)) {
            if (reverse) {
                q.descend("Peer").descend("Introduction").orderDescending();
            } else {
                q.descend("Peer").descend("Introduction").orderAscending();
            }
        }
        if (sortfield.equals(DataBaseCoreImpl.PEER_NICKNAME)) {
            if (reverse) {
                q.descend("Peer").descend("Nickname").orderDescending();
            } else {
                q.descend("Peer").descend("Nickname").orderAscending();
            }
        }
        ObjectSet osa = q.execute();
        return new PeerQueryResultsObjectSetImpl((ObjectSet<LocalPeer>)osa, max);
    }

    @Override
    public QueryResultsInterface queryNetworkAuths(BBytes networkid) {
        Query q = this.DB.query();
        q.constrain(LocalNetworkAuthorization.class);
        Constraint c0 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        q.descend("NetworkAuthorization").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1()).and(c0);
        q.descend("LocalDate").orderDescending();
        ObjectSet osa = q.execute();
        return new NetworkAuthQueryResultsObjectSetImpl((ObjectSet<LocalNetworkAuthorization>)osa, Integer.MAX_VALUE);
    }

    @Override
    public QueryResultsInterface queryMyNetworkAuths(String terms) {
        Matcher m;
        if (terms != null && (m = Pattern.compile("\\S+").matcher(terms)).find()) {
            try {
                String qt = "( " + DataBaseCoreImpl.NETWORK_TITLE + ":" + terms + " OR " + DataBaseCoreImpl.NETWORK_DESCRIPTION + ":" + terms + " ) AND " + DataBaseCoreImpl.NETWORK_AUTH + ":1";
                File idxdir = new File(String.valueOf(this.BaseDir) + File.separator + DataBaseCoreImpl.INDEX_DIR);
                SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
                DirectoryReader reader = DirectoryReader.open((Directory)fsdir);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                Log.info("qstring: " + qt);
                org.apache.lucene.search.Query q = this.Parser.parse(qt, DataBaseCoreImpl.NETWORK_DESCRIPTION);
                TopFieldDocs d = null;
                d = searcher.search(q, null, Integer.MAX_VALUE, this.getNetworkSort(DataBaseCoreImpl.NETWORK_DATE, true));
                Log.info("totalHits: " + d.totalHits);
                return new NetworkAuthQueryResultsImpl((TopDocs)d, searcher, reader, this.DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Query q = this.DB.query();
        q.constrain(MyPeerDataSO.class);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            MyPeerDataSO myd = (MyPeerDataSO)osa.get(0);
            BBytes myid = myd.getPeer().getPeer().getIdentity();
            q = this.DB.query();
            q.constrain(LocalNetworkAuthorization.class);
            Constraint c0 = q.descend("NetworkAuthorization").descend("PeerId").descend("Index0").constrain((Object)myid.getIndex0());
            q.descend("NetworkAuthorization").descend("PeerId").descend("Index1").constrain((Object)myid.getIndex1()).and(c0);
            ObjectSet osa2 = q.execute();
            return new NetworkAuthQueryResultsObjectSetImpl((ObjectSet<LocalNetworkAuthorization>)osa2, Integer.MAX_VALUE);
        }
        return new EmptyQueryResults();
    }
}

